/*
 * Decompiled with CFR 0.152.
 */
package signature.converter.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import signature.converter.Visibility;
import signature.model.IAnnotation;
import signature.model.IAnnotationElement;
import signature.model.IAnnotationField;
import signature.model.IApi;
import signature.model.IClassDefinition;
import signature.model.IClassReference;
import signature.model.IConstructor;
import signature.model.IEnumConstant;
import signature.model.IField;
import signature.model.IGenericDeclaration;
import signature.model.IMethod;
import signature.model.IPackage;
import signature.model.IParameter;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.ITypeVariableReference;
import signature.model.Kind;
import signature.model.Modifier;
import signature.model.impl.SigAnnotation;
import signature.model.impl.SigAnnotationElement;
import signature.model.impl.SigAnnotationField;
import signature.model.impl.SigApi;
import signature.model.impl.SigClassDefinition;
import signature.model.impl.SigClassReference;
import signature.model.impl.SigConstructor;
import signature.model.impl.SigEnumConstant;
import signature.model.impl.SigExecutableMember;
import signature.model.impl.SigField;
import signature.model.impl.SigMethod;
import signature.model.impl.SigPackage;
import signature.model.impl.SigParameter;
import signature.model.impl.SigPrimitiveType;
import signature.model.impl.SigTypeVariableDefinition;
import signature.model.impl.SigTypeVariableReference;
import signature.model.util.TypePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocletToSigConverter {
    TypePool pool;
    Set<String> packageNames;
    private SigTypeVariableDefinition currentTypeVariableDefinition = null;
    private Stack<SigMethod> currentMethod = new Stack();
    private Stack<SigConstructor> currentConstructor = new Stack();

    public IApi convertDocletRoot(String name, RootDoc root, Visibility visibility, Set<String> packageNames) {
        this.pool = new TypePool();
        this.packageNames = packageNames;
        HashSet<IPackage> packages = new HashSet<IPackage>();
        for (PackageDoc pack : root.specifiedPackages()) {
            assert (packageNames.contains(pack.name()));
            packages.add(this.convertPackage(pack));
        }
        SigApi sources = new SigApi(name, visibility);
        sources.setPackages(packages);
        return sources;
    }

    private IPackage convertPackage(PackageDoc packageDoc) {
        HashSet<IClassDefinition> classes = new HashSet<IClassDefinition>();
        for (ClassDoc clazz : packageDoc.allClasses()) {
            classes.add(this.convertClass(clazz));
        }
        SigPackage p = new SigPackage(packageDoc.name());
        p.setClasses(classes);
        p.setAnnotations(this.convertAnnotations(packageDoc.annotations()));
        return p;
    }

    private SigClassDefinition convertClass(ClassDoc classDoc) {
        Type superclassType;
        SigClassDefinition c = this.pool.getClass(classDoc.containingPackage().name(), classDoc.name());
        if (c.getKind() != Kind.UNINITIALIZED) {
            return c;
        }
        if (classDoc.isEnum()) {
            c.setKind(Kind.ENUM);
        } else if (classDoc.isInterface()) {
            c.setKind(Kind.INTERFACE);
        } else if (classDoc.isClass()) {
            c.setKind(Kind.CLASS);
        } else if (classDoc.isAnnotationType()) {
            c.setKind(Kind.ANNOTATION);
        }
        if (!this.packageNames.contains(c.getPackageName())) {
            this.initializeClass(c);
            return c;
        }
        c.setModifiers(this.convertModifiers(classDoc.modifierSpecifier()));
        if (Kind.INTERFACE.equals((Object)c.getKind()) || Kind.ANNOTATION.equals((Object)c.getKind())) {
            c.getModifiers().add(Modifier.ABSTRACT);
        }
        if ((superclassType = classDoc.superclassType()) != null) {
            c.setSuperClass(this.convertTypeReference(classDoc.superclassType()));
        } else {
            c.setSuperClass(null);
        }
        HashSet<ITypeReference> interfaces = new HashSet<ITypeReference>();
        for (Type interfaceType : classDoc.interfaceTypes()) {
            interfaces.add(this.convertTypeReference(interfaceType));
        }
        c.setInterfaces(interfaces);
        ClassDoc containingClass = classDoc.containingClass();
        if (containingClass != null) {
            c.setDeclaringClass(this.convertClass(containingClass));
        } else {
            c.setDeclaringClass(null);
        }
        HashSet<IClassDefinition> innerClasses = new HashSet<IClassDefinition>();
        for (ClassDoc innerClass : classDoc.innerClasses()) {
            innerClasses.add(this.convertClass(innerClass));
        }
        c.setInnerClasses(innerClasses);
        HashSet<IConstructor> constructors = new HashSet<IConstructor>();
        for (ConstructorDoc constructor : classDoc.constructors()) {
            constructors.add(this.convertConstructor(constructor));
        }
        c.setConstructors(constructors);
        HashSet<IMethod> methods = new HashSet<IMethod>();
        for (MethodDoc method : classDoc.methods()) {
            methods.add(this.convertMethod(method));
        }
        c.setMethods(methods);
        HashSet<IField> fields = new HashSet<IField>();
        for (FieldDoc field : classDoc.fields()) {
            fields.add(this.convertField(field));
        }
        c.setFields(fields);
        HashSet<IEnumConstant> enumConstants = new HashSet<IEnumConstant>();
        int ordinal = 0;
        for (FieldDoc enumConstant : classDoc.enumConstants()) {
            enumConstants.add(this.convertEnumConstant(enumConstant, ordinal++));
        }
        c.setEnumConstants(enumConstants);
        LinkedList<ITypeVariableDefinition> typeParameters = new LinkedList<ITypeVariableDefinition>();
        for (TypeVariable typeVariable : classDoc.typeParameters()) {
            typeParameters.add(((ITypeVariableReference)this.convertTypeReference((Type)typeVariable)).getTypeVariableDefinition());
        }
        c.setTypeParameters(typeParameters);
        if (classDoc.isAnnotationType()) {
            HashMap<SigAnnotationField, AnnotationTypeElementDoc> annotationFieldAnnotations = new HashMap<SigAnnotationField, AnnotationTypeElementDoc>();
            AnnotationTypeDoc annotationType = (AnnotationTypeDoc)classDoc;
            HashSet<IAnnotationField> annotationFields = new HashSet<IAnnotationField>();
            for (AnnotationTypeElementDoc annotationElement : annotationType.elements()) {
                SigAnnotationField annotationField = new SigAnnotationField(annotationElement.name());
                annotationField.setModifiers(this.convertModifiers(annotationElement.modifierSpecifier()));
                annotationField.setType(this.convertTypeReference(annotationElement.returnType()));
                annotationField.setDefaultValue(this.convertAnnotationValue(annotationElement.defaultValue()));
                annotationFieldAnnotations.put(annotationField, annotationElement);
                annotationFields.add(annotationField);
            }
            c.setAnnotationFields(annotationFields);
            for (Map.Entry entry : annotationFieldAnnotations.entrySet()) {
                ((SigAnnotationField)entry.getKey()).setAnnotations(this.convertAnnotations(((AnnotationTypeElementDoc)entry.getValue()).annotations()));
            }
        } else {
            c.setAnnotationFields(null);
        }
        c.setAnnotations(this.convertAnnotations(classDoc.annotations()));
        return c;
    }

    private Object convertAnnotationValue(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        Object value = annotationValue.value();
        if (value instanceof Type) {
            return this.convertTypeReference((Type)value);
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Character || value instanceof Boolean) {
            return value;
        }
        if (value instanceof FieldDoc) {
            FieldDoc field = (FieldDoc)value;
            String name = field.name();
            ITypeReference fieldType = this.convertTypeReference(field.type());
            IClassReference fieldClassRef = (IClassReference)fieldType;
            IClassDefinition fieldClass = fieldClassRef.getClassDefinition();
            assert (fieldClass.getKind() == Kind.ENUM);
            Set<IEnumConstant> constants = fieldClass.getEnumConstants();
            for (IEnumConstant enumConstant : constants) {
                if (!enumConstant.getName().equals(name)) continue;
                value = enumConstant;
            }
            assert (value instanceof IEnumConstant);
            return value;
        }
        if (value instanceof AnnotationDesc) {
            return this.convertAnnotation((AnnotationDesc)value);
        }
        if (value instanceof AnnotationValue) {
            return this.convertAnnotationValue((AnnotationValue)value);
        }
        if (value instanceof AnnotationValue[]) {
            AnnotationValue[] arr = (AnnotationValue[])value;
            int length = arr.length;
            Object[] annotationArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                annotationArray[i] = this.convertAnnotationValue(arr[i]);
            }
            return annotationArray;
        }
        throw new RuntimeException("not expected case");
    }

    private ITypeReference convertArrayType(Type type) {
        assert (type.asWildcardType() == null);
        assert (type.asAnnotationTypeDoc() == null);
        ITypeReference baseType = null;
        if (type.asTypeVariable() != null) {
            baseType = this.convertTypeReference((Type)type.asTypeVariable());
        } else if (type.asParameterizedType() != null) {
            baseType = this.convertTypeReference((Type)type.asParameterizedType());
        } else if (type.asClassDoc() != null) {
            baseType = new SigClassReference(this.convertClass(type.asClassDoc()));
        } else if (type.isPrimitive()) {
            baseType = SigPrimitiveType.valueOfTypeName(type.typeName());
        } else {
            throw new RuntimeException(type.toString());
        }
        ITypeReference arrayType = baseType;
        for (int dimension = type.dimension().length() / 2; dimension > 0; --dimension) {
            arrayType = this.pool.getArrayType(arrayType);
        }
        return arrayType;
    }

    private ITypeReference convertTypeReference(Type type) {
        assert (type != null);
        if (!"".equals(type.dimension())) {
            return this.convertArrayType(type);
        }
        ParameterizedType pType = type.asParameterizedType();
        if (pType != null) {
            ITypeReference ownerType = null;
            Type containingType = pType.containingType();
            if (containingType != null) {
                ownerType = this.convertTypeReference(containingType);
            }
            SigClassReference rawType = new SigClassReference(this.convertClass(pType.asClassDoc()));
            LinkedList<ITypeReference> typeArguments = new LinkedList<ITypeReference>();
            for (Type typeArgument : pType.typeArguments()) {
                typeArguments.add(this.convertTypeReference(typeArgument));
            }
            if (typeArguments.size() > 0) {
                return this.pool.getParameterizedType(ownerType, rawType, typeArguments);
            }
            return rawType;
        }
        TypeVariable tv = type.asTypeVariable();
        if (tv != null) {
            String name = tv.typeName();
            if (this.currentTypeVariableDefinition != null && name.equals(this.currentTypeVariableDefinition.getName())) {
                return new SigTypeVariableReference(this.currentTypeVariableDefinition);
            }
            IGenericDeclaration genericDeclaration = null;
            ProgramElementDoc programElement = tv.owner();
            if (programElement instanceof ClassDoc) {
                genericDeclaration = this.convertClass((ClassDoc)programElement);
            } else if (programElement instanceof MethodDoc && this.currentMethod.size() > 0) {
                genericDeclaration = this.currentMethod.peek();
            } else if (programElement instanceof ConstructorDoc && this.currentConstructor.size() > 0) {
                genericDeclaration = this.currentConstructor.peek();
            } else {
                throw new IllegalStateException("situation not expected");
            }
            SigTypeVariableDefinition typeVariable = this.pool.getTypeVariable(name, genericDeclaration);
            LinkedList<ITypeReference> upperBounds = new LinkedList<ITypeReference>();
            for (Type upperBound : tv.bounds()) {
                assert (this.currentTypeVariableDefinition == null);
                this.currentTypeVariableDefinition = typeVariable;
                upperBounds.add(this.convertTypeReference(upperBound));
                this.currentTypeVariableDefinition = null;
            }
            if (upperBounds.size() == 0) {
                upperBounds.add(this.pool.getClassReference("java.lang", "Object"));
            }
            typeVariable.setUpperBounds(upperBounds);
            return new SigTypeVariableReference(typeVariable);
        }
        WildcardType wt = type.asWildcardType();
        if (wt != null) {
            ITypeReference lowerBound = null;
            for (Type superBound : wt.superBounds()) {
                lowerBound = this.convertTypeReference(superBound);
            }
            LinkedList<ITypeReference> upperBounds = new LinkedList<ITypeReference>();
            for (Type upperBound : wt.extendsBounds()) {
                upperBounds.add(this.convertTypeReference(upperBound));
            }
            if (upperBounds.size() == 0) {
                upperBounds.add(this.pool.getClassReference("java.lang", "Object"));
            }
            return this.pool.getWildcardType(lowerBound, upperBounds);
        }
        ClassDoc c = type.asClassDoc();
        if (c != null) {
            return new SigClassReference(this.convertClass(c));
        }
        if (type.isPrimitive()) {
            return SigPrimitiveType.valueOfTypeName(type.typeName());
        }
        throw new IllegalStateException(type.toString());
    }

    private void convertExecutableMember(ExecutableMemberDoc member, SigExecutableMember m) {
        Set<Modifier> modifiers = this.convertModifiers(member.modifierSpecifier());
        if (member.containingClass().isEnum() && member.name().equals("values") && member.parameters().length == 0) {
            modifiers.add(Modifier.FINAL);
        }
        if (member.containingClass().isInterface()) {
            modifiers.add(Modifier.ABSTRACT);
        }
        m.setModifiers(modifiers);
        m.setAnnotations(this.convertAnnotations(member.annotations()));
        m.setDeclaringClass(this.convertClass(member.containingClass()));
        LinkedList<ITypeVariableDefinition> typeParameters = new LinkedList<ITypeVariableDefinition>();
        for (TypeVariable typeParameter : member.typeParameters()) {
            String name = typeParameter.typeName();
            IGenericDeclaration genericDeclaration = null;
            if (this.currentMethod.size() > 0) {
                genericDeclaration = this.currentMethod.peek();
            } else if (this.currentConstructor.size() > 0) {
                genericDeclaration = this.currentConstructor.peek();
            } else {
                throw new RuntimeException();
            }
            SigTypeVariableDefinition p = this.pool.getTypeVariable(name, genericDeclaration);
            LinkedList<ITypeReference> upperBounds = new LinkedList<ITypeReference>();
            for (Type u : typeParameter.bounds()) {
                upperBounds.add(this.convertTypeReference(u));
            }
            p.setUpperBounds(upperBounds);
            typeParameters.add(p);
        }
        m.setTypeParameters(typeParameters);
        LinkedList<IParameter> parameters = new LinkedList<IParameter>();
        for (Parameter parameter : member.parameters()) {
            SigParameter p = new SigParameter(this.convertTypeReference(parameter.type()));
            p.setAnnotations(this.convertAnnotations(parameter.annotations()));
            parameters.add(p);
        }
        m.setParameters(parameters);
        HashSet<ITypeReference> exceptions = new HashSet<ITypeReference>();
        for (Type exceptionType : member.thrownExceptionTypes()) {
            exceptions.add(this.convertTypeReference(exceptionType));
        }
        m.setExceptions(exceptions);
    }

    private IMethod convertMethod(MethodDoc method) {
        SigMethod m = new SigMethod(method.name());
        this.currentMethod.push(m);
        this.convertExecutableMember((ExecutableMemberDoc)method, m);
        m.setReturnType(this.convertTypeReference(method.returnType()));
        this.currentMethod.pop();
        return m;
    }

    private IConstructor convertConstructor(ConstructorDoc constructor) {
        SigConstructor c = new SigConstructor(constructor.name());
        this.currentConstructor.push(c);
        this.convertExecutableMember((ExecutableMemberDoc)constructor, c);
        this.currentConstructor.pop();
        return c;
    }

    private IField convertField(FieldDoc field) {
        SigField f = new SigField(field.name());
        f.setAnnotations(this.convertAnnotations(field.annotations()));
        f.setModifiers(this.convertModifiers(field.modifierSpecifier()));
        f.setType(this.convertTypeReference(field.type()));
        return f;
    }

    private IEnumConstant convertEnumConstant(FieldDoc enumConstant, int ordinal) {
        SigEnumConstant ec = new SigEnumConstant(enumConstant.name());
        ec.setOrdinal(ordinal);
        ec.setAnnotations(this.convertAnnotations(enumConstant.annotations()));
        ec.setModifiers(this.convertModifiers(enumConstant.modifierSpecifier()));
        ec.setType(this.convertTypeReference(enumConstant.type()));
        return ec;
    }

    private Set<IAnnotation> convertAnnotations(AnnotationDesc[] annotationDescs) {
        HashSet<IAnnotation> annotations = new HashSet<IAnnotation>();
        for (AnnotationDesc annotationDesc : annotationDescs) {
            if (this.annotationRetentionIsSource(annotationDesc)) continue;
            annotations.add(this.convertAnnotation(annotationDesc));
        }
        return annotations;
    }

    private boolean annotationRetentionIsSource(AnnotationDesc annotationDesc) {
        AnnotationDesc[] annotations;
        AnnotationTypeDoc type = annotationDesc.annotationType();
        for (AnnotationDesc d : annotations = type.annotations()) {
            if (!"java.lang.annotation.Retention".equals(d.annotationType().qualifiedName())) continue;
            for (AnnotationDesc.ElementValuePair value : d.elementValues()) {
                if (!"value".equals(value.element().name())) continue;
                return "java.lang.annotation.RetentionPolicy.SOURCE".equals(value.value().value().toString());
            }
        }
        return false;
    }

    private IAnnotation convertAnnotation(AnnotationDesc annotationDesc) {
        SigAnnotation a = new SigAnnotation();
        IClassReference annotationType = (IClassReference)this.convertTypeReference((Type)annotationDesc.annotationType());
        a.setType(annotationType);
        HashSet<IAnnotationElement> elements = new HashSet<IAnnotationElement>();
        for (AnnotationDesc.ElementValuePair pair : annotationDesc.elementValues()) {
            SigAnnotationElement element = new SigAnnotationElement();
            elements.add(element);
            element.setValue(this.convertAnnotationValue(pair.value()));
            String name = pair.element().name();
            for (IAnnotationField field : annotationType.getClassDefinition().getAnnotationFields()) {
                if (!field.getName().equals(name)) continue;
                element.setDeclaringField(field);
            }
        }
        a.setElements(elements);
        return a;
    }

    private void initializeClass(SigClassDefinition c) {
        c.setAnnotationFields(null);
        c.setAnnotations(null);
        c.setConstructors(null);
        c.setDeclaringClass(null);
        c.setEnumConstants(null);
        c.setFields(null);
        c.setInnerClasses(null);
        c.setInterfaces(null);
        c.setMethods(null);
        c.setModifiers(null);
        c.setSuperClass(null);
        c.setTypeParameters(null);
    }

    private Set<Modifier> convertModifiers(int mod) {
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (java.lang.reflect.Modifier.isAbstract(mod)) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if (java.lang.reflect.Modifier.isFinal(mod)) {
            modifiers.add(Modifier.FINAL);
        }
        if (java.lang.reflect.Modifier.isPrivate(mod)) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (java.lang.reflect.Modifier.isProtected(mod)) {
            modifiers.add(Modifier.PROTECTED);
        }
        if (java.lang.reflect.Modifier.isPublic(mod)) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (java.lang.reflect.Modifier.isStatic(mod)) {
            modifiers.add(Modifier.STATIC);
        }
        if (java.lang.reflect.Modifier.isVolatile(mod)) {
            modifiers.add(Modifier.VOLATILE);
        }
        return modifiers;
    }
}

