/*
 * Decompiled with CFR 0.152.
 */
package signature.converter.dex;

import dex.structure.DexAnnotatedElement;
import dex.structure.DexAnnotation;
import dex.structure.DexAnnotationAttribute;
import dex.structure.DexClass;
import dex.structure.DexEncodedAnnotation;
import dex.structure.DexEncodedValue;
import dex.structure.DexField;
import dex.structure.DexFile;
import dex.structure.DexMethod;
import dex.structure.DexParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import signature.converter.Visibility;
import signature.converter.dex.DexUtil;
import signature.converter.dex.FieldPool;
import signature.converter.dex.GenericSignatureParser;
import signature.converter.dex.IClassInitializer;
import signature.model.IAnnotation;
import signature.model.IAnnotationElement;
import signature.model.IAnnotationField;
import signature.model.IClassDefinition;
import signature.model.IClassReference;
import signature.model.IConstructor;
import signature.model.IEnumConstant;
import signature.model.IField;
import signature.model.IPackage;
import signature.model.IParameter;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.Kind;
import signature.model.Modifier;
import signature.model.impl.SigAnnotation;
import signature.model.impl.SigAnnotationElement;
import signature.model.impl.SigAnnotationField;
import signature.model.impl.SigApi;
import signature.model.impl.SigClassDefinition;
import signature.model.impl.SigClassReference;
import signature.model.impl.SigConstructor;
import signature.model.impl.SigEnumConstant;
import signature.model.impl.SigExecutableMember;
import signature.model.impl.SigField;
import signature.model.impl.SigMethod;
import signature.model.impl.SigPackage;
import signature.model.impl.SigParameter;
import signature.model.impl.Uninitialized;
import signature.model.util.TypePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DexToSigConverter
implements IClassInitializer {
    private final FieldPool elementPool;
    private final TypePool factory = new TypePool();
    private static final Set<IField> EMPTY_FIELDS = Collections.emptySet();
    private static final Set<IEnumConstant> EMPTY_ENUM_CONSTANTS = Collections.emptySet();
    private static final Set<IAnnotationField> EMPTY_ANNOTATION_FIELDS = Collections.emptySet();
    private static final List<ITypeVariableDefinition> EMPTY_TYPE_VARIABLES = Collections.emptyList();
    private static final Set<IClassDefinition> EMPTY_INNER_CLASSES = Collections.emptySet();
    private static final Set<ITypeReference> EMPTY_EXCEPTIONS = Collections.emptySet();
    private Visibility visibility;
    private Map<String, DexClass> dexNameToDexClass;

    public DexToSigConverter() {
        this.elementPool = new FieldPool();
    }

    public SigApi convertApi(String apiName, Set<DexFile> dexFiles, Visibility visibility) {
        this.visibility = visibility;
        SigApi api = new SigApi(apiName, visibility);
        api.setPackages(this.convertPackages(dexFiles));
        this.factory.replaceAllUninitialiezWithNull();
        return api;
    }

    Set<IPackage> convertPackages(Set<DexFile> parsedFiles) {
        HashMap<String, SigPackage> packageNameToPackage = new HashMap<String, SigPackage>();
        HashMap<SigPackage, HashSet<DexClass>> packageToDexClasses = new HashMap<SigPackage, HashSet<DexClass>>();
        this.dexNameToDexClass = new HashMap<String, DexClass>();
        for (DexFile dexFile : parsedFiles) {
            List definedClasses = dexFile.getDefinedClasses();
            for (DexClass dexClass : definedClasses) {
                HashSet<DexClass> classes;
                this.dexNameToDexClass.put(dexClass.getName(), dexClass);
                String dexName = dexClass.getName();
                String packageName = DexUtil.getPackageName(dexName);
                SigPackage aPackage = (SigPackage)packageNameToPackage.get(packageName);
                if (aPackage == null) {
                    aPackage = this.convertPackage(packageName);
                    packageNameToPackage.put(packageName, aPackage);
                    classes = new HashSet<DexClass>();
                    packageToDexClasses.put(aPackage, classes);
                }
                classes = (HashSet<DexClass>)packageToDexClasses.get(aPackage);
                classes.add(dexClass);
            }
        }
        HashSet<SigClassDefinition> allClasses = new HashSet<SigClassDefinition>();
        for (SigPackage aPackage : packageToDexClasses.keySet()) {
            Set<SigClassDefinition> classes = this.convertClasses((Set)packageToDexClasses.get(aPackage));
            allClasses.addAll(classes);
            aPackage.setClasses(new HashSet<IClassDefinition>(classes));
        }
        for (SigPackage aPackage : packageToDexClasses.keySet()) {
            IClassDefinition packageInfo = DexUtil.findPackageInfo(aPackage);
            if (packageInfo == null) continue;
            aPackage.setAnnotations(packageInfo.getAnnotations());
            aPackage.getClasses().remove(packageInfo);
        }
        for (SigClassDefinition sigClass : allClasses) {
            DexClass dexClass;
            String dexName = DexUtil.getDexName(sigClass);
            dexClass = this.dexNameToDexClass.get(dexName);
            if (DexUtil.declaresMemberClasses(dexClass)) {
                Set<String> enclosedClassesNames = DexUtil.getMemberClassNames(dexClass);
                HashSet<IClassDefinition> memberClasses = new HashSet<IClassDefinition>();
                for (String enclosedClassName : enclosedClassesNames) {
                    SigClassDefinition memberClass = this.factory.getClass(DexUtil.getPackageName(enclosedClassName), DexUtil.getClassName(enclosedClassName));
                    if (!allClasses.contains(memberClass)) continue;
                    memberClasses.add(memberClass);
                }
                sigClass.setInnerClasses(memberClasses);
                continue;
            }
            sigClass.setInnerClasses(EMPTY_INNER_CLASSES);
        }
        for (SigClassDefinition sigClass : allClasses) {
            if (!this.hasInvisibleParent(sigClass, this.dexNameToDexClass)) continue;
            SigPackage sigPackage = (SigPackage)packageNameToPackage.get(sigClass.getPackageName());
            sigPackage.getClasses().remove(sigClass);
        }
        return new HashSet<IPackage>(packageToDexClasses.keySet());
    }

    private boolean hasInvisibleParent(IClassDefinition sigClass, Map<String, DexClass> dexNameToDexClass) {
        do {
            IClassDefinition declaringClass;
            DexClass declaringDexClass;
            String dexName;
            DexClass dexClass;
            if (!DexUtil.isEnclosingClass(dexClass = dexNameToDexClass.get(dexName = DexUtil.getDexName(sigClass))) || DexUtil.isVisible(declaringDexClass = dexNameToDexClass.get(DexUtil.getDexName(declaringClass = sigClass.getDeclaringClass())), this.visibility)) continue;
            return true;
        } while ((sigClass = sigClass.getDeclaringClass()) != null);
        return false;
    }

    protected SigPackage convertPackage(String packageName) {
        SigPackage sigPackage = new SigPackage(packageName);
        return sigPackage;
    }

    protected Set<SigClassDefinition> convertClasses(Set<DexClass> dexClasses) {
        HashSet<SigClassDefinition> classes = new HashSet<SigClassDefinition>();
        for (DexClass dexClass : dexClasses) {
            if (!DexUtil.convertAnyWay(dexClass)) continue;
            SigClassDefinition sigCLass = this.convertClass(dexClass);
            if (!DexUtil.isVisible(dexClass, this.visibility)) continue;
            classes.add(sigCLass);
        }
        return classes;
    }

    protected SigClassDefinition convertClass(DexClass dexClass) {
        assert (dexClass != null);
        String packageName = DexUtil.getPackageName(dexClass.getName());
        String className = DexUtil.getClassName(dexClass.getName());
        SigClassDefinition sigClass = this.factory.getClass(packageName, className);
        sigClass.setKind(DexUtil.getKind(dexClass));
        Set<Modifier> modifiers = DexUtil.getModifier(DexUtil.getClassModifiers(dexClass));
        sigClass.setModifiers(modifiers);
        if (DexUtil.isEnclosingClass(dexClass)) {
            String declaringClassDexName = DexUtil.getEnclosingClassName(dexClass);
            declaringClassDexName = DexUtil.getClassName(declaringClassDexName);
            sigClass.setDeclaringClass(this.factory.getClass(sigClass.getPackageName(), declaringClassDexName));
        } else {
            sigClass.setDeclaringClass(null);
        }
        if (DexUtil.hasGenericSignature((DexAnnotatedElement)dexClass)) {
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            parser.parseForClass(sigClass, DexUtil.getGenericSignature((DexAnnotatedElement)dexClass));
            sigClass.setTypeParameters(parser.formalTypeParameters);
            if (Kind.INTERFACE.equals((Object)sigClass.getKind())) {
                sigClass.setSuperClass(null);
            } else {
                sigClass.setSuperClass(parser.superclassType);
            }
            sigClass.setInterfaces(new HashSet<ITypeReference>(parser.interfaceTypes));
        } else {
            sigClass.setTypeParameters(EMPTY_TYPE_VARIABLES);
            if (DexUtil.isJavaLangObject(dexClass)) {
                sigClass.setSuperClass(null);
            } else if (Kind.INTERFACE.equals((Object)sigClass.getKind()) || Kind.ANNOTATION.equals((Object)sigClass.getKind())) {
                sigClass.setSuperClass(null);
            } else {
                String superClassPackageName = DexUtil.getPackageName(dexClass.getSuperClass());
                String superClassName = DexUtil.getClassName(dexClass.getSuperClass());
                sigClass.setSuperClass(this.factory.getClassReference(superClassPackageName, superClassName));
            }
            List interfaceDexNames = dexClass.getInterfaces();
            HashSet<ITypeReference> interfaces = new HashSet<ITypeReference>();
            for (String string : interfaceDexNames) {
                String interfacePackageName = DexUtil.getPackageName(string);
                String interfaceName = DexUtil.getClassName(string);
                SigClassDefinition interfaze = this.factory.getClass(interfacePackageName, interfaceName);
                interfaze.setKind(Kind.INTERFACE);
                interfaces.add(new SigClassReference(interfaze));
            }
            sigClass.setInterfaces(interfaces);
        }
        Set<SigConstructor> constructors = this.convertConstructors(dexClass.getMethods());
        for (SigConstructor constructor : constructors) {
            constructor.setDeclaringClass(sigClass);
        }
        sigClass.setConstructors(new HashSet<IConstructor>(constructors));
        Set<Object> methods = Collections.emptySet();
        if (DexUtil.isAnnotation(dexClass)) {
            Map<String, Object> mappings = this.getDefaultValueMapping(dexClass);
            Set<SigAnnotationField> set = this.convertAnnotationFields(dexClass.getMethods(), mappings);
            sigClass.setAnnotationFields(new HashSet<IAnnotationField>(set));
            this.addAnnotationsToAnnotationFields(dexClass.getMethods(), set);
            sigClass.setEnumConstants(EMPTY_ENUM_CONSTANTS);
            sigClass.setFields(EMPTY_FIELDS);
        } else if (DexUtil.isEnum(dexClass)) {
            HashSet<IField> fields = new HashSet<IField>();
            HashSet<IEnumConstant> hashSet = new HashSet<IEnumConstant>();
            for (DexField dexField : dexClass.getFields()) {
                if (!DexUtil.isVisible(dexField, this.visibility)) continue;
                if (dexField.isEnumConstant()) {
                    hashSet.add(this.convertEnumConstant(dexField));
                    continue;
                }
                fields.add(this.convertField(dexField));
            }
            sigClass.setFields(fields);
            sigClass.setEnumConstants(hashSet);
            sigClass.setAnnotationFields(EMPTY_ANNOTATION_FIELDS);
            methods = this.convertMethods(dexClass.getMethods());
        } else {
            sigClass.setFields(new HashSet<IField>(this.convertFields(dexClass.getFields())));
            sigClass.setEnumConstants(EMPTY_ENUM_CONSTANTS);
            sigClass.setAnnotationFields(EMPTY_ANNOTATION_FIELDS);
            methods = this.convertMethods(dexClass.getMethods());
        }
        for (SigMethod sigMethod : methods) {
            sigMethod.setDeclaringClass(sigClass);
        }
        sigClass.setMethods(new HashSet<Object>(methods));
        sigClass.setAnnotations(this.convertAnnotations(dexClass.getAnnotations()));
        return sigClass;
    }

    private Map<String, Object> getDefaultValueMapping(DexClass dexClass) {
        DexAnnotation annotation;
        DexAnnotationAttribute dexAnnotationAttribute;
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        if (DexUtil.hasAnnotationDefaultSignature((DexAnnotatedElement)dexClass) && "value".equals((dexAnnotationAttribute = (DexAnnotationAttribute)(annotation = DexUtil.getDefaultMappingsAnnotation(dexClass)).getAttributes().get(0)).getName())) {
            DexEncodedValue encodedValue = dexAnnotationAttribute.getEncodedValue();
            DexEncodedValue value = (DexEncodedValue)encodedValue.getValue();
            List defaults = (List)value.getValue();
            for (DexAnnotationAttribute defaultAttribute : defaults) {
                mappings.put(defaultAttribute.getName(), this.convertEncodedValue(defaultAttribute.getEncodedValue()));
            }
        }
        return mappings;
    }

    private void addAnnotationsToAnnotationFields(List<DexMethod> methods, Set<SigAnnotationField> annotationFields) {
        HashMap<String, SigAnnotationField> nameToAnnotationField = new HashMap<String, SigAnnotationField>();
        for (SigAnnotationField annotationField : annotationFields) {
            nameToAnnotationField.put(annotationField.getName(), annotationField);
        }
        for (DexMethod method : methods) {
            SigAnnotationField annotationField = (SigAnnotationField)nameToAnnotationField.get(method.getName());
            annotationField.setAnnotations(this.convertAnnotations(method.getAnnotations()));
        }
    }

    private Set<SigAnnotationField> convertAnnotationFields(List<DexMethod> list, Map<String, Object> mappings) {
        HashSet<SigAnnotationField> annotationfields = new HashSet<SigAnnotationField>();
        for (DexMethod dexMethod : list) {
            if (!DexUtil.isVisible(dexMethod, this.visibility)) continue;
            annotationfields.add(this.convertAnnotationField(dexMethod, mappings.get(dexMethod.getName())));
        }
        return annotationfields;
    }

    private SigAnnotationField convertAnnotationField(DexMethod dexMethod, Object defaultValue) {
        SigAnnotationField annotationField = new SigAnnotationField(dexMethod.getName());
        annotationField.setDefaultValue(defaultValue);
        annotationField.setModifiers(DexUtil.getModifier(dexMethod.getModifiers()));
        GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
        annotationField.setType(parser.parseNonGenericType(dexMethod.getReturnType()));
        return annotationField;
    }

    private IEnumConstant convertEnumConstant(DexField dexField) {
        String qualifiedTypeName = DexUtil.getQualifiedName(dexField.getDeclaringClass().getName());
        SigEnumConstant enumConstant = this.elementPool.getEnumConstant(qualifiedTypeName, dexField.getName());
        Set<Modifier> modifiers = DexUtil.getModifier(dexField.getModifiers());
        modifiers.add(Modifier.STATIC);
        enumConstant.setModifiers(modifiers);
        String typePackageName = DexUtil.getPackageName(dexField.getType());
        String typeName = DexUtil.getClassName(dexField.getType());
        enumConstant.setType(this.factory.getClassReference(typePackageName, typeName));
        enumConstant.setAnnotations(this.convertAnnotations(dexField.getAnnotations()));
        return enumConstant;
    }

    private Set<SigField> convertFields(List<DexField> dexFields) {
        HashSet<SigField> fields = new HashSet<SigField>();
        for (DexField dexField : dexFields) {
            if (!DexUtil.isVisible(dexField, this.visibility)) continue;
            fields.add(this.convertField(dexField));
        }
        return fields;
    }

    private SigField convertField(DexField dexField) {
        String qualTypeName = DexUtil.getQualifiedName(dexField.getDeclaringClass().getName());
        SigField field = this.elementPool.getField(qualTypeName, dexField.getName());
        field.setModifiers(DexUtil.getModifier(dexField.getModifiers()));
        field.setAnnotations(this.convertAnnotations(dexField.getAnnotations()));
        if (DexUtil.hasGenericSignature((DexAnnotatedElement)dexField)) {
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            String declaringClassPackageName = DexUtil.getPackageName(dexField.getDeclaringClass().getName());
            String declaringClassName = DexUtil.getClassName(dexField.getDeclaringClass().getName());
            parser.parseForField(this.factory.getClass(declaringClassPackageName, declaringClassName), DexUtil.getGenericSignature((DexAnnotatedElement)dexField));
            field.setType(parser.fieldType);
        } else {
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            field.setType(parser.parseNonGenericType(dexField.getType()));
        }
        return field;
    }

    private Set<SigConstructor> convertConstructors(List<DexMethod> methods) {
        HashSet<SigConstructor> constructors = new HashSet<SigConstructor>();
        for (DexMethod method : methods) {
            if (!DexUtil.isConstructor(method) || !DexUtil.isVisible(method, this.visibility)) continue;
            constructors.add(this.convertConstructor(method));
        }
        return constructors;
    }

    private Set<SigMethod> convertMethods(List<DexMethod> methods) {
        HashSet<SigMethod> sigMethods = new HashSet<SigMethod>();
        for (DexMethod method : methods) {
            if (!DexUtil.isMethod(method) || !DexUtil.isVisible(method, this.visibility)) continue;
            sigMethods.add(this.convertMethod(method));
        }
        return sigMethods;
    }

    public SigConstructor convertConstructor(DexMethod dexMethod) {
        String declaringClassName = DexUtil.getClassName(dexMethod.getDeclaringClass().getName());
        SigConstructor constructor = new SigConstructor(declaringClassName);
        constructor.setModifiers(DexUtil.getModifier(dexMethod.getModifiers()));
        String declaringClassPackageName = DexUtil.getPackageName(dexMethod.getDeclaringClass().getName());
        SigClassDefinition declaringClass = this.factory.getClass(declaringClassPackageName, declaringClassName);
        constructor.setDeclaringClass(declaringClass);
        constructor.setAnnotations(this.convertAnnotations(dexMethod.getAnnotations()));
        if (DexUtil.hasGenericSignature((DexAnnotatedElement)dexMethod)) {
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            parser.parseForConstructor(constructor, DexUtil.getGenericSignature((DexAnnotatedElement)dexMethod));
            constructor.setTypeParameters(parser.formalTypeParameters);
            List dexParameters = dexMethod.getParameters();
            ArrayList<IParameter> parameters = new ArrayList<IParameter>(parser.parameterTypes.size());
            Iterator iterator = dexParameters.iterator();
            for (ITypeReference parameterType : parser.parameterTypes) {
                SigParameter parameter = new SigParameter(parameterType);
                iterator.hasNext();
                DexParameter dexParam = (DexParameter)iterator.next();
                parameter.setAnnotations(this.convertAnnotations(dexParam.getAnnotations()));
                parameters.add(parameter);
            }
            constructor.setParameters(parameters);
            constructor.setExceptions(new HashSet<ITypeReference>(parser.exceptionTypes));
        } else {
            this.convertNonGenericExecutableMember(constructor, dexMethod);
            if (declaringClass.getDeclaringClass() != null && !declaringClass.getModifiers().contains((Object)Modifier.STATIC)) {
                String firstParameterTypeName;
                if (constructor.getParameters().isEmpty()) {
                    throw new IllegalStateException("Expected at least one parameter!");
                }
                IParameter first = constructor.getParameters().remove(0);
                String enclosingName = declaringClass.getDeclaringClass().getName();
                if (!enclosingName.equals(firstParameterTypeName = ((IClassReference)first.getType()).getClassDefinition().getName())) {
                    throw new IllegalStateException("Expected first constructor parameter of type " + enclosingName);
                }
            }
        }
        this.addExceptions(constructor, dexMethod);
        return constructor;
    }

    public SigMethod convertMethod(DexMethod dexMethod) {
        SigMethod method = new SigMethod(dexMethod.getName());
        method.setModifiers(DexUtil.getModifier(dexMethod.getModifiers()));
        String declaringClassPackageName = DexUtil.getPackageName(dexMethod.getDeclaringClass().getName());
        String declaringClassName = DexUtil.getClassName(dexMethod.getDeclaringClass().getName());
        method.setDeclaringClass(this.factory.getClass(declaringClassPackageName, declaringClassName));
        method.setAnnotations(this.convertAnnotations(dexMethod.getAnnotations()));
        if (DexUtil.hasGenericSignature((DexAnnotatedElement)dexMethod)) {
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            parser.parseForMethod(method, DexUtil.getGenericSignature((DexAnnotatedElement)dexMethod));
            method.setTypeParameters(parser.formalTypeParameters);
            List dexParameters = dexMethod.getParameters();
            ArrayList<IParameter> parameters = new ArrayList<IParameter>(parser.parameterTypes.size());
            Iterator iterator = dexParameters.iterator();
            for (ITypeReference parameterType : parser.parameterTypes) {
                SigParameter parameter = new SigParameter(parameterType);
                iterator.hasNext();
                DexParameter dexParam = (DexParameter)iterator.next();
                parameter.setAnnotations(this.convertAnnotations(dexParam.getAnnotations()));
                parameters.add(parameter);
            }
            method.setParameters(parameters);
            method.setExceptions(new HashSet<ITypeReference>(parser.exceptionTypes));
            method.setReturnType(parser.returnType);
        } else {
            this.convertNonGenericExecutableMember(method, dexMethod);
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            ITypeReference type = parser.parseNonGenericReturnType(dexMethod.getReturnType());
            method.setReturnType(type);
        }
        this.addExceptions(method, dexMethod);
        return method;
    }

    private void addExceptions(SigExecutableMember member, DexMethod dexMethod) {
        if (DexUtil.declaresExceptions((DexAnnotatedElement)dexMethod)) {
            String exceptionSignature = DexUtil.getExceptionSignature((DexAnnotatedElement)dexMethod);
            Set<String> exceptionTypeNames = DexUtil.splitTypeList(exceptionSignature);
            HashSet<ITypeReference> exceptions = new HashSet<ITypeReference>();
            for (String exTypeName : exceptionTypeNames) {
                String packageName = DexUtil.getPackageName(exTypeName);
                String className = DexUtil.getClassName(exTypeName);
                exceptions.add(this.factory.getClassReference(packageName, className));
            }
            member.setExceptions(exceptions);
        } else {
            member.setExceptions(EMPTY_EXCEPTIONS);
        }
    }

    private void convertNonGenericExecutableMember(SigExecutableMember member, DexMethod dexMethod) {
        List dexParameters = dexMethod.getParameters();
        ArrayList<IParameter> parameters = new ArrayList<IParameter>(dexParameters.size());
        for (DexParameter dexParameter : dexParameters) {
            GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
            ITypeReference type = parser.parseNonGenericType(dexParameter.getTypeName());
            SigParameter parameter = new SigParameter(type);
            parameters.add(parameter);
            parameter.setAnnotations(this.convertAnnotations(dexParameter.getAnnotations()));
        }
        member.setParameters(parameters);
        member.setTypeParameters(EMPTY_TYPE_VARIABLES);
    }

    private Set<IAnnotation> convertAnnotations(Set<DexAnnotation> dexAnnotations) {
        HashSet<IAnnotation> annotations = new HashSet<IAnnotation>();
        for (DexAnnotation dexAnnotation : dexAnnotations) {
            if (DexUtil.isInternalAnnotation(dexAnnotation)) continue;
            annotations.add(this.convertAnnotation(dexAnnotation));
        }
        return annotations;
    }

    protected SigAnnotation convertAnnotation(DexAnnotation dexAnnotation) {
        SigAnnotation sigAnnotation = new SigAnnotation();
        String packageName = DexUtil.getPackageName(dexAnnotation.getTypeName());
        String className = DexUtil.getClassName(dexAnnotation.getTypeName());
        sigAnnotation.setType(this.factory.getClassReference(packageName, className));
        sigAnnotation.setElements(this.convertAnnotationElements(dexAnnotation.getAttributes()));
        return sigAnnotation;
    }

    private Set<IAnnotationElement> convertAnnotationElements(List<DexAnnotationAttribute> attributes) {
        HashSet<IAnnotationElement> annotationAttributes = new HashSet<IAnnotationElement>();
        for (DexAnnotationAttribute dexAnnotationAttribute : attributes) {
            annotationAttributes.add(this.convertAnnotationAttribute(dexAnnotationAttribute));
        }
        return annotationAttributes;
    }

    private IAnnotationElement convertAnnotationAttribute(DexAnnotationAttribute dexAnnotationAttribute) {
        SigAnnotationElement sigElement = new SigAnnotationElement();
        String nameOfField = dexAnnotationAttribute.getName();
        String typeName = dexAnnotationAttribute.getAnnotation().getTypeName();
        SigClassDefinition annotationClass = this.factory.getClass(DexUtil.getPackageName(typeName), DexUtil.getClassName(typeName));
        if (!Uninitialized.isInitialized(annotationClass.getAnnotationFields())) {
            this.initializeClass(DexUtil.getPackageName(typeName), DexUtil.getClassName(typeName));
        }
        for (IAnnotationField field : annotationClass.getAnnotationFields()) {
            if (!nameOfField.equals(field.getName())) continue;
            sigElement.setDeclaringField(field);
        }
        sigElement.setValue(this.convertEncodedValue(dexAnnotationAttribute.getEncodedValue()));
        return sigElement;
    }

    private Object convertEncodedValue(DexEncodedValue dexEnodedValue) {
        Object value = null;
        switch (dexEnodedValue.getType()) {
            case VALUE_INT: 
            case VALUE_BOOLEAN: 
            case VALUE_BYTE: 
            case VALUE_CHAR: 
            case VALUE_DOUBLE: 
            case VALUE_FLOAT: 
            case VALUE_LONG: 
            case VALUE_NULL: 
            case VALUE_STRING: 
            case VALUE_SHORT: {
                value = dexEnodedValue.getValue();
                break;
            }
            case VALUE_ARRAY: {
                List dexValues = (List)dexEnodedValue.getValue();
                Object[] arrayValues = new Object[dexValues.size()];
                int i = 0;
                for (DexEncodedValue dexValue : dexValues) {
                    arrayValues[i++] = this.convertEncodedValue(dexValue);
                }
                value = arrayValues;
                break;
            }
            case VALUE_ANNOTATION: {
                DexEncodedAnnotation annotation = (DexEncodedAnnotation)dexEnodedValue.getValue();
                SigAnnotation sigAnnotation = new SigAnnotation();
                String packageName = DexUtil.getPackageName(annotation.getTypeName());
                String className = DexUtil.getClassName(annotation.getTypeName());
                sigAnnotation.setType(this.factory.getClassReference(packageName, className));
                sigAnnotation.setElements(this.convertAnnotationElements(annotation.getValue()));
                value = sigAnnotation;
                break;
            }
            case VALUE_FIELD: {
                String fieldDesc = (String)dexEnodedValue.getValue();
                String[] typeAndFieldName = fieldDesc.split("!");
                String typeName = typeAndFieldName[0];
                String fieldName = typeAndFieldName[1];
                value = this.elementPool.getField(DexUtil.getQualifiedName(typeName), fieldName);
                break;
            }
            case VALUE_ENUM: {
                String fieldDesc = (String)dexEnodedValue.getValue();
                String[] typeAndFieldName = fieldDesc.split("!");
                String typeName = typeAndFieldName[0];
                String fieldName = typeAndFieldName[1];
                value = this.elementPool.getEnumConstant(DexUtil.getQualifiedName(typeName), fieldName);
                break;
            }
            case VALUE_TYPE: {
                String typeName = (String)dexEnodedValue.getValue();
                GenericSignatureParser parser = new GenericSignatureParser(this.factory, this);
                value = parser.parseNonGenericReturnType(typeName);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    @Override
    public IClassDefinition initializeClass(String packageName, String className) {
        String dexName = DexUtil.getDexName(packageName, className);
        DexClass dexClass = this.dexNameToDexClass.get(dexName);
        return this.convertClass(dexClass);
    }
}

