/*
 * Decompiled with CFR 0.152.
 */
package signature.compare.model.subst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import signature.compare.model.subst.ArrayTypeProjection;
import signature.compare.model.subst.ClassProjection;
import signature.compare.model.subst.ClassReferenceProjection;
import signature.compare.model.subst.ParameterizedTypeProjection;
import signature.compare.model.subst.WildcardTypeProjection;
import signature.model.IArrayType;
import signature.model.IClassDefinition;
import signature.model.IClassReference;
import signature.model.IParameterizedType;
import signature.model.IPrimitiveType;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.ITypeVariableReference;
import signature.model.IWildcardType;
import signature.model.impl.SigClassReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewpointAdapter {
    static Map<ITypeVariableDefinition, ITypeReference> createTypeMapping(IParameterizedType paramameterizedType, IClassDefinition parameterizedTypeDefinition) {
        List<ITypeVariableDefinition> typeParameters = parameterizedTypeDefinition.getTypeParameters();
        List<ITypeReference> actualTypeArguments = paramameterizedType.getTypeArguments();
        if (actualTypeArguments == null || typeParameters == null) {
            return Collections.emptyMap();
        }
        HashMap<ITypeVariableDefinition, ITypeReference> substitution = new HashMap<ITypeVariableDefinition, ITypeReference>();
        Iterator<ITypeVariableDefinition> paramsIterator = typeParameters.iterator();
        Iterator<ITypeReference> argumentsIterator = actualTypeArguments.iterator();
        while (paramsIterator.hasNext() && argumentsIterator.hasNext()) {
            substitution.put(paramsIterator.next(), argumentsIterator.next());
        }
        return substitution;
    }

    public static Set<ITypeReference> substitutedTypeReferences(Set<ITypeReference> original, Map<ITypeVariableDefinition, ITypeReference> mappings) {
        ArrayList<ITypeReference> result = new ArrayList<ITypeReference>(original);
        return new HashSet<ITypeReference>(ViewpointAdapter.substitutedTypeReferences(result, mappings));
    }

    public static List<ITypeReference> substitutedTypeReferences(List<ITypeReference> original, Map<ITypeVariableDefinition, ITypeReference> mappings) {
        ArrayList<ITypeReference> result = new ArrayList<ITypeReference>(original.size());
        for (ITypeReference typeReference : original) {
            result.add(ViewpointAdapter.substitutedTypeReference(typeReference, mappings));
        }
        return result;
    }

    public static ITypeReference substitutedTypeReference(ITypeReference original, Map<ITypeVariableDefinition, ITypeReference> mappings) {
        ITypeReference type = original;
        if (type instanceof IClassReference) {
            return new ClassReferenceProjection((IClassReference)original, mappings);
        }
        if (type instanceof IPrimitiveType) {
            return type;
        }
        if (type instanceof IArrayType) {
            return new ArrayTypeProjection((IArrayType)type, mappings);
        }
        if (type instanceof IParameterizedType) {
            return new ParameterizedTypeProjection((IParameterizedType)type, mappings);
        }
        if (type instanceof IWildcardType) {
            return new WildcardTypeProjection((IWildcardType)type, mappings);
        }
        if (type instanceof ITypeVariableReference) {
            ITypeReference subst = mappings.get(((ITypeVariableReference)type).getTypeVariableDefinition());
            return subst != null ? subst : type;
        }
        throw new IllegalStateException();
    }

    public static IClassReference getReferenceTo(IClassDefinition definition) {
        return new SigClassReference(new ClassProjection(definition, new HashMap<ITypeVariableDefinition, ITypeReference>()));
    }
}

