/*
 * Decompiled with CFR 0.152.
 */
package signature.compare.model.subst;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import signature.compare.model.subst.ParameterProjection;
import signature.compare.model.subst.ViewpointAdapter;
import signature.model.IAnnotation;
import signature.model.IClassDefinition;
import signature.model.IExecutableMember;
import signature.model.IParameter;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutableMemberProjection
implements IExecutableMember {
    private final IExecutableMember original;
    private final Map<ITypeVariableDefinition, ITypeReference> mappings;

    public ExecutableMemberProjection(IExecutableMember original, Map<ITypeVariableDefinition, ITypeReference> mappings) {
        this.original = original;
        this.mappings = mappings;
    }

    @Override
    public Set<IAnnotation> getAnnotations() {
        return this.original.getAnnotations();
    }

    @Override
    public IClassDefinition getDeclaringClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ITypeReference> getExceptions() {
        return ViewpointAdapter.substitutedTypeReferences(this.original.getExceptions(), this.mappings);
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.original.getModifiers();
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    @Override
    public List<IParameter> getParameters() {
        LinkedList<IParameter> result = new LinkedList<IParameter>();
        for (IParameter parameter : this.original.getParameters()) {
            result.add(new ParameterProjection(parameter, this.mappings));
        }
        return result;
    }

    @Override
    public List<ITypeVariableDefinition> getTypeParameters() {
        return this.original.getTypeParameters();
    }
}

