/*
 * Decompiled with CFR 0.152.
 */
package signature;

import signature.UsageException;

public class Main {
    private static final String USAGE_MESSAGE = "usage:\n  sig --create (doclet | dex) sourcefiles --out directory --name <name> --packages packageName{ packageName}\n  sig --compare --from=(doclet | dex | sig) <sourcefiles> --name <name> --to=(doclet | dex | sig) <sourcefiles> --name <name> --out directory --packages packageName{ packageName}\n  sig --help";

    private Main() {
    }

    public static void main(String[] args) {
        boolean gotCmd = false;
        boolean showUsage = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("--") || !arg.startsWith("--")) {
                    gotCmd = false;
                    showUsage = true;
                    break;
                }
                gotCmd = true;
                if (arg.equals("--create")) {
                    signature.converter.Main.main(Main.without(args, i));
                    break;
                }
                if (arg.equals("--compare")) {
                    signature.compare.Main.main(Main.without(args, i));
                    break;
                }
                if (arg.equals("--version")) {
                    Main.version();
                    break;
                }
                if (arg.equals("--help")) {
                    showUsage = true;
                    break;
                }
                gotCmd = false;
            }
        }
        catch (UsageException ex) {
            showUsage = true;
        }
        catch (RuntimeException ex) {
            System.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
            ex.printStackTrace();
            System.exit(2);
        }
        catch (Throwable ex) {
            System.err.println("\nUNEXPECTED TOP-LEVEL ERROR:");
            ex.printStackTrace();
            System.exit(3);
        }
        if (!gotCmd) {
            System.err.println("error: no command specified");
            showUsage = true;
        }
        if (showUsage) {
            Main.usage();
            System.exit(1);
        }
    }

    private static void version() {
        System.err.println("android sigtools version 0.1");
        System.exit(0);
    }

    private static void usage() {
        System.err.println(USAGE_MESSAGE);
    }

    private static String[] without(String[] orig, int n) {
        int len = orig.length - 1;
        String[] newa = new String[len];
        System.arraycopy(orig, 0, newa, 0, n);
        System.arraycopy(orig, n + 1, newa, n, len - n);
        return newa;
    }
}

