/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.ISdkLog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class MessageBoxLog
implements ISdkLog {
    final ArrayList<String> logMessages = new ArrayList();
    private final String mMessage;
    private final Display mDisplay;
    private final boolean mLogErrorsOnly;

    public MessageBoxLog(String message, Display display, boolean logErrorsOnly) {
        this.mMessage = message;
        this.mDisplay = display;
        this.mLogErrorsOnly = logErrorsOnly;
    }

    public void error(Throwable throwable, String errorFormat, Object ... arg) {
        if (errorFormat != null) {
            this.logMessages.add(String.format("Error: " + errorFormat, arg));
        }
        if (throwable != null) {
            this.logMessages.add(throwable.getMessage());
        }
    }

    public void warning(String warningFormat, Object ... arg) {
        if (!this.mLogErrorsOnly) {
            this.logMessages.add(String.format("Warning: " + warningFormat, arg));
        }
    }

    public void printf(String msgFormat, Object ... arg) {
        if (!this.mLogErrorsOnly) {
            this.logMessages.add(String.format(msgFormat, arg));
        }
    }

    public void displayResult(final boolean success) {
        if (this.logMessages.size() > 0) {
            final StringBuilder sb = new StringBuilder(this.mMessage + "\n\n");
            for (String msg : this.logMessages) {
                sb.append(msg);
            }
            this.mDisplay.asyncExec(new Runnable(){

                public void run() {
                    Shell shell = MessageBoxLog.this.mDisplay.getActiveShell();
                    if (success && !MessageBoxLog.this.mLogErrorsOnly) {
                        MessageDialog.openInformation((Shell)shell, (String)"Android Virtual Devices Manager", (String)sb.toString());
                    } else {
                        MessageDialog.openError((Shell)shell, (String)"Android Virtual Devices Manager", (String)sb.toString());
                    }
                }
            });
        }
    }
}

