/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.NullSdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.tasks.ProgressTask;
import com.android.sdkuilib.internal.widgets.AvdCreationDialog;
import com.android.sdkuilib.internal.widgets.AvdDetailsDialog;
import com.android.sdkuilib.internal.widgets.AvdStartDialog;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class AvdSelector {
    private static int NUM_COL = 2;
    private final DisplayMode mDisplayMode;
    private AvdManager mAvdManager;
    private final String mOsSdkPath;
    private Table mTable;
    private Button mDeleteButton;
    private Button mDetailsButton;
    private Button mNewButton;
    private Button mRefreshButton;
    private Button mManagerButton;
    private Button mRepairButton;
    private Button mStartButton;
    private SelectionListener mSelectionListener;
    private IAvdFilter mTargetFilter;
    private boolean mIsEnabled = true;
    private ImageFactory mImageFactory;
    private Image mOkImage;
    private Image mBrokenImage;
    private Image mInvalidImage;
    private SettingsController mController;
    private final ISdkLog mSdkLog;

    public AvdSelector(Composite parent, String osSdkPath, AvdManager manager, IAvdFilter filter, DisplayMode displayMode, ISdkLog sdkLog) {
        this.mOsSdkPath = osSdkPath;
        this.mAvdManager = manager;
        this.mTargetFilter = filter;
        this.mDisplayMode = displayMode;
        this.mSdkLog = sdkLog;
        this.mImageFactory = new ImageFactory(parent.getDisplay());
        this.mOkImage = this.mImageFactory.getImageByName("accept_icon16.png");
        this.mBrokenImage = this.mImageFactory.getImageByName("broken_16.png");
        this.mInvalidImage = this.mImageFactory.getImageByName("reject_icon16.png");
        Composite group = new Composite(parent, 0);
        GridLayout gl = new GridLayout(NUM_COL, false);
        group.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(parent.getFont());
        group.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                AvdSelector.this.mImageFactory.dispose();
            }
        });
        int style = 67588;
        if (displayMode == DisplayMode.SIMPLE_CHECK) {
            style |= 0x20;
        }
        this.mTable = new Table(group, style);
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(false);
        this.setTableHeightHint(0);
        Composite buttons = new Composite(group, 0);
        gl = new GridLayout(1, false);
        buttons.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttons.setLayoutData((Object)new GridData(1040));
        buttons.setFont(group.getFont());
        if (displayMode == DisplayMode.MANAGER) {
            this.mNewButton = new Button(buttons, 0x800008);
            this.mNewButton.setLayoutData((Object)new GridData(768));
            this.mNewButton.setText("New...");
            this.mNewButton.setToolTipText("Creates a new AVD.");
            this.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    AvdSelector.this.onNew();
                }
            });
            this.mDeleteButton = new Button(buttons, 0x800008);
            this.mDeleteButton.setLayoutData((Object)new GridData(768));
            this.mDeleteButton.setText("Delete...");
            this.mDeleteButton.setToolTipText("Deletes the selected AVD.");
            this.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    AvdSelector.this.onDelete();
                }
            });
            this.mRepairButton = new Button(buttons, 0x800008);
            this.mRepairButton.setLayoutData((Object)new GridData(768));
            this.mRepairButton.setText("Repair...");
            this.mRepairButton.setToolTipText("Repairs the selected AVD.");
            this.mRepairButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    AvdSelector.this.onRepair();
                }
            });
            Label l = new Label(buttons, 258);
            l.setLayoutData((Object)new GridData(768));
        }
        this.mDetailsButton = new Button(buttons, 0x800008);
        this.mDetailsButton.setLayoutData((Object)new GridData(768));
        this.mDetailsButton.setText("Details...");
        this.mDetailsButton.setToolTipText("Diplays details of the selected AVD.");
        this.mDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdSelector.this.onDetails();
            }
        });
        this.mStartButton = new Button(buttons, 0x800008);
        this.mStartButton.setLayoutData((Object)new GridData(768));
        this.mStartButton.setText("Start...");
        this.mStartButton.setToolTipText("Starts the selected AVD.");
        this.mStartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdSelector.this.onStart();
            }
        });
        Composite padding = new Composite(buttons, 0);
        padding.setLayoutData((Object)new GridData(1040));
        this.mRefreshButton = new Button(buttons, 0x800008);
        this.mRefreshButton.setLayoutData((Object)new GridData(768));
        this.mRefreshButton.setText("Refresh");
        this.mRefreshButton.setToolTipText("Reloads the list of AVD.\nUse this if you create AVDs from the command line.");
        this.mRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdSelector.this.refresh(true);
            }
        });
        if (displayMode != DisplayMode.MANAGER) {
            this.mManagerButton = new Button(buttons, 0x800008);
            this.mManagerButton.setLayoutData((Object)new GridData(768));
            this.mManagerButton.setText("Manager...");
            this.mManagerButton.setToolTipText("Launches the AVD manager.");
            this.mManagerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AvdSelector.this.onManager();
                }
            });
        } else {
            Composite legend = new Composite(group, 0);
            gl = new GridLayout(4, false);
            legend.setLayout((Layout)gl);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            legend.setLayoutData((Object)new GridData(4, 1, true, false, NUM_COL, 1));
            legend.setFont(group.getFont());
            new Label(legend, 0).setImage(this.mOkImage);
            new Label(legend, 0).setText("A valid Android Virtual Device.");
            new Label(legend, 0).setImage(this.mBrokenImage);
            new Label(legend, 0).setText("A repairable Android Virtual Device.");
            new Label(legend, 0).setImage(this.mInvalidImage);
            Label l = new Label(legend, 0);
            l.setText("An Android Virtual Device that failed to load. Click 'Details' to see the error.");
            GridData gd = new GridData(768);
            l.setLayoutData((Object)gd);
            gd.horizontalSpan = 3;
        }
        TableColumn column0 = new TableColumn(this.mTable, 0);
        column0.setText("AVD Name");
        TableColumn column1 = new TableColumn(this.mTable, 0);
        column1.setText("Target Name");
        TableColumn column2 = new TableColumn(this.mTable, 0);
        column2.setText("Platform");
        TableColumn column3 = new TableColumn(this.mTable, 0);
        column3.setText("API Level");
        this.adjustColumnsWidth(this.mTable, column0, column1, column2, column3);
        this.setupSelectionListener(this.mTable);
        this.fillTable(this.mTable);
        this.setEnabled(true);
    }

    public AvdSelector(Composite parent, String osSdkPath, AvdManager manager, DisplayMode displayMode, ISdkLog sdkLog) {
        this(parent, osSdkPath, manager, (IAvdFilter)null, displayMode, sdkLog);
    }

    public AvdSelector(Composite parent, String osSdkPath, AvdManager manager, IAndroidTarget filter, DisplayMode displayMode, ISdkLog sdkLog) {
        this(parent, osSdkPath, manager, new TargetBasedFilter(filter), displayMode, sdkLog);
    }

    public void setSettingsController(SettingsController controller) {
        this.mController = controller;
    }

    public void setTableHeightHint(int heightHint) {
        GridData data = new GridData();
        if (heightHint > 0) {
            data.heightHint = heightHint;
        }
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.mTable.setLayoutData((Object)data);
    }

    public boolean refresh(boolean reload) {
        if (reload) {
            try {
                this.mAvdManager.reloadAvds(NullSdkLog.getLogger());
            }
            catch (AndroidLocation.AndroidLocationException e) {
                return false;
            }
        }
        AvdManager.AvdInfo selected = this.getSelected();
        this.fillTable(this.mTable);
        this.setSelection(selected);
        return true;
    }

    public void setManager(AvdManager manager) {
        this.mAvdManager = manager;
    }

    public void setFilter(IAvdFilter filter) {
        this.mTargetFilter = filter;
    }

    public void setFilter(IAndroidTarget target) {
        this.mTargetFilter = target != null ? new TargetBasedFilter(target) : null;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.mSelectionListener = selectionListener;
    }

    public boolean setSelection(AvdManager.AvdInfo target) {
        boolean found = false;
        boolean modified = false;
        int selIndex = this.mTable.getSelectionIndex();
        int index = 0;
        for (TableItem i : this.mTable.getItems()) {
            if (this.mDisplayMode == DisplayMode.SIMPLE_CHECK) {
                if ((AvdManager.AvdInfo)i.getData() == target) {
                    found = true;
                    if (i.getChecked()) continue;
                    modified = true;
                    i.setChecked(true);
                    continue;
                }
                if (!i.getChecked()) continue;
                modified = true;
                i.setChecked(false);
                continue;
            }
            if ((AvdManager.AvdInfo)i.getData() == target) {
                found = true;
                if (index == selIndex) break;
                this.mTable.setSelection(index);
                modified = true;
                break;
            }
            ++index;
        }
        if (modified && this.mSelectionListener != null) {
            this.mSelectionListener.widgetSelected(null);
        }
        this.enableActionButtons();
        return found;
    }

    public AvdManager.AvdInfo getSelected() {
        if (this.mDisplayMode == DisplayMode.SIMPLE_CHECK) {
            for (TableItem i : this.mTable.getItems()) {
                if (!i.getChecked()) continue;
                return (AvdManager.AvdInfo)i.getData();
            }
        } else {
            int selIndex = this.mTable.getSelectionIndex();
            if (selIndex >= 0) {
                return (AvdManager.AvdInfo)this.mTable.getItem(selIndex).getData();
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled && this.mAvdManager != null;
        this.mTable.setEnabled(this.mIsEnabled);
        this.mRefreshButton.setEnabled(this.mIsEnabled);
        if (this.mNewButton != null) {
            this.mNewButton.setEnabled(this.mIsEnabled);
        }
        if (this.mManagerButton != null) {
            this.mManagerButton.setEnabled(this.mIsEnabled);
        }
        this.enableActionButtons();
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    private void adjustColumnsWidth(final Table table, final TableColumn column0, final TableColumn column1, final TableColumn column2, final TableColumn column3) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                column0.setWidth(r.width * 25 / 100);
                column1.setWidth(r.width * 45 / 100);
                column2.setWidth(r.width * 15 / 100);
                column3.setWidth(r.width * 15 / 100);
            }
        });
    }

    private void setupSelectionListener(Table table) {
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem i = (TableItem)e.item;
                    this.enforceSingleSelection(i);
                }
                if (AvdSelector.this.mSelectionListener != null) {
                    AvdSelector.this.mSelectionListener.widgetSelected(e);
                }
                AvdSelector.this.enableActionButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                boolean showDetails;
                if (e.item instanceof TableItem) {
                    TableItem i = (TableItem)e.item;
                    if (AvdSelector.this.mDisplayMode == DisplayMode.SIMPLE_CHECK) {
                        i.setChecked(true);
                    }
                    this.enforceSingleSelection(i);
                }
                boolean bl = showDetails = AvdSelector.this.mDisplayMode != DisplayMode.SIMPLE_CHECK;
                if (AvdSelector.this.mSelectionListener != null) {
                    AvdSelector.this.mSelectionListener.widgetDefaultSelected(e);
                    showDetails &= e.doit;
                }
                if (showDetails) {
                    AvdSelector.this.onDetails();
                }
                AvdSelector.this.enableActionButtons();
            }

            private void enforceSingleSelection(TableItem item) {
                if (AvdSelector.this.mDisplayMode == DisplayMode.SIMPLE_CHECK && item.getChecked()) {
                    Table parentTable = item.getParent();
                    for (TableItem i2 : parentTable.getItems()) {
                        if (i2 == item || !i2.getChecked()) continue;
                        i2.setChecked(false);
                    }
                }
            }
        });
    }

    private void fillTable(Table table) {
        table.removeAll();
        AvdManager.AvdInfo[] avds = null;
        if (this.mAvdManager != null) {
            avds = this.mDisplayMode == DisplayMode.MANAGER ? this.mAvdManager.getAllAvds() : this.mAvdManager.getValidAvds();
        }
        if (avds != null && avds.length > 0) {
            Arrays.sort(avds, new Comparator<AvdManager.AvdInfo>(){

                @Override
                public int compare(AvdManager.AvdInfo o1, AvdManager.AvdInfo o2) {
                    return o1.compareTo(o2);
                }
            });
            table.setEnabled(true);
            if (this.mTargetFilter != null) {
                this.mTargetFilter.prepare();
            }
            for (AvdManager.AvdInfo avd : avds) {
                IAndroidTarget target;
                if (this.mTargetFilter != null && !this.mTargetFilter.accept(avd)) continue;
                TableItem item = new TableItem(table, 0);
                item.setData((Object)avd);
                item.setText(0, avd.getName());
                if (this.mDisplayMode == DisplayMode.MANAGER) {
                    AvdManager.AvdInfo.AvdStatus status = avd.getStatus();
                    item.setImage(0, status == AvdManager.AvdInfo.AvdStatus.OK ? this.mOkImage : (this.isAvdRepairable(status) ? this.mBrokenImage : this.mInvalidImage));
                }
                if ((target = avd.getTarget()) != null) {
                    item.setText(1, target.getFullName());
                    item.setText(2, target.getVersionName());
                    item.setText(3, target.getVersion().getApiString());
                    continue;
                }
                item.setText(1, "?");
                item.setText(2, "?");
                item.setText(3, "?");
            }
            if (this.mTargetFilter != null) {
                this.mTargetFilter.cleanup();
            }
        }
        if (table.getItemCount() == 0) {
            table.setEnabled(false);
            TableItem item = new TableItem(table, 0);
            item.setData(null);
            item.setText(0, "--");
            item.setText(1, "No AVD available");
            item.setText(2, "--");
            item.setText(3, "--");
        }
    }

    private AvdManager.AvdInfo getTableSelection() {
        int selIndex = this.mTable.getSelectionIndex();
        if (selIndex >= 0) {
            return (AvdManager.AvdInfo)this.mTable.getItem(selIndex).getData();
        }
        return null;
    }

    private void enableActionButtons() {
        if (!this.mIsEnabled) {
            this.mDetailsButton.setEnabled(false);
            this.mStartButton.setEnabled(false);
            if (this.mDeleteButton != null) {
                this.mDeleteButton.setEnabled(false);
            }
            if (this.mRepairButton != null) {
                this.mRepairButton.setEnabled(false);
            }
        } else {
            AvdManager.AvdInfo selection = this.getTableSelection();
            boolean hasSelection = selection != null;
            this.mDetailsButton.setEnabled(hasSelection);
            this.mStartButton.setEnabled(this.mOsSdkPath != null && hasSelection && selection.getStatus() == AvdManager.AvdInfo.AvdStatus.OK);
            if (this.mDeleteButton != null) {
                this.mDeleteButton.setEnabled(hasSelection);
            }
            if (this.mRepairButton != null) {
                this.mRepairButton.setEnabled(hasSelection && this.isAvdRepairable(selection.getStatus()));
            }
        }
    }

    private void onNew() {
        AvdCreationDialog dlg = new AvdCreationDialog(this.mTable.getShell(), this.mAvdManager, this.mImageFactory, this.mSdkLog);
        if (dlg.open() == 0) {
            this.refresh(false);
        }
    }

    private void onDetails() {
        AvdManager.AvdInfo avdInfo = this.getTableSelection();
        AvdDetailsDialog dlg = new AvdDetailsDialog(this.mTable.getShell(), avdInfo);
        dlg.open();
    }

    private void onDelete() {
        final AvdManager.AvdInfo avdInfo = this.getTableSelection();
        final Display display = this.mTable.getDisplay();
        if (avdInfo.isRunning()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    Shell shell = display.getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)"Delete Android Virtual Device", (String)String.format("The Android Virtual Device '%1$s' is currently running in an emulator and cannot be deleted.", avdInfo.getName()));
                }
            });
            return;
        }
        final boolean[] result = new boolean[1];
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell = display.getActiveShell();
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)"Delete Android Virtual Device", (String)String.format("Please confirm that you want to delete the Android Virtual Device named '%s'. This operation cannot be reverted.", avdInfo.getName()));
            }
        });
        if (!result[0]) {
            return;
        }
        ISdkLog log = this.mSdkLog;
        if (log == null || log instanceof MessageBoxLog) {
            log = new MessageBoxLog(String.format("Result of deleting AVD '%s':", avdInfo.getName()), display, false);
        }
        boolean success = this.mAvdManager.deleteAvd(avdInfo, log);
        if (log instanceof MessageBoxLog) {
            ((MessageBoxLog)log).displayResult(success);
        }
        if (success) {
            this.refresh(false);
        }
    }

    private void onRepair() {
        block4: {
            AvdManager.AvdInfo avdInfo = this.getTableSelection();
            Display display = this.mTable.getDisplay();
            ISdkLog log = this.mSdkLog;
            if (log == null || log instanceof MessageBoxLog) {
                log = new MessageBoxLog(String.format("Result of updating AVD '%s':", avdInfo.getName()), display, false);
            }
            try {
                this.mAvdManager.updateAvd(avdInfo, log);
                if (log instanceof MessageBoxLog) {
                    ((MessageBoxLog)log).displayResult(true);
                }
                this.refresh(false);
            }
            catch (IOException e) {
                log.error((Throwable)e, null, new Object[0]);
                if (!(log instanceof MessageBoxLog)) break block4;
                ((MessageBoxLog)log).displayResult(false);
            }
        }
    }

    private void onManager() {
        Display display = this.mTable.getDisplay();
        ISdkLog log = this.mSdkLog;
        if (log == null || log instanceof MessageBoxLog) {
            log = new MessageBoxLog("Result of SDK Manager", display, true);
        }
        UpdaterWindow window = new UpdaterWindow(this.mTable.getShell(), log, this.mAvdManager.getSdkManager().getLocation(), false);
        window.open();
        this.refresh(true);
        if (log instanceof MessageBoxLog) {
            ((MessageBoxLog)log).displayResult(true);
        }
    }

    private void onStart() {
        AvdManager.AvdInfo avdInfo = this.getTableSelection();
        if (avdInfo == null || this.mOsSdkPath == null) {
            return;
        }
        AvdStartDialog dialog = new AvdStartDialog(this.mTable.getShell(), avdInfo, this.mOsSdkPath, this.mController);
        if (dialog.open() == 0) {
            float scale;
            String path = this.mOsSdkPath + File.separator + SdkConstants.OS_SDK_TOOLS_FOLDER + SdkConstants.FN_EMULATOR;
            final String avdName = avdInfo.getName();
            ArrayList<String> list = new ArrayList<String>();
            list.add(path);
            list.add("-avd");
            list.add(avdName);
            if (dialog.getWipeData()) {
                list.add("-wipe-data");
            }
            if ((scale = dialog.getScale()) != 0.0f) {
                scale = Math.round(scale * 100.0f);
                list.add("-scale");
                Formatter formatter = new Formatter(Locale.US);
                formatter.format("%.2f", Float.valueOf(scale /= 100.0f));
                list.add(formatter.toString());
            }
            final String[] command = list.toArray(new String[list.size()]);
            new ProgressTask(this.mTable.getShell(), "Starting Android Emulator", new ITask(){

                public void run(ITaskMonitor monitor) {
                    try {
                        monitor.setDescription("Starting emulator for AVD '%1$s'", new Object[]{avdName});
                        int n = 10;
                        monitor.setProgressMax(n);
                        Process process = Runtime.getRuntime().exec(command);
                        AvdSelector.this.grabEmulatorOutput(process, monitor);
                        for (int i = 0; i < n; ++i) {
                            try {
                                Thread.sleep(100L);
                                monitor.incProgress(1);
                                continue;
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException e) {
                        monitor.setResult("Failed to start emulator: %1$s", new Object[]{e.getMessage()});
                    }
                }
            });
        }
    }

    private void grabEmulatorOutput(final Process process, final ITaskMonitor monitor) {
        new Thread("emu-stderr"){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        monitor.setResult("%1$s", new Object[]{line});
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        new Thread("emu-stdout"){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        monitor.setResult("%1$s", new Object[]{line});
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private boolean isAvdRepairable(AvdManager.AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdManager.AvdInfo.AvdStatus.ERROR_IMAGE_DIR;
    }

    private static final class TargetBasedFilter
    implements IAvdFilter {
        private final IAndroidTarget mTarget;

        TargetBasedFilter(IAndroidTarget target) {
            this.mTarget = target;
        }

        public void prepare() {
        }

        public boolean accept(AvdManager.AvdInfo avd) {
            if (avd != null) {
                return this.mTarget.canRunOn(avd.getTarget());
            }
            return false;
        }

        public void cleanup() {
        }
    }

    public static interface IAvdFilter {
        public void prepare();

        public boolean accept(AvdManager.AvdInfo var1);

        public void cleanup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        MANAGER,
        SIMPLE_CHECK,
        SIMPLE_SELECTION;

    }
}

