/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdkuilib.internal.repository.AvdManagerPage;
import com.android.sdkuilib.internal.repository.ISettingsPage;
import com.android.sdkuilib.internal.repository.LocalPackagesPage;
import com.android.sdkuilib.internal.repository.RemotePackagesPage;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.tasks.ProgressTaskFactory;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdaterWindowImpl {
    private final Shell mParentShell;
    private final UpdaterData mUpdaterData;
    private ArrayList<Composite> mPages = new ArrayList();
    private boolean mInternalPageChange;
    private ArrayList<Object[]> mExtraPages;
    private ProgressTaskFactory mTaskFactory;
    private Class<? extends Composite> mInitialPage;
    private boolean mRequestAutoUpdate;
    protected Shell mAndroidSdkUpdater;
    private SashForm mSashForm;
    private List mPageList;
    private Composite mPagesRootComposite;
    private LocalPackagesPage mLocalPackagePage;
    private RemotePackagesPage mRemotePackagesPage;
    private AvdManagerPage mAvdManagerPage;
    private StackLayout mStackLayout;

    public UpdaterWindowImpl(Shell parentShell, ISdkLog sdkLog, String osSdkRoot, boolean userCanChangeSdkRoot) {
        this.mParentShell = parentShell;
        this.mUpdaterData = new UpdaterData(osSdkRoot, sdkLog);
        this.mUpdaterData.setUserCanChangeSdkRoot(userCanChangeSdkRoot);
    }

    public void open() {
        if (this.mParentShell == null) {
            Display.setAppName((String)"Android");
        }
        this.createContents();
        this.mAndroidSdkUpdater.open();
        this.mAndroidSdkUpdater.layout();
        if (this.postCreate()) {
            Display display = Display.getDefault();
            while (!this.mAndroidSdkUpdater.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        this.dispose();
    }

    protected void createContents() {
        this.mAndroidSdkUpdater = new Shell(this.mParentShell, 1264);
        this.mAndroidSdkUpdater.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UpdaterWindowImpl.this.onAndroidSdkUpdaterDispose();
            }
        });
        FillLayout fl = new FillLayout(256);
        this.mAndroidSdkUpdater.setLayout((Layout)fl);
        fl.marginWidth = 5;
        fl.marginHeight = 5;
        this.mAndroidSdkUpdater.setMinimumSize(new Point(200, 50));
        this.mAndroidSdkUpdater.setSize(745, 433);
        this.mAndroidSdkUpdater.setText("Android SDK and AVD Manager");
        this.mSashForm = new SashForm((Composite)this.mAndroidSdkUpdater, 0);
        this.mPageList = new List((Composite)this.mSashForm, 2048);
        this.mPageList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdaterWindowImpl.this.onPageListSelected();
            }
        });
        this.mPagesRootComposite = new Composite((Composite)this.mSashForm, 0);
        this.mStackLayout = new StackLayout();
        this.mPagesRootComposite.setLayout((Layout)this.mStackLayout);
        this.mAvdManagerPage = new AvdManagerPage(this.mPagesRootComposite, this.mUpdaterData);
        this.mLocalPackagePage = new LocalPackagesPage(this.mPagesRootComposite, this.mUpdaterData);
        this.mRemotePackagesPage = new RemotePackagesPage(this.mPagesRootComposite, this.mUpdaterData);
        this.mSashForm.setWeights(new int[]{150, 576});
    }

    public void registerExtraPage(String title, Class<? extends Composite> pageClass) {
        if (this.mExtraPages == null) {
            this.mExtraPages = new ArrayList();
        }
        this.mExtraPages.add(new Object[]{title, pageClass});
    }

    public void setInitialPage(Class<? extends Composite> pageClass) {
        this.mInitialPage = pageClass;
    }

    public void setRequestAutoUpdate(boolean requestAutoUpdate) {
        this.mRequestAutoUpdate = requestAutoUpdate;
    }

    public void addListeners(UpdaterWindow.ISdkListener listener) {
        this.mUpdaterData.addListeners(listener);
    }

    public void removeListener(UpdaterWindow.ISdkListener listener) {
        this.mUpdaterData.removeListener(listener);
    }

    private Shell getShell() {
        return this.mAndroidSdkUpdater;
    }

    private void onAndroidSdkUpdaterDispose() {
        ImageFactory imgFactory;
        if (this.mUpdaterData != null && (imgFactory = this.mUpdaterData.getImageFactory()) != null) {
            imgFactory.dispose();
        }
    }

    private void setWindowImage(Shell androidSdkUpdater) {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imgFactory = this.mUpdaterData.getImageFactory()) != null) {
            this.mAndroidSdkUpdater.setImage(imgFactory.getImageByName(imageName));
        }
    }

    private boolean postCreate() {
        this.mUpdaterData.setWindowShell(this.getShell());
        this.mTaskFactory = new ProgressTaskFactory(this.getShell());
        this.mUpdaterData.setTaskFactory(this.mTaskFactory);
        this.mUpdaterData.setImageFactory(new ImageFactory(this.getShell().getDisplay()));
        this.setWindowImage(this.mAndroidSdkUpdater);
        this.addPage(this.mAvdManagerPage, "Virtual Devices");
        this.addPage(this.mLocalPackagePage, "Installed Packages");
        this.addPage(this.mRemotePackagesPage, "Available Packages");
        this.addExtraPages();
        int pageIndex = 0;
        int i = 0;
        for (Composite p : this.mPages) {
            if (p.getClass().equals(this.mInitialPage)) {
                pageIndex = i;
                break;
            }
            ++i;
        }
        this.displayPage(pageIndex);
        this.mPageList.setSelection(pageIndex);
        this.setupSources();
        this.initializeSettings();
        if (this.mUpdaterData.checkIfInitFailed()) {
            return false;
        }
        this.mUpdaterData.notifyListeners(true);
        if (this.mRequestAutoUpdate) {
            this.mUpdaterData.updateOrInstallAll_WithGUI(null);
        }
        return true;
    }

    private void dispose() {
        this.mUpdaterData.getSources().saveUserSources(this.mUpdaterData.getSdkLog());
    }

    private void addPage(Composite page, String title) {
        page.setData((Object)title);
        this.mPages.add(page);
        this.mPageList.add(title);
    }

    private void addExtraPages() {
        if (this.mExtraPages == null) {
            return;
        }
        for (Object[] extraPage : this.mExtraPages) {
            String title = (String)extraPage[0];
            Class clazz = (Class)extraPage[1];
            try {
                Constructor cons = clazz.getConstructor(Composite.class);
                Composite instance = (Composite)cons.newInstance(this.mPagesRootComposite);
                this.addPage(instance, title);
            }
            catch (NoSuchMethodException e) {
                this.mUpdaterData.getSdkLog().error((Throwable)e, "Failed to add extra page %1$s. Constructor args must be (Composite parent).", new Object[]{clazz.getSimpleName()});
            }
            catch (Exception e) {
                this.mUpdaterData.getSdkLog().error((Throwable)e, "Failed to add extra page %1$s.", new Object[]{clazz.getSimpleName()});
            }
        }
    }

    private void onPageListSelected() {
        int index;
        if (!this.mInternalPageChange && (index = this.mPageList.getSelectionIndex()) >= 0) {
            this.displayPage(index);
        }
    }

    private void displayPage(int index) {
        Composite page = this.mPages.get(index);
        if (page != null) {
            this.mStackLayout.topControl = page;
            this.mPagesRootComposite.layout(true);
            if (!this.mInternalPageChange) {
                this.mInternalPageChange = true;
                this.mPageList.setSelection(index);
                this.mInternalPageChange = false;
            }
        }
    }

    private void setupSources() {
        this.mUpdaterData.setupDefaultSources();
        this.mRemotePackagesPage.onSdkChange(false);
    }

    private void initializeSettings() {
        SettingsController c = this.mUpdaterData.getSettingsController();
        c.loadSettings();
        c.applySettings();
        for (Composite page : this.mPages) {
            if (!(page instanceof ISettingsPage)) continue;
            ISettingsPage settingsPage = (ISettingsPage)page;
            c.setSettingsPage(settingsPage);
            break;
        }
    }
}

