/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.IMinToolsDependency;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.IPlatformDependency;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.RepoSources;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdaterLogic {
    UpdaterLogic() {
    }

    public ArrayList<ArchiveInfo> computeUpdates(Collection<Archive> selectedArchives, RepoSources sources, Package[] localPkgs) {
        ArrayList<ArchiveInfo> archives = new ArrayList<ArchiveInfo>();
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        RepoSource[] remoteSources = sources.getSources();
        ArchiveInfo[] localArchives = this.createLocalArchives(localPkgs);
        if (selectedArchives == null) {
            selectedArchives = this.findUpdates(localArchives, remotePkgs, remoteSources);
        }
        for (Archive a : selectedArchives) {
            this.insertArchive(a, archives, selectedArchives, remotePkgs, remoteSources, localArchives, false);
        }
        return archives;
    }

    public void addNewPlatforms(ArrayList<ArchiveInfo> archives, RepoSources sources, Package[] localPkgs) {
        ArchiveInfo[] localArchives = this.createLocalArchives(localPkgs);
        float currentPlatformScore = 0.0f;
        float currentSampleScore = 0.0f;
        float currentAddonScore = 0.0f;
        float currentDocScore = 0.0f;
        HashMap<String, Float> currentExtraScore = new HashMap<String, Float>();
        for (Package p : localPkgs) {
            int rev = p.getRevision();
            int api = 0;
            boolean isPreview = false;
            if (p instanceof IPackageVersion) {
                AndroidVersion vers = ((IPackageVersion)p).getVersion();
                api = vers.getApiLevel();
                isPreview = vers.isPreview();
            }
            float score = (float)(api * 10 + (isPreview ? 1 : 0)) + (float)rev / 100.0f;
            if (p instanceof PlatformPackage) {
                currentPlatformScore = Math.max(currentPlatformScore, score);
                continue;
            }
            if (p instanceof SamplePackage) {
                currentSampleScore = Math.max(currentSampleScore, score);
                continue;
            }
            if (p instanceof AddonPackage) {
                currentAddonScore = Math.max(currentAddonScore, score);
                continue;
            }
            if (p instanceof ExtraPackage) {
                currentExtraScore.put(((ExtraPackage)p).getPath(), Float.valueOf(score));
                continue;
            }
            if (!(p instanceof DocPackage)) continue;
            currentDocScore = Math.max(currentDocScore, score);
        }
        RepoSource[] remoteSources = sources.getSources();
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        Package suggestedDoc = null;
        for (Package p : remotePkgs) {
            int rev = p.getRevision();
            int api = 0;
            boolean isPreview = false;
            if (p instanceof IPackageVersion) {
                AndroidVersion vers = ((IPackageVersion)p).getVersion();
                api = vers.getApiLevel();
                isPreview = vers.isPreview();
            }
            float score = (float)(api * 10 + (isPreview ? 1 : 0)) + (float)rev / 100.0f;
            boolean shouldAdd = false;
            if (p instanceof PlatformPackage) {
                shouldAdd = score > currentPlatformScore;
            } else if (p instanceof SamplePackage) {
                shouldAdd = score > currentSampleScore;
            } else if (p instanceof AddonPackage) {
                shouldAdd = score > currentAddonScore;
            } else if (p instanceof ExtraPackage) {
                String key = ((ExtraPackage)p).getPath();
                shouldAdd = !currentExtraScore.containsKey(key) || score > ((Float)currentExtraScore.get(key)).floatValue();
            } else if (p instanceof DocPackage && score > currentDocScore) {
                suggestedDoc = p;
                currentDocScore = score;
            }
            if (!shouldAdd) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                this.insertArchive(a, archives, null, remotePkgs, remoteSources, localArchives, true);
            }
        }
        if (suggestedDoc != null) {
            for (Archive a : suggestedDoc.getArchives()) {
                if (!a.isCompatible()) continue;
                this.insertArchive(a, archives, null, remotePkgs, remoteSources, localArchives, true);
            }
        }
    }

    protected ArchiveInfo[] createLocalArchives(Package[] localPkgs) {
        if (localPkgs != null) {
            ArrayList<LocalArchiveInfo> list = new ArrayList<LocalArchiveInfo>();
            for (Package p : localPkgs) {
                for (Archive a : p.getArchives()) {
                    if (a == null || !a.isCompatible()) continue;
                    list.add(new LocalArchiveInfo(a));
                }
            }
            return list.toArray(new ArchiveInfo[list.size()]);
        }
        return new ArchiveInfo[0];
    }

    private Collection<Archive> findUpdates(ArchiveInfo[] localArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources) {
        ArrayList<Archive> updates = new ArrayList<Archive>();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (ArchiveInfo ai : localArchives) {
            Archive na = ai.getNewArchive();
            if (na == null) continue;
            Package localPkg = na.getParentPackage();
            block1: for (Package remotePkg : remotePkgs) {
                if (localPkg.canBeUpdatedBy(remotePkg) != Package.UpdateInfo.UPDATE) continue;
                for (Archive a : remotePkg.getArchives()) {
                    if (!a.isCompatible()) continue;
                    updates.add(a);
                    continue block1;
                }
            }
        }
        return updates;
    }

    private ArchiveInfo insertArchive(Archive archive, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, ArchiveInfo[] localArchives, boolean automated) {
        Package p = archive.getParentPackage();
        Archive updatedArchive = null;
        for (ArchiveInfo ai : localArchives) {
            Package lp;
            Archive a = ai.getNewArchive();
            if (a == null || (lp = a.getParentPackage()).canBeUpdatedBy(p) != Package.UpdateInfo.UPDATE) continue;
            updatedArchive = a;
        }
        ArchiveInfo[] deps = this.findDependency(p, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives);
        ArchiveInfo ai = null;
        for (ArchiveInfo ai2 : outArchives) {
            Archive a2 = ai2.getNewArchive();
            if (a2 == null || !a2.getParentPackage().sameItemAs(archive.getParentPackage())) continue;
            ai = ai2;
            break;
        }
        if (ai == null) {
            ai = new ArchiveInfo(archive, updatedArchive, deps);
            outArchives.add(ai);
        }
        if (deps != null) {
            for (ArchiveInfo d : deps) {
                d.addDependencyFor(ai);
            }
        }
        return ai;
    }

    private ArchiveInfo[] findDependency(Package pkg, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, ArchiveInfo[] localArchives) {
        ArchiveInfo ai;
        ArrayList<ArchiveInfo> list = new ArrayList<ArchiveInfo>();
        if (pkg instanceof IPlatformDependency && (ai = this.findPlatformDependency((IPlatformDependency)pkg, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            list.add(ai);
        }
        if (pkg instanceof IMinToolsDependency && (ai = this.findToolsDependency((IMinToolsDependency)pkg, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            list.add(ai);
        }
        if (pkg instanceof IMinApiLevelDependency && (ai = this.findMinApiLevelDependency((IMinApiLevelDependency)pkg, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives)) != null) {
            list.add(ai);
        }
        if (list.size() > 0) {
            return list.toArray(new ArchiveInfo[list.size()]);
        }
        return null;
    }

    protected ArchiveInfo findToolsDependency(IMinToolsDependency pkg, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, ArchiveInfo[] localArchives) {
        int rev = pkg.getMinToolsRevision();
        if (rev == 0) {
            return null;
        }
        for (ArchiveInfo ai : localArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p : remotePkgs) {
            if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        return new MissingToolArchiveInfo(rev);
    }

    protected ArchiveInfo findPlatformDependency(IPlatformDependency pkg, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, ArchiveInfo[] localArchives) {
        AndroidVersion v = pkg.getVersion();
        for (ArchiveInfo ai : localArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || !((p = a.getParentPackage()) instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!(p instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p : remotePkgs) {
            if (!(p instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
            }
        }
        return new MissingPlatformArchiveInfo(pkg.getVersion());
    }

    protected ArchiveInfo findMinApiLevelDependency(IMinApiLevelDependency pkg, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, ArchiveInfo[] localArchives) {
        Package p;
        Archive a2;
        int api = pkg.getMinApiLevel();
        if (api == 0) {
            return null;
        }
        for (ArchiveInfo ai : localArchives) {
            a2 = ai.getNewArchive();
            if (a2 == null || !((p = a2.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)p).getVersion().isGreaterOrEqualThan(api)) continue;
            return null;
        }
        int foundApi = 0;
        ArchiveInfo foundAi = null;
        for (ArchiveInfo ai : outArchives) {
            a2 = ai.getNewArchive();
            if (a2 == null || !((p = a2.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)p).getVersion().isGreaterOrEqualThan(api) || api <= foundApi) continue;
            foundApi = api;
            foundAi = ai;
        }
        if (foundAi != null) {
            return foundAi;
        }
        foundApi = 0;
        Archive foundArchive = null;
        if (selectedArchives != null) {
            for (Archive a2 : selectedArchives) {
                p = a2.getParentPackage();
                if (!(p instanceof PlatformPackage) || !((PlatformPackage)p).getVersion().isGreaterOrEqualThan(api) || api <= foundApi) continue;
                foundApi = api;
                foundArchive = a2;
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p2 : remotePkgs) {
            if (!(p2 instanceof PlatformPackage) || !((PlatformPackage)p2).getVersion().isGreaterOrEqualThan(api) || api <= foundApi) continue;
            for (Archive a3 : p2.getArchives()) {
                if (!a3.isCompatible()) continue;
                foundApi = api;
                foundArchive = a3;
            }
        }
        if (foundArchive != null) {
            return this.insertArchive(foundArchive, outArchives, selectedArchives, remotePkgs, remoteSources, localArchives, true);
        }
        return new MissingPlatformArchiveInfo(new AndroidVersion(api, null));
    }

    protected void fetchRemotePackages(ArrayList<Package> remotePkgs, RepoSource[] remoteSources) {
        if (remotePkgs.size() > 0) {
            return;
        }
        for (RepoSource remoteSrc : remoteSources) {
            Package[] pkgs = remoteSrc.getPackages();
            if (pkgs == null) continue;
            block1: for (Package pkg : pkgs) {
                for (Archive a : pkg.getArchives()) {
                    if (!a.isCompatible()) continue;
                    remotePkgs.add(pkg);
                    continue block1;
                }
            }
        }
    }

    private static class MissingToolArchiveInfo
    extends ArchiveInfo {
        private final int mRevision;

        public MissingToolArchiveInfo(int revision) {
            super(null, null, null);
            this.mRevision = revision;
        }

        public boolean isAccepted() {
            return false;
        }

        public boolean isRejected() {
            return true;
        }

        public String getShortDescription() {
            return String.format("Missing Android SDK Tools, revision %1$d", this.mRevision);
        }
    }

    private static class MissingPlatformArchiveInfo
    extends ArchiveInfo {
        private final AndroidVersion mVersion;

        public MissingPlatformArchiveInfo(AndroidVersion version) {
            super(null, null, null);
            this.mVersion = version;
        }

        public boolean isAccepted() {
            return false;
        }

        public boolean isRejected() {
            return true;
        }

        public String getShortDescription() {
            return String.format("Missing SDK Platform Android%1$s, API %2$d", this.mVersion.isPreview() ? " Preview" : "", this.mVersion.getApiLevel());
        }
    }

    private static class LocalArchiveInfo
    extends ArchiveInfo {
        public LocalArchiveInfo(Archive localArchive) {
            super(localArchive, null, null);
        }

        public boolean isAccepted() {
            return true;
        }

        public boolean isRejected() {
            return false;
        }
    }
}

