/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdkuilib.internal.repository.UpdaterData;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateNoWindow {
    private final UpdaterData mUpdaterData;
    private final ISdkLog mSdkLog;
    private final boolean mForce;

    public UpdateNoWindow(String osSdkRoot, SdkManager sdkManager, ISdkLog sdkLog, boolean force, boolean useHttp) {
        this.mSdkLog = sdkLog;
        this.mForce = force;
        this.mUpdaterData = new UpdaterData(osSdkRoot, sdkLog);
        this.mUpdaterData.getSettingsController().setSetting("sdkman.force.http", useHttp);
        this.mUpdaterData.setTaskFactory(new ConsoleTaskFactory());
        if (this.mUpdaterData.checkIfInitFailed()) {
            return;
        }
        this.mUpdaterData.setupDefaultSources();
        this.mUpdaterData.getLocalSdkParser().parseSdk(osSdkRoot, sdkManager, sdkLog);
    }

    public void updateAll(ArrayList<String> pkgFilter, boolean includeObsoletes, boolean dryMode) {
        this.mUpdaterData.updateOrInstallAll_NoGUI(pkgFilter, includeObsoletes, dryMode);
    }

    private static class ConsoleSubTaskMonitor
    implements IConsoleSubTaskMonitor {
        private final ConsoleTask mRoot;
        private final IConsoleSubTaskMonitor mParent;
        private final double mStart;
        private final double mSpan;
        private double mSubValue;
        private double mSubCoef;

        public ConsoleSubTaskMonitor(ConsoleTask root, IConsoleSubTaskMonitor parent, double start, double span) {
            this.mRoot = root;
            this.mParent = parent;
            this.mStart = start;
            this.mSpan = span;
            this.mSubValue = start;
        }

        public boolean isCancelRequested() {
            return this.mRoot.isCancelRequested();
        }

        public void setDescription(String descriptionFormat, Object ... args) {
            this.mRoot.setDescription(descriptionFormat, args);
        }

        public void setResult(String resultFormat, Object ... args) {
            this.mRoot.setResult(resultFormat, args);
        }

        public void setProgressMax(int max) {
            assert (max > 0);
            double d = this.mSubCoef = max > 0 ? this.mSpan / (double)max : 0.0;
            assert (this.mSubCoef > 0.0);
        }

        public int getProgress() {
            assert (this.mSubCoef > 0.0);
            return this.mSubCoef > 0.0 ? (int)((this.mSubValue - this.mStart) / this.mSubCoef) : 0;
        }

        public void incProgress(int delta) {
            assert (this.mSubCoef > 0.0);
            this.subIncProgress((double)delta * this.mSubCoef);
        }

        public void subIncProgress(double realDelta) {
            this.mSubValue += realDelta;
            if (this.mParent != null) {
                this.mParent.subIncProgress(realDelta);
            } else {
                this.mRoot.internalIncProgress(realDelta);
            }
        }

        public boolean displayPrompt(String title, String message) {
            return this.mRoot.displayPrompt(title, message);
        }

        public ITaskMonitor createSubMonitor(int tickCount) {
            assert (this.mSubCoef > 0.0);
            assert (tickCount > 0);
            return new ConsoleSubTaskMonitor(this.mRoot, this, this.mSubValue, (double)tickCount * this.mSubCoef);
        }
    }

    private static interface IConsoleSubTaskMonitor
    extends ITaskMonitor {
        public void subIncProgress(double var1);
    }

    private class ConsoleTask
    implements ITaskMonitor {
        private static final double MAX_COUNT = 10000.0;
        private double mIncCoef = 0.0;
        private double mValue = 0.0;
        private String mLastDesc = null;
        private String mLastProgressBase = null;

        public ConsoleTask(String title, ITask task) {
            UpdateNoWindow.this.mSdkLog.printf("%s:\n", new Object[]{title});
            task.run((ITaskMonitor)this);
        }

        public void setDescription(String descriptionFormat, Object ... args) {
            String last = this.mLastDesc;
            String line = String.format("  " + descriptionFormat, args);
            if (line.indexOf(37) > -1) {
                if (this.mLastProgressBase != null && line.startsWith(this.mLastProgressBase)) {
                    line = "    " + line.substring(this.mLastProgressBase.length());
                }
                line = line + "\r";
            } else {
                this.mLastProgressBase = line;
                line = line + "\n";
            }
            if (last != null && last.equals(line)) {
                return;
            }
            this.mLastDesc = line;
            if (last != null && last.endsWith("\r") && !line.endsWith("\r")) {
                line = "\n" + line;
            }
            UpdateNoWindow.this.mSdkLog.printf("%s", new Object[]{line});
        }

        public void setResult(String resultFormat, Object ... args) {
            this.setDescription(resultFormat, args);
        }

        public void setProgressMax(int max) {
            assert (max > 0);
            double d = this.mIncCoef = max > 0 ? 10000.0 / (double)max : 0.0;
            assert (this.mIncCoef > 0.0);
        }

        public void incProgress(int delta) {
            assert (this.mIncCoef > 0.0);
            assert (delta > 0);
            this.internalIncProgress((double)delta * this.mIncCoef);
        }

        private void internalIncProgress(double realDelta) {
            this.mValue += realDelta;
        }

        public int getProgress() {
            assert (this.mIncCoef > 0.0);
            return this.mIncCoef > 0.0 ? (int)(this.mValue / this.mIncCoef) : 0;
        }

        public boolean isCancelRequested() {
            return false;
        }

        public boolean displayPrompt(String title, String message) {
            UpdateNoWindow.this.mSdkLog.printf("\n%s\n%s\n[y/n] => %s\n", new Object[]{title, message, UpdateNoWindow.this.mForce ? "yes" : "no (use --force to override)"});
            return UpdateNoWindow.this.mForce;
        }

        public ITaskMonitor createSubMonitor(int tickCount) {
            assert (this.mIncCoef > 0.0);
            assert (tickCount > 0);
            return new ConsoleSubTaskMonitor(this, null, this.mValue, (double)tickCount * this.mIncCoef);
        }
    }

    private class ConsoleTaskFactory
    implements ITaskFactory {
        private ConsoleTaskFactory() {
        }

        public void start(String title, ITask task) {
            new ConsoleTask(title, task);
        }
    }
}

