/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.internal.repository.RepoSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class RepoSources {
    private static final String KEY_COUNT = "count";
    private static final String KEY_SRC = "src";
    private static final String SRC_FILENAME = "repositories.cfg";
    private ArrayList<RepoSource> mSources = new ArrayList();

    public void add(RepoSource source) {
        this.mSources.add(source);
    }

    public void remove(RepoSource source) {
        this.mSources.remove(source);
    }

    public RepoSource[] getSources() {
        return this.mSources.toArray(new RepoSource[this.mSources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserSources(ISdkLog log) {
        Iterator<RepoSource> it = this.mSources.iterator();
        while (it.hasNext()) {
            RepoSource s = it.next();
            if (!s.isUserSource()) continue;
            it.remove();
        }
        FileInputStream fis = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SRC_FILENAME);
            if (f.exists()) {
                fis = new FileInputStream(f);
                Properties props = new Properties();
                props.load(fis);
                int count = Integer.parseInt(props.getProperty(KEY_COUNT, "0"));
                for (int i = 0; i < count; ++i) {
                    RepoSource s;
                    String url = props.getProperty(String.format("%s%02d", KEY_SRC, i));
                    if (url == null || this.hasSource(s = new RepoSource(url, true))) continue;
                    this.mSources.add(s);
                }
            }
        }
        catch (NumberFormatException e) {
            log.error(e, null, new Object[0]);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error(e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, null, new Object[0]);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean hasSource(RepoSource source) {
        for (RepoSource s : this.mSources) {
            if (!s.equals(source)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserSources(ISdkLog log) {
        FileOutputStream fos = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SRC_FILENAME);
            fos = new FileOutputStream(f);
            Properties props = new Properties();
            int count = 0;
            for (RepoSource s : this.mSources) {
                if (!s.isUserSource()) continue;
                props.setProperty(String.format("%s%02d", KEY_SRC, ++count), s.getUrl());
            }
            props.setProperty(KEY_COUNT, Integer.toString(count));
            props.store(fos, "## User Sources for Android tool");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error(e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, null, new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

