/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.internal.repository.XmlParserUtils;
import com.android.sdklib.repository.SdkRepository;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepoSource
implements IDescription {
    private String mUrl;
    private final boolean mUserSource;
    private Package[] mPackages;
    private String mDescription;
    private String mFetchError;

    public RepoSource(String url, boolean userSource) {
        if (url.endsWith("/")) {
            url = url + "repository.xml";
        }
        this.mUrl = url;
        this.mUserSource = userSource;
        this.setDefaultDescription();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepoSource) {
            RepoSource rs = (RepoSource)obj;
            return rs.isUserSource() == this.isUserSource() && rs.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.mUrl.hashCode() ^ Boolean.valueOf(this.mUserSource).hashCode();
    }

    public boolean isUserSource() {
        return this.mUserSource;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    public String getShortDescription() {
        return this.mUrl;
    }

    public String getLongDescription() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public String getFetchError() {
        return this.mFetchError;
    }

    public void load(ITaskMonitor monitor, boolean forceHttp) {
        String uri;
        monitor.setProgressMax(4);
        this.setDefaultDescription();
        String url = this.mUrl;
        if (forceHttp) {
            url = url.replaceAll("https://", "http://");
        }
        monitor.setDescription("Fetching %1$s", url);
        monitor.incProgress(1);
        this.mFetchError = null;
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Exception[] exception = new Exception[]{null};
        ByteArrayInputStream xml = this.fetchUrl(url, exception);
        Document validatedDoc = null;
        boolean usingAlternateXml = false;
        String validatedUri = null;
        if (xml != null) {
            monitor.setDescription("Validate XML", new Object[0]);
            uri = this.validateXml(xml, url, validationError, validatorFound);
            if (uri != null) {
                validatedDoc = this.getDocument(xml, monitor);
                validatedUri = uri;
            } else if (validatorFound[0].equals(Boolean.TRUE)) {
                validatedDoc = this.findAlternateToolsXml(xml);
                if (validatedDoc != null) {
                    validationError[0] = null;
                    validatedUri = SdkRepository.NS_SDK_REPOSITORY;
                    usingAlternateXml = true;
                }
            } else {
                this.mFetchError = "No suitable XML Schema Validator could be found in your Java environment. Please update your version of Java.";
            }
        }
        if (validatedDoc == null && !url.endsWith("repository.xml")) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if ((xml = this.fetchUrl(url = url + "repository.xml", exception)) != null) {
                uri = this.validateXml(xml, url, validationError, validatorFound);
                if (uri != null) {
                    validationError[0] = null;
                    validatedDoc = this.getDocument(xml, monitor);
                    validatedUri = uri;
                } else if (validatorFound[0].equals(Boolean.TRUE)) {
                    validatedDoc = this.findAlternateToolsXml(xml);
                    if (validatedDoc != null) {
                        validationError[0] = null;
                        validatedUri = SdkRepository.NS_SDK_REPOSITORY;
                        usingAlternateXml = true;
                    }
                } else {
                    this.mFetchError = "No suitable XML Schema Validator could be found in your Java environment. Please update your version of Java.";
                }
            }
            if (validatedDoc != null) {
                monitor.setResult("Repository found at %1$s", url);
                this.mUrl = url;
            }
        }
        if (exception[0] != null) {
            this.mFetchError = "Failed to fetch URL";
            String reason = null;
            if (exception[0] instanceof FileNotFoundException) {
                reason = "File not found";
                this.mFetchError = this.mFetchError + ": " + reason;
            } else if (exception[0] instanceof SSLKeyException) {
                reason = "HTTPS SSL error. You might want to force download through HTTP in the settings.";
                this.mFetchError = this.mFetchError + ": HTTPS SSL error";
            } else {
                reason = exception[0].getMessage() != null ? exception[0].getMessage() : String.format("Unknown (%1$s)", exception[0].getClass().getName());
            }
            monitor.setResult("Failed to fetch URL %1$s, reason: %2$s", url, reason);
        }
        if (validationError[0] != null) {
            monitor.setResult("%s", validationError[0]);
        }
        if (validatedDoc == null) {
            return;
        }
        if (usingAlternateXml) {
            String info;
            boolean isADT = false;
            try {
                Class<?> adt = Class.forName("com.android.ide.eclipse.adt.AdtPlugin");
                isADT = adt != null;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (isADT) {
                info = "This repository requires a more recent version of ADT. Please update the Eclipse Android plugin.";
                this.mDescription = "This repository requires a more recent version of ADT, the Eclipse Android plugin.\nYou must update it before you can see other new packages.";
            } else {
                info = "This repository requires a more recent version of the Tools. Please update.";
                this.mDescription = "This repository requires a more recent version of the Tools.\nYou must update it before you can see other new packages.";
            }
            this.mFetchError = this.mFetchError == null ? info : this.mFetchError + ". " + info;
        }
        monitor.incProgress(1);
        if (xml != null) {
            monitor.setDescription("Parse XML", new Object[0]);
            monitor.incProgress(1);
            this.parsePackages(validatedDoc, validatedUri, monitor);
            this.mDescription = this.mPackages == null || this.mPackages.length == 0 ? this.mDescription + "\nNo packages found." : (this.mPackages.length == 1 ? this.mDescription + "\nOne package found." : this.mDescription + String.format("\n%1$d packages found.", this.mPackages.length));
        }
        monitor.incProgress(1);
    }

    private void setDefaultDescription() {
        this.mDescription = this.mUserSource ? String.format("Add-on Source: %1$s", this.mUrl) : String.format("SDK Source: %1$s", this.mUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream fetchUrl(String urlString, Exception[] outException) {
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            URL url = new URL(urlString);
            InputStream is = null;
            int inc = 65536;
            int curr = 0;
            byte[] result = new byte[inc];
            try {
                int n;
                is = url.openStream();
                while ((n = is.read(result, curr, result.length - curr)) != -1) {
                    if ((curr += n) != result.length) continue;
                    byte[] temp = new byte[curr + inc];
                    System.arraycopy(result, 0, temp, 0, curr);
                    result = temp;
                }
                byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    outException[0] = e;
                    return null;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byteArrayInputStream;
    }

    private String validateXml(ByteArrayInputStream xml, String url, String[] outError, Boolean[] validatorFound) {
        String lastError = null;
        String extraError = null;
        for (int version = 2; version >= 1; --version) {
            try {
                Validator validator = this.getValidator(version);
                if (validator != null) {
                    validatorFound[0] = Boolean.TRUE;
                    xml.reset();
                    validator.validate(new StreamSource(xml));
                    return SdkRepository.getSchemaUri(version);
                }
                lastError = "XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.";
                validatorFound[0] = Boolean.FALSE;
                continue;
            }
            catch (Exception e) {
                lastError = "XML verification failed for %1$s.\nError: %2$s";
                extraError = e.getMessage();
                if (extraError != null) continue;
                extraError = e.getClass().getName();
            }
        }
        if (lastError != null) {
            outError[0] = String.format(lastError, url, extraError);
        }
        return null;
    }

    protected Document findAlternateToolsXml(InputStream xml) {
        if (xml == null) {
            return null;
        }
        try {
            xml.reset();
        }
        catch (IOException e1) {
            // empty catch block
        }
        Node oldDoc = null;
        Document newDoc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            oldDoc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            newDoc = builder.newDocument();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (oldDoc == null || newDoc == null) {
            return null;
        }
        Pattern nsPattern = Pattern.compile("http://schemas.android.com/sdk/android/repository/[1-9][0-9]*");
        Node oldRoot = null;
        String prefix = null;
        for (Node child = oldDoc.getFirstChild(); child != null; child = child.getNextSibling()) {
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!"sdk-repository".equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !nsPattern.matcher(uri).matches()) continue;
            oldRoot = child;
            break;
        }
        if (oldRoot == null || prefix == null || prefix.length() == 0) {
            return null;
        }
        String ns = SdkRepository.NS_SDK_REPOSITORY;
        Element newRoot = newDoc.createElementNS(ns, "sdk-repository");
        newRoot.setPrefix(prefix);
        newDoc.appendChild(newRoot);
        int numTool = 0;
        Node tool = null;
        while ((tool = this.findChild(oldRoot, tool, prefix, "tool")) != null) {
            try {
                Node revision = this.findChild(tool, null, prefix, "revision");
                Node archives = this.findChild(tool, null, prefix, "archives");
                if (revision == null || archives == null) continue;
                int rev = 0;
                try {
                    String content = revision.getTextContent();
                    content = content.trim();
                    rev = Integer.parseInt(content);
                    if (rev < 1) {
                    }
                }
                catch (NumberFormatException ignore) {}
                continue;
                Element newTool = newDoc.createElementNS(ns, "tool");
                newTool.setPrefix(prefix);
                this.appendChild(newTool, ns, prefix, "revision", Integer.toString(rev));
                Element newArchives = this.appendChild(newTool, ns, prefix, "archives", null);
                int numArchives = 0;
                Node archive = null;
                while ((archive = this.findChild(archives, archive, prefix, "archive")) != null) {
                    try {
                        String sha1;
                        NamedNodeMap attrs;
                        Node typeNode;
                        Node node;
                        String url;
                        Archive.Os os = (Archive.Os)((Object)XmlParserUtils.getEnumAttribute(archive, "os", (Object[])Archive.Os.values(), null));
                        Archive.Arch arch = (Archive.Arch)((Object)XmlParserUtils.getEnumAttribute(archive, "arch", (Object[])Archive.Arch.values(), (Object)Archive.Arch.ANY));
                        if (os == null || !os.isCompatible() || arch == null || !arch.isCompatible() || (url = (node = this.findChild(archive, null, prefix, "url")) == null ? null : node.getTextContent().trim()) == null || url.length() == 0) continue;
                        node = this.findChild(archive, null, prefix, "size");
                        long size = 0L;
                        try {
                            size = Long.parseLong(node.getTextContent());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (size < 1L || (node = this.findChild(archive, null, prefix, "checksum")) == null || (typeNode = (attrs = node.getAttributes()).getNamedItem("type")) == null || !"type".equals(typeNode.getNodeName()) || !"sha1".equals(typeNode.getNodeValue()) || (sha1 = node == null ? null : node.getTextContent().trim()) == null || sha1.length() != 40) continue;
                        Element ar = this.appendChild(newArchives, ns, prefix, "archive", null);
                        ar.setAttributeNS(ns, "os", os.getXmlName());
                        ar.setAttributeNS(ns, "arch", arch.getXmlName());
                        this.appendChild(ar, ns, prefix, "url", url);
                        this.appendChild(ar, ns, prefix, "size", Long.toString(size));
                        Element cs = this.appendChild(ar, ns, prefix, "checksum", sha1);
                        cs.setAttributeNS(ns, "type", "sha1");
                        ++numArchives;
                    }
                    catch (Exception ignore1) {}
                }
                if (numArchives <= 0) continue;
                newRoot.appendChild(newTool);
                ++numTool;
            }
            catch (Exception ignore2) {}
        }
        return numTool > 0 ? newDoc : null;
    }

    private Node findChild(Node rootNode, Node after, String prefix, String nodeName) {
        Node child;
        nodeName = prefix + ":" + nodeName;
        Node node = child = after == null ? rootNode.getFirstChild() : after.getNextSibling();
        while (child != null) {
            if (child.getNodeType() == 1 && nodeName.equals(child.getNodeName())) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private Element appendChild(Element rootNode, String namespaceUri, String prefix, String nodeName, String nodeValue) {
        Element node = rootNode.getOwnerDocument().createElementNS(namespaceUri, nodeName);
        node.setPrefix(prefix);
        if (nodeValue != null) {
            node.setTextContent(nodeValue);
        }
        rootNode.appendChild(node);
        return node;
    }

    private Validator getValidator(int version) throws SAXException {
        InputStream xsdStream = SdkRepository.getXsdStream(version);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            return null;
        }
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        Validator validator = schema == null ? null : schema.newValidator();
        return validator;
    }

    protected boolean parsePackages(Document doc, String nsUri, ITaskMonitor monitor) {
        assert (doc != null);
        Node root = this.getFirstChild(doc, nsUri, "sdk-repository");
        if (root != null) {
            Node child;
            ArrayList<AddonPackage> packages = new ArrayList<AddonPackage>();
            HashMap<String, String> licenses = new HashMap<String, String>();
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                Node id;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !child.getLocalName().equals("license") || (id = child.getAttributes().getNamedItem("id")) == null) continue;
                licenses.put(id.getNodeValue(), child.getTextContent());
            }
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI())) continue;
                String name = child.getLocalName();
                Package p = null;
                try {
                    if ("add-on".equals(name)) {
                        p = new AddonPackage(this, child, licenses);
                    } else if ("extra".equals(name)) {
                        p = new ExtraPackage(this, child, licenses);
                    } else if (!this.mUserSource) {
                        if ("platform".equals(name)) {
                            p = new PlatformPackage(this, child, licenses);
                        } else if ("doc".equals(name)) {
                            p = new DocPackage(this, child, licenses);
                        } else if ("tool".equals(name)) {
                            p = new ToolPackage(this, child, licenses);
                        } else if ("sample".equals(name)) {
                            p = new SamplePackage(this, child, licenses);
                        }
                    }
                    if (p == null) continue;
                    packages.add((AddonPackage)p);
                    monitor.setDescription("Found %1$s", p.getShortDescription());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.mPackages = packages.toArray(new Package[packages.size()]);
            Arrays.sort(this.mPackages, null);
            return true;
        }
        return false;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    private Document getDocument(ByteArrayInputStream xml, ITaskMonitor monitor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            monitor.setResult("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.setResult("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.setResult("Failed to read XML document", new Object[0]);
        }
        return null;
    }
}

