/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Package
implements IDescription,
Comparable<Package> {
    public static final String PROP_REVISION = "Pkg.Revision";
    public static final String PROP_LICENSE = "Pkg.License";
    public static final String PROP_DESC = "Pkg.Desc";
    public static final String PROP_DESC_URL = "Pkg.DescUrl";
    public static final String PROP_RELEASE_NOTE = "Pkg.RelNote";
    public static final String PROP_RELEASE_URL = "Pkg.RelNoteUrl";
    public static final String PROP_SOURCE_URL = "Pkg.SourceUrl";
    public static final String PROP_USER_SOURCE = "Pkg.UserSrc";
    public static final String PROP_OBSOLETE = "Pkg.Obsolete";
    private final int mRevision;
    private final String mObsolete;
    private final String mLicense;
    private final String mDescription;
    private final String mDescUrl;
    private final String mReleaseNote;
    private final String mReleaseUrl;
    private final Archive[] mArchives;
    private final RepoSource mSource;

    Package(RepoSource source, Node packageNode, Map<String, String> licenses) {
        this.mSource = source;
        this.mRevision = XmlParserUtils.getXmlInt(packageNode, "revision", 0);
        this.mDescription = XmlParserUtils.getXmlString(packageNode, "description");
        this.mDescUrl = XmlParserUtils.getXmlString(packageNode, "desc-url");
        this.mReleaseNote = XmlParserUtils.getXmlString(packageNode, "release-note");
        this.mReleaseUrl = XmlParserUtils.getXmlString(packageNode, "release-url");
        this.mObsolete = XmlParserUtils.getOptionalXmlString(packageNode, "obsolete");
        this.mLicense = this.parseLicense(packageNode, licenses);
        this.mArchives = this.parseArchives(XmlParserUtils.getFirstChild(packageNode, "archives"));
    }

    public Package(RepoSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        if (description == null) {
            description = "";
        }
        if (descUrl == null) {
            descUrl = "";
        }
        this.mRevision = Integer.parseInt(this.getProperty(props, PROP_REVISION, Integer.toString(revision)));
        this.mLicense = this.getProperty(props, PROP_LICENSE, license);
        this.mDescription = this.getProperty(props, PROP_DESC, description);
        this.mDescUrl = this.getProperty(props, PROP_DESC_URL, descUrl);
        this.mReleaseNote = this.getProperty(props, PROP_RELEASE_NOTE, "");
        this.mReleaseUrl = this.getProperty(props, PROP_RELEASE_URL, "");
        this.mObsolete = this.getProperty(props, PROP_OBSOLETE, null);
        String srcUrl = this.getProperty(props, PROP_SOURCE_URL, null);
        if (props != null && source == null && srcUrl != null) {
            boolean isUser = Boolean.parseBoolean(props.getProperty(PROP_USER_SOURCE, Boolean.TRUE.toString()));
            source = new RepoSource(srcUrl, isUser);
        }
        this.mSource = source;
        this.mArchives = new Archive[1];
        this.mArchives[0] = new Archive(this, props, archiveOs, archiveArch, archiveOsPath);
    }

    protected String getProperty(Properties props, String propKey, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        return props.getProperty(propKey, defaultValue);
    }

    void saveProperties(Properties props) {
        props.setProperty(PROP_REVISION, Integer.toString(this.mRevision));
        if (this.mLicense != null && this.mLicense.length() > 0) {
            props.setProperty(PROP_LICENSE, this.mLicense);
        }
        if (this.mDescription != null && this.mDescription.length() > 0) {
            props.setProperty(PROP_DESC, this.mDescription);
        }
        if (this.mDescUrl != null && this.mDescUrl.length() > 0) {
            props.setProperty(PROP_DESC_URL, this.mDescUrl);
        }
        if (this.mReleaseNote != null && this.mReleaseNote.length() > 0) {
            props.setProperty(PROP_RELEASE_NOTE, this.mReleaseNote);
        }
        if (this.mReleaseUrl != null && this.mReleaseUrl.length() > 0) {
            props.setProperty(PROP_RELEASE_URL, this.mReleaseUrl);
        }
        if (this.mObsolete != null) {
            props.setProperty(PROP_OBSOLETE, this.mObsolete);
        }
        if (this.mSource != null) {
            props.setProperty(PROP_SOURCE_URL, this.mSource.getUrl());
            props.setProperty(PROP_USER_SOURCE, Boolean.toString(this.mSource.isUserSource()));
        }
    }

    private String parseLicense(Node packageNode, Map<String, String> licenses) {
        Node ref;
        Node usesLicense = XmlParserUtils.getFirstChild(packageNode, "uses-license");
        if (usesLicense != null && (ref = usesLicense.getAttributes().getNamedItem("ref")) != null) {
            String licenseRef = ref.getNodeValue();
            return licenses.get(licenseRef);
        }
        return null;
    }

    private Archive[] parseArchives(Node archivesNode) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (archivesNode != null) {
            String nsUri = archivesNode.getNamespaceURI();
            for (Node child = archivesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"archive".equals(child.getLocalName())) continue;
                archives.add(this.parseArchive(child));
            }
        }
        return archives.toArray(new Archive[archives.size()]);
    }

    private Archive parseArchive(Node archiveNode) {
        Archive a = new Archive(this, (Archive.Os)((Object)XmlParserUtils.getEnumAttribute(archiveNode, "os", (Object[])Archive.Os.values(), null)), (Archive.Arch)((Object)XmlParserUtils.getEnumAttribute(archiveNode, "arch", (Object[])Archive.Arch.values(), (Object)Archive.Arch.ANY)), XmlParserUtils.getXmlString(archiveNode, "url"), XmlParserUtils.getXmlLong(archiveNode, "size", 0L), XmlParserUtils.getXmlString(archiveNode, "checksum"));
        return a;
    }

    public RepoSource getParentSource() {
        return this.mSource;
    }

    public boolean isObsolete() {
        return this.mObsolete != null;
    }

    public int getRevision() {
        return this.mRevision;
    }

    public String getLicense() {
        return this.mLicense;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getDescUrl() {
        return this.mDescUrl;
    }

    public String getReleaseNote() {
        return this.mReleaseNote;
    }

    public String getReleaseNoteUrl() {
        return this.mReleaseUrl;
    }

    public Archive[] getArchives() {
        return this.mArchives;
    }

    public boolean hasCompatibleArchive() {
        for (Archive archive : this.mArchives) {
            if (!archive.isCompatible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract String getShortDescription();

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        String s = this.getDescription();
        if (s != null) {
            sb.append(s);
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(String.format("Revision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : ""));
        s = this.getDescUrl();
        if (s != null && s.length() > 0) {
            sb.append(String.format("\n\nMore information at %1$s", s));
        }
        if ((s = this.getReleaseNote()) != null && s.length() > 0) {
            sb.append("\n\nRelease note:\n").append(s);
        }
        if ((s = this.getReleaseNoteUrl()) != null && s.length() > 0) {
            sb.append("\nRelease note URL: ").append(s);
        }
        return sb.toString();
    }

    public abstract File getInstallFolder(String var1, String var2, SdkManager var3);

    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        return true;
    }

    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
    }

    public abstract boolean sameItemAs(Package var1);

    public UpdateInfo canBeUpdatedBy(Package replacementPackage) {
        if (replacementPackage == null) {
            return UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(replacementPackage)) {
            return UpdateInfo.INCOMPATIBLE;
        }
        if (replacementPackage.getRevision() > this.getRevision()) {
            return UpdateInfo.UPDATE;
        }
        return UpdateInfo.NOT_UPDATE;
    }

    @Override
    public int compareTo(Package other) {
        int s1 = this.sortingScore();
        int s2 = other.sortingScore();
        return s1 - s2;
    }

    private int sortingScore() {
        int type = 0;
        int rev = this.getRevision();
        int offset = 0;
        type = this instanceof ToolPackage ? 5 : (this instanceof DocPackage ? 4 : (this instanceof PlatformPackage ? 3 : (this instanceof SamplePackage ? 2 : (this instanceof AddonPackage ? 1 : 0))));
        if (this instanceof IPackageVersion) {
            AndroidVersion v = ((IPackageVersion)((Object)this)).getVersion();
            offset = v.getApiLevel();
            offset = offset * 2 + (v.isPreview() ? 1 : 0);
        }
        int n = (type << 28) + (offset << 12) + rev;
        return 0 - n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateInfo {
        INCOMPATIBLE,
        NOT_UPDATE,
        UPDATE;

    }
}

