/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.xml.AndroidManifest;
import com.android.sdklib.xml.AndroidXPathFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCreator {
    private static final String PH_JAVA_FOLDER = "PACKAGE_PATH";
    private static final String PH_PACKAGE = "PACKAGE";
    @Deprecated
    private static final String PH_ACTIVITY_NAME = "ACTIVITY_NAME";
    private static final String PH_ACTIVITY_ENTRY_NAME = "ACTIVITY_ENTRY_NAME";
    private static final String PH_ACTIVITY_CLASS_NAME = "ACTIVITY_CLASS_NAME";
    private static final String PH_ACTIVITY_FQ_NAME = "ACTIVITY_FQ_NAME";
    private static final String PH_ACTIVITY_TESTED_CLASS_NAME = "ACTIVITY_TESTED_CLASS_NAME";
    private static final String PH_PROJECT_NAME = "PROJECT_NAME";
    private static final String PH_ICON = "ICON";
    public static final Pattern RE_PROJECT_NAME = Pattern.compile("[a-zA-Z0-9_]+");
    public static final String CHARS_PROJECT_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_PACKAGE_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+");
    public static final String CHARS_PACKAGE_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_ACTIVITY_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    public static final String CHARS_ACTIVITY_NAME = "a-z A-Z 0-9 _";
    private final OutputLevel mLevel;
    private final ISdkLog mLog;
    private final String mSdkFolder;
    private final SdkManager mSdkManager;

    public ProjectCreator(SdkManager sdkManager, String sdkFolder, OutputLevel level, ISdkLog log) {
        this.mSdkManager = sdkManager;
        this.mSdkFolder = sdkFolder;
        this.mLevel = level;
        this.mLog = log;
    }

    public void createProject(String folderPath, String projectName, String packageName, String activityEntry, IAndroidTarget target, boolean library, String pathToMainProject) {
        File projectFolder = this.checkNewProjectLocation(folderPath);
        if (projectFolder == null) {
            return;
        }
        try {
            boolean isTestProject = pathToMainProject != null;
            ProjectPropertiesWorkingCopy localProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL);
            localProperties.setProperty("sdk.dir", this.mSdkFolder);
            localProperties.save();
            ProjectPropertiesWorkingCopy defaultProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.DEFAULT);
            defaultProperties.setProperty("target", target.hashString());
            if (library) {
                defaultProperties.setProperty("android.library", "true");
            }
            defaultProperties.save();
            ProjectPropertiesWorkingCopy buildProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.BUILD);
            if (target.getVersion().getApiLevel() < 4) {
                buildProperties.setProperty("application.package", packageName);
            }
            if (isTestProject) {
                buildProperties.setProperty("tested.project.dir", pathToMainProject);
            }
            buildProperties.save();
            HashMap<String, String> keywords = new HashMap<String, String>();
            String packagePath = ProjectCreator.stripString(packageName.replace(".", File.separator), File.separatorChar);
            keywords.put(PH_JAVA_FOLDER, packagePath);
            keywords.put(PH_PACKAGE, packageName);
            String fqActivityName = null;
            String activityPath = null;
            String activityClassName = null;
            String originalActivityEntry = activityEntry;
            String originalActivityClassName = null;
            if (activityEntry != null) {
                if (isTestProject) {
                    activityEntry = activityEntry + "Test";
                    int pos = originalActivityEntry.lastIndexOf(46);
                    originalActivityClassName = pos != -1 ? originalActivityEntry.substring(pos + 1) : originalActivityEntry;
                }
                fqActivityName = AndroidManifest.combinePackageAndClassName(packageName, activityEntry);
                activityPath = ProjectCreator.stripString(fqActivityName.replace(".", File.separator), File.separatorChar);
                activityPath = activityPath.substring(0, activityPath.lastIndexOf(File.separatorChar));
                activityClassName = fqActivityName.substring(fqActivityName.lastIndexOf(46) + 1);
            }
            if (target.getVersion().getApiLevel() < 4) {
                if (originalActivityEntry != null) {
                    keywords.put(PH_ACTIVITY_NAME, originalActivityEntry);
                }
            } else if (activityEntry != null) {
                keywords.put(PH_ACTIVITY_ENTRY_NAME, activityEntry);
                keywords.put(PH_ACTIVITY_CLASS_NAME, activityClassName);
                keywords.put(PH_ACTIVITY_FQ_NAME, fqActivityName);
                if (originalActivityClassName != null) {
                    keywords.put(PH_ACTIVITY_TESTED_CLASS_NAME, originalActivityClassName);
                }
            }
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else if (activityClassName != null) {
                keywords.put(PH_PROJECT_NAME, activityClassName);
            } else {
                projectName = projectFolder.getName();
                keywords.put(PH_PROJECT_NAME, projectName);
            }
            if (activityClassName != null) {
                String srcActivityFolderPath = "src" + File.separator + activityPath;
                File sourceFolder = this.createDirs(projectFolder, srcActivityFolderPath);
                String javaTemplate = isTestProject ? "java_tests_file.template" : "java_file.template";
                String activityFileName = activityClassName + ".java";
                this.installTemplate(javaTemplate, new File(sourceFolder, activityFileName), keywords, target);
            } else {
                this.createDirs(projectFolder, "src");
            }
            File resourceFolder = this.createDirs(projectFolder, "res");
            this.createDirs(projectFolder, "bin");
            this.createDirs(projectFolder, "libs");
            if (!isTestProject) {
                File valueFolder = this.createDirs(resourceFolder, "values");
                this.installTemplate("strings.template", new File(valueFolder, "strings.xml"), keywords, target);
                File layoutFolder = this.createDirs(resourceFolder, "layout");
                this.installTemplate("layout.template", new File(layoutFolder, "main.xml"), keywords, target);
                if (this.installIcons(resourceFolder, target)) {
                    keywords.put(PH_ICON, "android:icon=\"@drawable/icon\"");
                } else {
                    keywords.put(PH_ICON, "");
                }
            }
            String manifestTemplate = "AndroidManifest.template";
            if (isTestProject) {
                manifestTemplate = "AndroidManifest.tests.template";
            }
            this.installTemplate(manifestTemplate, new File(projectFolder, "AndroidManifest.xml"), keywords, target);
            this.installTemplate("build.template", new File(projectFolder, "build.xml"), keywords);
        }
        catch (Exception e) {
            this.mLog.error(e, null, new Object[0]);
        }
    }

    public void createExportProject(String folderPath, String projectName, String packageName) {
        File projectFolder = this.checkNewProjectLocation(folderPath);
        if (projectFolder == null) {
            return;
        }
        try {
            ProjectPropertiesWorkingCopy localProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL);
            localProperties.setProperty("sdk.dir", this.mSdkFolder);
            localProperties.save();
            ProjectPropertiesWorkingCopy exportProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.EXPORT);
            exportProperties.setProperty("package", packageName);
            exportProperties.setProperty("versionCode", "1");
            exportProperties.setProperty("projects", "../some/path/here");
            exportProperties.save();
            HashMap<String, String> keywords = new HashMap<String, String>();
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else {
                projectName = projectFolder.getName();
                keywords.put(PH_PROJECT_NAME, projectName);
            }
            this.installTemplate("build.export.template", new File(projectFolder, "build.xml"), keywords);
        }
        catch (Exception e) {
            this.mLog.error(e, null, new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File checkNewProjectLocation(String folderPath) {
        File projectFolder = new File(folderPath);
        if (!projectFolder.exists()) {
            boolean created = false;
            Exception t = null;
            try {
                created = projectFolder.mkdirs();
            }
            catch (Exception e) {
                t = e;
            }
            if (created) {
                this.println("Created project directory: %1$s", projectFolder);
                return projectFolder;
            }
            this.mLog.error(t, "Could not create directory: %1$s", projectFolder);
            return null;
        }
        Exception e = null;
        String error = null;
        try {
            String[] content = projectFolder.list();
            if (content == null) {
                error = "Project folder '%1$s' is not a directory.";
            } else if (content.length != 0) {
                error = "Project folder '%1$s' is not empty. Please consider using '%2$s update' instead.";
            }
        }
        catch (Exception e1) {
            e = e1;
        }
        if (e == null && error == null) return projectFolder;
        this.mLog.error(e, error, projectFolder, SdkConstants.androidCmdName());
        return projectFolder;
    }

    public boolean updateProject(String folderPath, IAndroidTarget target, String projectName, String libraryPath) {
        boolean needsBuildXml;
        File androidManifest = this.checkProjectFolder(folderPath, "AndroidManifest.xml");
        if (androidManifest == null) {
            return false;
        }
        File projectFolder = androidManifest.getParentFile();
        IAndroidTarget originalTarget = null;
        ProjectProperties props = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.DEFAULT);
        if (props != null) {
            String targetHash = props.getProperty("target");
            originalTarget = this.mSdkManager.getTargetFromHashString(targetHash);
        }
        if (originalTarget == null && target == null) {
            this.mLog.error(null, "The project either has no target set or the target is invalid.\nPlease provide a --target to the '%1$s update' command.", SdkConstants.androidCmdName());
            return false;
        }
        if (libraryPath != null) {
            IAndroidTarget finalTarget;
            IAndroidTarget iAndroidTarget = finalTarget = target != null ? target : originalTarget;
            if (!finalTarget.getProperty("sdk.build.support.library", false).booleanValue()) {
                this.mLog.error(null, "The build system for this project target (%1$s) does not support libraries", finalTarget.getFullName());
                return false;
            }
        }
        boolean saveDefaultProps = false;
        ProjectPropertiesWorkingCopy propsWC = null;
        if (target != null) {
            propsWC = props == null ? ProjectProperties.create(folderPath, ProjectProperties.PropertyType.DEFAULT) : props.makeWorkingCopy();
            propsWC.setProperty("target", target.hashString());
            saveDefaultProps = true;
        }
        if (libraryPath != null) {
            String propName;
            String ref;
            String resolvedPath;
            File libProject;
            if (propsWC == null) {
                propsWC = props.makeWorkingCopy();
            }
            if (!(libProject = new File(libraryPath)).isAbsolute()) {
                libProject = new File(folderPath, libraryPath);
                try {
                    resolvedPath = libProject.getCanonicalPath();
                }
                catch (IOException e) {
                    this.mLog.error(e, "Unable to resolve path to library project: %1$s", libraryPath);
                    return false;
                }
            } else {
                resolvedPath = libProject.getAbsolutePath();
            }
            this.println("Resolved location of library project to: %1$s", resolvedPath);
            if (this.checkProjectFolder(resolvedPath, "AndroidManifest.xml") == null) {
                this.mLog.error(null, "No Android Manifest at: %1$s", resolvedPath);
                return false;
            }
            int index = 1;
            while ((ref = props.getProperty(propName = "android.library.reference." + Integer.toString(index))) != null) {
                ++index;
            }
            propName = "android.library.reference." + Integer.toString(index);
            propsWC.setProperty(propName, libraryPath);
            saveDefaultProps = true;
        }
        if (saveDefaultProps) {
            try {
                propsWC.save();
                this.println("Updated %1$s", ProjectProperties.PropertyType.DEFAULT.getFilename());
            }
            catch (Exception e) {
                this.mLog.error(e, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.DEFAULT.getFilename(), folderPath);
                return false;
            }
        }
        propsWC = (props = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.LOCAL)) == null ? ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL) : props.makeWorkingCopy();
        propsWC.setProperty("sdk.dir", this.mSdkFolder);
        try {
            propsWC.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.LOCAL.getFilename());
        }
        catch (Exception e) {
            this.mLog.error(e, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.LOCAL.getFilename(), folderPath);
            return false;
        }
        File buildXml = new File(projectFolder, "build.xml");
        boolean bl = needsBuildXml = projectName != null || !buildXml.exists();
        if (!needsBuildXml) {
            boolean bl2 = needsBuildXml = !this.checkFileContainsRegexp(buildXml, "classname=\"com.android.ant.SetupTask\"");
        }
        if (!needsBuildXml) {
            boolean bl3 = needsBuildXml = !this.checkFileContainsRegexp(buildXml, "<setup(?:\\s|/|$)");
        }
        if (needsBuildXml && buildXml.exists()) {
            this.println("File %1$s is too old and needs to be updated.", "build.xml");
        }
        if (needsBuildXml) {
            HashMap<String, String> keywords = new HashMap<String, String>();
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else {
                this.extractPackageFromManifest(androidManifest, keywords);
                if (keywords.containsKey(PH_ACTIVITY_ENTRY_NAME)) {
                    String activity = keywords.get(PH_ACTIVITY_ENTRY_NAME);
                    int pos = activity.lastIndexOf(46);
                    if (pos != -1) {
                        activity = activity.substring(pos + 1);
                    }
                    keywords.put(PH_PROJECT_NAME, activity);
                } else {
                    projectName = projectFolder.getName();
                    keywords.put(PH_PROJECT_NAME, projectName);
                }
            }
            if (this.mLevel == OutputLevel.VERBOSE) {
                this.println("Regenerating %1$s with project name %2$s", "build.xml", keywords.get(PH_PROJECT_NAME));
            }
            try {
                this.installTemplate("build.template", new File(projectFolder, "build.xml"), keywords);
            }
            catch (ProjectCreateException e) {
                this.mLog.error(e, null, new Object[0]);
                return false;
            }
        }
        return true;
    }

    public void updateTestProject(String folderPath, String pathToMainProject, SdkManager sdkManager) {
        String resolvedPath;
        if (this.checkProjectFolder(folderPath, "AndroidManifest.xml") == null) {
            return;
        }
        File mainProject = new File(pathToMainProject);
        if (!mainProject.isAbsolute()) {
            mainProject = new File(folderPath, pathToMainProject);
            try {
                resolvedPath = mainProject.getCanonicalPath();
            }
            catch (IOException e) {
                this.mLog.error(e, "Unable to resolve path to main project: %1$s", pathToMainProject);
                return;
            }
        } else {
            resolvedPath = mainProject.getAbsolutePath();
        }
        this.println("Resolved location of main project to: %1$s", resolvedPath);
        if (this.checkProjectFolder(resolvedPath, "AndroidManifest.xml") == null) {
            this.mLog.error(null, "No Android Manifest at: %1$s", resolvedPath);
            return;
        }
        ProjectProperties defaultProp = ProjectProperties.load(resolvedPath, ProjectProperties.PropertyType.DEFAULT);
        if (defaultProp == null) {
            this.mLog.error(null, "No %1$s at: %2$s", ProjectProperties.PropertyType.DEFAULT.getFilename(), resolvedPath);
            return;
        }
        String targetHash = defaultProp.getProperty("target");
        if (targetHash == null) {
            this.mLog.error(null, "%1$s in the main project has no target property.", ProjectProperties.PropertyType.DEFAULT.getFilename());
            return;
        }
        IAndroidTarget target = sdkManager.getTargetFromHashString(targetHash);
        if (target == null) {
            this.mLog.error(null, "Main project target %1$s is not a valid target.", targetHash);
            return;
        }
        String projectName = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        File testBuildXml = new File(folderPath, "build.xml");
        if (testBuildXml.isFile()) {
            try {
                projectName = xpath.evaluate("/project/@name", new InputSource(new FileInputStream(testBuildXml)));
            }
            catch (XPathExpressionException e) {
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (projectName == null) {
            try {
                String mainProjectName = xpath.evaluate("/project/@name", new InputSource(new FileInputStream(new File(resolvedPath, "build.xml"))));
                projectName = mainProjectName + "Test";
            }
            catch (XPathExpressionException e) {
                this.mLog.error(e, "Unable to query main project name.", new Object[0]);
                return;
            }
            catch (FileNotFoundException e) {
                this.mLog.error(e, "Unable to query main project name.", new Object[0]);
                return;
            }
        }
        if (!this.updateProject(folderPath, target, projectName, null)) {
            return;
        }
        ProjectProperties buildProps = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.BUILD);
        ProjectPropertiesWorkingCopy buildWorkingCopy = buildProps == null ? ProjectProperties.create(folderPath, ProjectProperties.PropertyType.BUILD) : buildProps.makeWorkingCopy();
        buildWorkingCopy.setProperty("tested.project.dir", pathToMainProject);
        try {
            buildWorkingCopy.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.BUILD.getFilename());
        }
        catch (Exception e) {
            this.mLog.error(e, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.BUILD.getFilename(), folderPath);
            return;
        }
    }

    public boolean updateExportProject(String folderPath, String projectName, boolean force) {
        boolean needsBuildXml;
        File androidManifest = this.checkProjectFolder(folderPath, "export.properties");
        if (androidManifest == null) {
            return false;
        }
        File projectFolder = androidManifest.getParentFile();
        ProjectProperties props = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.LOCAL);
        ProjectPropertiesWorkingCopy localPropsWorkingCopy = props == null ? ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL) : props.makeWorkingCopy();
        localPropsWorkingCopy.setProperty("sdk.dir", this.mSdkFolder);
        try {
            localPropsWorkingCopy.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.LOCAL.getFilename());
        }
        catch (Exception e) {
            this.mLog.error(e, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.LOCAL.getFilename(), folderPath);
            return false;
        }
        File buildXml = new File(projectFolder, "build.xml");
        boolean bl = needsBuildXml = force || projectName != null || !buildXml.exists();
        if (needsBuildXml) {
            HashMap<String, String> keywords = new HashMap<String, String>();
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else {
                projectName = projectFolder.getName();
                keywords.put(PH_PROJECT_NAME, projectName);
            }
            if (this.mLevel == OutputLevel.VERBOSE) {
                this.println("Regenerating %1$s with project name %2$s", "build.xml", keywords.get(PH_PROJECT_NAME));
            }
            try {
                this.installTemplate("build.export.template", new File(projectFolder, "build.xml"), keywords);
            }
            catch (ProjectCreateException e) {
                this.mLog.error(e, null, new Object[0]);
                return false;
            }
        }
        return true;
    }

    private File checkProjectFolder(String folderPath, String requiredFilename) {
        File projectFolder = new File(folderPath);
        if (!projectFolder.isDirectory()) {
            this.mLog.error(null, "Project folder '%1$s' is not a valid directory.", projectFolder);
            return null;
        }
        File requireFile = new File(projectFolder, requiredFilename);
        if (!requireFile.isFile()) {
            this.mLog.error(null, "%1$s is not a valid project (%2$s not found).", folderPath, requiredFilename);
            return null;
        }
        return requireFile;
    }

    private boolean checkFileContainsRegexp(File file, String regexp) {
        Pattern p = Pattern.compile(regexp);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (!p.matcher(line).find()) continue;
                return true;
            }
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private boolean extractPackageFromManifest(File manifestFile, Map<String, String> outKeywords) {
        try {
            XPath xpath = AndroidXPathFactory.newXPath();
            InputSource source = new InputSource(new FileReader(manifestFile));
            String packageName = xpath.evaluate("/manifest/@package", source);
            source = new InputSource(new FileReader(manifestFile));
            String expression = String.format("/manifest/application/activity[intent-filter/action/@%1$s:name='android.intent.action.MAIN' and intent-filter/category/@%1$s:name='android.intent.category.LAUNCHER']/@%1$s:name", "android");
            NodeList activityNames = (NodeList)xpath.evaluate(expression, source, XPathConstants.NODESET);
            if (packageName == null || packageName.length() == 0) {
                this.mLog.error(null, "Missing <manifest package=\"...\"> in '%1$s'", manifestFile.getName());
                return false;
            }
            String activityName = "";
            if (activityNames.getLength() > 0) {
                activityName = activityNames.item(0).getNodeValue();
            }
            if (this.mLevel == OutputLevel.VERBOSE && activityNames.getLength() > 1) {
                this.println("WARNING: There is more than one activity defined in '%1$s'.\nOnly the first one will be used. If this is not appropriate, you need\nto specify one of these values manually instead:", manifestFile.getName());
                for (int i = 0; i < activityNames.getLength(); ++i) {
                    String name = activityNames.item(i).getNodeValue();
                    name = this.combinePackageActivityNames(packageName, name);
                    this.println("- %1$s", name);
                }
            }
            if (activityName.length() == 0) {
                this.mLog.warning("Missing <activity %1$s:name=\"...\"> in '%2$s'.\nNo activity will be generated.", "android", manifestFile.getName());
            } else {
                outKeywords.put(PH_ACTIVITY_ENTRY_NAME, activityName);
            }
            outKeywords.put(PH_PACKAGE, packageName);
            return true;
        }
        catch (IOException e) {
            this.mLog.error(e, "Failed to read %1$s", manifestFile.getName());
        }
        catch (XPathExpressionException e) {
            Throwable t = e.getCause();
            this.mLog.error(t == null ? e : t, "Failed to parse %1$s", manifestFile.getName());
        }
        return false;
    }

    private String combinePackageActivityNames(String packageName, String activityName) {
        int pos = activityName.indexOf(46);
        if (pos == 0) {
            return packageName + activityName;
        }
        if (pos > 0) {
            return activityName;
        }
        return packageName + "." + activityName;
    }

    private void installTemplate(String templateName, File destFile, Map<String, String> placeholderMap, IAndroidTarget target) throws ProjectCreateException {
        String templateFolder = target.getPath(6);
        String sourcePath = templateFolder + File.separator + templateName;
        this.installFullPathTemplate(sourcePath, destFile, placeholderMap);
    }

    private void installTemplate(String templateName, File destFile, Map<String, String> placeholderMap) throws ProjectCreateException {
        String templateFolder = this.mSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER;
        String sourcePath = templateFolder + File.separator + templateName;
        this.installFullPathTemplate(sourcePath, destFile, placeholderMap);
    }

    private void installFullPathTemplate(String sourcePath, File destFile, Map<String, String> placeholderMap) throws ProjectCreateException {
        boolean existed = destFile.exists();
        try {
            String line;
            BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
            BufferedReader in = new BufferedReader(new FileReader(sourcePath));
            while ((line = in.readLine()) != null) {
                if (placeholderMap != null) {
                    for (String key : placeholderMap.keySet()) {
                        line = line.replace(key, placeholderMap.get(key));
                    }
                }
                out.write(line);
                out.newLine();
            }
            out.close();
            in.close();
        }
        catch (Exception e) {
            throw new ProjectCreateException(e, "Could not access %1$s: %2$s", destFile, e.getMessage());
        }
        this.println("%1$s file %2$s", existed ? "Updated" : "Added", destFile);
    }

    private boolean installIcons(File resourceFolder, IAndroidTarget target) throws ProjectCreateException {
        String templateFolder = target.getPath(6);
        boolean installedIcon = false;
        installedIcon |= this.installIcon(templateFolder, "icon_hdpi.png", resourceFolder, "drawable-hdpi");
        installedIcon |= this.installIcon(templateFolder, "icon_mdpi.png", resourceFolder, "drawable-mdpi");
        return installedIcon |= this.installIcon(templateFolder, "icon_ldpi.png", resourceFolder, "drawable-ldpi");
    }

    private boolean installIcon(String templateFolder, String iconName, File resourceFolder, String folderName) throws ProjectCreateException {
        File icon = new File(templateFolder, iconName);
        if (icon.exists()) {
            File drawable = this.createDirs(resourceFolder, folderName);
            this.installBinaryFile(icon, new File(drawable, "icon.png"));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installBinaryFile(File source, File destination) {
        byte[] buffer = new byte[8192];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(destination);
            while ((read = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            new ProjectCreateException(e, "Failed to read binary file: %1$s", source.getAbsolutePath());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void println(String format, Object ... args) {
        if (this.mLevel != OutputLevel.SILENT) {
            if (!format.endsWith("\n")) {
                format = format + "\n";
            }
            this.mLog.printf(format, args);
        }
    }

    private File createDirs(File parent, String name) throws ProjectCreateException {
        File newFolder = new File(parent, name);
        boolean existedBefore = true;
        if (!newFolder.exists()) {
            if (!newFolder.mkdirs()) {
                throw new ProjectCreateException("Could not create directory: %1$s", newFolder);
            }
            existedBefore = false;
        }
        if (newFolder.isDirectory()) {
            if (!newFolder.canWrite()) {
                throw new ProjectCreateException("Path is not writable: %1$s", newFolder);
            }
        } else {
            throw new ProjectCreateException("Path is not a directory: %1$s", newFolder);
        }
        if (!existedBefore) {
            try {
                this.println("Created directory %1$s", newFolder.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ProjectCreateException("Could not determine canonical path of created directory", new Object[]{e});
            }
        }
        return newFolder;
    }

    private static String stripString(String s, char strip) {
        int newStart;
        int sLen = s.length();
        int newEnd = sLen - 1;
        for (newStart = 0; newStart < sLen && s.charAt(newStart) == strip; ++newStart) {
        }
        while (newEnd >= 0 && s.charAt(newEnd) == strip) {
            --newEnd;
        }
        if (newStart >= sLen || ++newEnd < 0) {
            return "";
        }
        return s.substring(newStart, newEnd);
    }

    private static class ProjectCreateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ProjectCreateException(String message) {
            super(message);
        }

        ProjectCreateException(Throwable t, String format, Object ... args) {
            super(format != null ? String.format(format, args) : format, t);
        }

        ProjectCreateException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputLevel {
        SILENT,
        NORMAL,
        VERBOSE;

    }
}

