/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.SealedApkException;
import com.android.sdklib.internal.build.DebugKeyProvider;
import com.android.sdklib.internal.build.SignedJarBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public final class ApkBuilder {
    private static final Pattern PATTERN_NATIVELIB_EXT = Pattern.compile("^.+\\.so$", 2);
    private final File mApkFile;
    private final File mResFile;
    private final File mDexFile;
    private final PrintStream mVerboseStream;
    private final SignedJarBuilder mBuilder;
    private boolean mDebugMode = false;
    private boolean mIsSealed = false;
    private final NullZipFilter mNullFilter = new NullZipFilter();
    private final JavaAndNativeResourceFilter mFilter = new JavaAndNativeResourceFilter();
    private final HashMap<String, File> mAddedFiles = new HashMap();

    public ApkBuilder(String apkOsPath, String resOsPath, String dexOsPath, String storeOsPath, PrintStream verboseStream) throws ApkCreationException {
        this(new File(apkOsPath), new File(resOsPath), dexOsPath != null ? new File(dexOsPath) : null, storeOsPath, verboseStream);
    }

    public ApkBuilder(File apkFile, File resFile, File dexFile, String storeOsPath, PrintStream verboseStream) throws ApkCreationException {
        this.mApkFile = apkFile;
        this.checkOutputFile(this.mApkFile);
        this.mResFile = resFile;
        this.checkInputFile(this.mResFile, true);
        if (dexFile != null) {
            this.mDexFile = dexFile;
            this.checkInputFile(this.mDexFile, true);
        } else {
            this.mDexFile = null;
        }
        this.mVerboseStream = verboseStream;
        try {
            File storeFile = null;
            if (storeOsPath != null) {
                storeFile = new File(storeOsPath);
                this.checkInputFile(storeFile, false);
            }
            if (storeFile != null) {
                this.verbosePrintln("Using keystore: %s", storeOsPath);
                DebugKeyProvider.IKeyGenOutput keygenOutput = null;
                if (this.mVerboseStream != null) {
                    keygenOutput = new DebugKeyProvider.IKeyGenOutput(){

                        public void out(String message) {
                            ApkBuilder.this.mVerboseStream.println(message);
                        }

                        public void err(String message) {
                            ApkBuilder.this.mVerboseStream.println(message);
                        }
                    };
                }
                DebugKeyProvider keyProvider = new DebugKeyProvider(storeOsPath, null, keygenOutput);
                PrivateKey key = keyProvider.getDebugKey();
                X509Certificate certificate = (X509Certificate)keyProvider.getCertificate();
                if (key == null) {
                    throw new ApkCreationException("Unable to get debug signature key", new Object[0]);
                }
                if (certificate != null && certificate.getNotAfter().compareTo(new Date()) < 0) {
                    throw new ApkCreationException("Debug Certificate expired on " + DateFormat.getInstance().format(certificate.getNotAfter()), new Object[0]);
                }
                this.mBuilder = new SignedJarBuilder(new FileOutputStream(this.mApkFile, false), key, certificate);
            } else {
                this.mBuilder = new SignedJarBuilder(new FileOutputStream(this.mApkFile, false), null, null);
            }
            this.verbosePrintln("Packaging %s", this.mApkFile.getName());
            this.addZipFile(this.mResFile);
            if (this.mDexFile != null) {
                this.addFile(this.mDexFile, "classes.dex");
            }
        }
        catch (DebugKeyProvider.KeytoolException e) {
            if (e.getJavaHome() == null) {
                throw new ApkCreationException(e.getMessage() + "\nJAVA_HOME seems undefined, setting it will help locating keytool automatically\n" + "You can also manually execute the following command\n:" + e.getCommandLine(), new Object[0]);
            }
            throw new ApkCreationException(e.getMessage() + "\nJAVA_HOME is set to: " + e.getJavaHome() + "\nUpdate it if necessary, or manually execute the following command:\n" + e.getCommandLine(), new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof ApkCreationException) {
                throw (ApkCreationException)e;
            }
            throw new ApkCreationException(e);
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.mDebugMode = debugMode;
    }

    public void addFile(File file, String archivePath) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.doAddFile(file, archivePath);
        }
        catch (DuplicateFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApkCreationException(e, "Failed to add %s", file);
        }
    }

    public void addZipFile(File zipFile) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.verbosePrintln("%s:", zipFile);
            this.mNullFilter.reset(zipFile);
            FileInputStream fis = new FileInputStream(zipFile);
            this.mBuilder.writeZip(fis, this.mNullFilter);
        }
        catch (DuplicateFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApkCreationException(e, "Failed to add %s", zipFile);
        }
    }

    public JarStatus addResourcesFromJar(File jarFile) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.verbosePrintln("%s:", jarFile);
            this.mFilter.reset(jarFile);
            FileInputStream fis = new FileInputStream(jarFile);
            this.mBuilder.writeZip(fis, this.mFilter);
            return new JarStatusImpl(this.mFilter.getNativeLibs(), this.mFilter.getNativeLibsConflict());
        }
        catch (DuplicateFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApkCreationException(e, "Failed to add %s", jarFile);
        }
    }

    public void addSourceFolder(File sourceFolder) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        if (sourceFolder.isDirectory()) {
            try {
                File[] files;
                for (File file : files = sourceFolder.listFiles()) {
                    this.processFileForResource(file, null);
                }
            }
            catch (DuplicateFileException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApkCreationException(e, "Failed to add %s", sourceFolder);
            }
        } else {
            if (sourceFolder.exists()) {
                throw new ApkCreationException("%s is not a folder", sourceFolder);
            }
            throw new ApkCreationException("%s does not exist", sourceFolder);
        }
    }

    public void addNativeLibraries(File nativeFolder, String abiFilter) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        if (!nativeFolder.isDirectory()) {
            if (nativeFolder.exists()) {
                throw new ApkCreationException("%s is not a folder", nativeFolder);
            }
            throw new ApkCreationException("%s does not exist", nativeFolder);
        }
        File[] abiList = nativeFolder.listFiles();
        if (abiFilter != null) {
            this.verbosePrintln("Native folder: %1$s with filter %2$ss", nativeFolder, abiFilter);
        } else {
            this.verbosePrintln("Native folder: %s", nativeFolder);
        }
        if (abiList != null) {
            for (File abi : abiList) {
                File[] libs;
                if (!abi.isDirectory() || abiFilter != null && !abiFilter.equals(abi.getName()) || (libs = abi.listFiles()) == null) continue;
                for (File lib : libs) {
                    if (!lib.isFile() || !PATTERN_NATIVELIB_EXT.matcher(lib.getName()).matches() && (!this.mDebugMode || !"gdbserver".equals(lib.getName()))) continue;
                    String path = "lib/" + abi.getName() + "/" + lib.getName();
                    try {
                        this.doAddFile(lib, path);
                    }
                    catch (IOException e) {
                        throw new ApkCreationException(e, "Failed to add %s", lib);
                    }
                }
            }
        }
    }

    public void sealApk() throws ApkCreationException, SealedApkException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.mBuilder.close();
            this.mIsSealed = true;
        }
        catch (Exception e) {
            throw new ApkCreationException(e, "Failed to seal APK", new Object[0]);
        }
    }

    private void verbosePrintln(String format, Object ... args) {
        if (this.mVerboseStream != null) {
            this.mVerboseStream.println(String.format(format, args));
        }
    }

    private void doAddFile(File file, String archivePath) throws DuplicateFileException, IOException {
        this.verbosePrintln("%1$s => %2$s", file, archivePath);
        File duplicate = this.checkFileForDuplicate(archivePath);
        if (duplicate != null) {
            throw new DuplicateFileException(archivePath, duplicate, file);
        }
        this.mAddedFiles.put(archivePath, file);
        this.mBuilder.writeFile(file, archivePath);
    }

    private void processFileForResource(File file, String path) throws IOException, DuplicateFileException {
        if (file.isDirectory()) {
            if (ApkBuilder.checkFolderForPackaging(file.getName())) {
                File[] files;
                path = path == null ? file.getName() : path + "/" + file.getName();
                for (File contentFile : files = file.listFiles()) {
                    this.processFileForResource(contentFile, path);
                }
            }
        } else if (ApkBuilder.checkFileForPackaging(file.getName())) {
            path = path == null ? file.getName() : path + "/" + file.getName();
            this.doAddFile(file, path);
        }
    }

    private File checkFileForDuplicate(String archivePath) {
        return this.mAddedFiles.get(archivePath);
    }

    private void checkOutputFile(File file) throws ApkCreationException {
        if (file.isDirectory()) {
            throw new ApkCreationException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new ApkCreationException("Cannot write %s", file);
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new ApkCreationException("Failed to create %s", file);
                }
            }
            catch (IOException e) {
                throw new ApkCreationException("Failed to create '%1$ss': %2$s", file, e.getMessage());
            }
        }
    }

    private void checkInputFile(File file, boolean throwIfDoesntExist) throws ApkCreationException {
        if (file.isDirectory()) {
            throw new ApkCreationException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new ApkCreationException("Cannot read %s", file);
            }
        } else if (throwIfDoesntExist) {
            throw new ApkCreationException("%s does not exist", file);
        }
    }

    public static String getDebugKeystore() throws ApkCreationException {
        try {
            return DebugKeyProvider.getDefaultKeyStoreOsPath();
        }
        catch (Exception e) {
            throw new ApkCreationException(e, e.getMessage(), new Object[0]);
        }
    }

    public static boolean checkFolderForPackaging(String folderName) {
        return !folderName.equalsIgnoreCase("CVS") && !folderName.equalsIgnoreCase(".svn") && !folderName.equalsIgnoreCase("SCCS") && !folderName.equalsIgnoreCase("META-INF") && !folderName.startsWith("_");
    }

    public static boolean checkFileForPackaging(String fileName) {
        String[] fileSegments = fileName.split("\\.");
        String fileExt = "";
        if (fileSegments.length > 1) {
            fileExt = fileSegments[fileSegments.length - 1];
        }
        return ApkBuilder.checkFileForPackaging(fileName, fileExt);
    }

    public static boolean checkFileForPackaging(String fileName, String extension) {
        if (fileName.charAt(0) == '.') {
            return false;
        }
        return !"aidl".equalsIgnoreCase(extension) && !"java".equalsIgnoreCase(extension) && !"class".equalsIgnoreCase(extension) && !"scc".equalsIgnoreCase(extension) && !"swp".equalsIgnoreCase(extension) && !"package.html".equalsIgnoreCase(fileName) && !"overview.html".equalsIgnoreCase(fileName) && !".cvsignore".equalsIgnoreCase(fileName) && !".DS_Store".equals(fileName) && fileName.charAt(fileName.length() - 1) != '~';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JarStatusImpl
    implements JarStatus {
        public final List<String> mLibs;
        public final boolean mNativeLibsConflict;

        private JarStatusImpl(List<String> libs, boolean nativeLibsConflict) {
            this.mLibs = libs;
            this.mNativeLibsConflict = nativeLibsConflict;
        }

        @Override
        public List<String> getNativeLibs() {
            return this.mLibs;
        }

        @Override
        public boolean hasNativeLibsConflicts() {
            return this.mNativeLibsConflict;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JarStatus {
        public List<String> getNativeLibs();

        public boolean hasNativeLibsConflicts();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JavaAndNativeResourceFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final List<String> mNativeLibs = new ArrayList<String>();
        private boolean mNativeLibsConflict = false;
        private File mInputFile;

        private JavaAndNativeResourceFilter() {
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            String[] segments = archivePath.split("/");
            if (segments.length == 0) {
                return false;
            }
            for (int i = 0; i < segments.length - 1; ++i) {
                if (ApkBuilder.checkFolderForPackaging(segments[i])) continue;
                return false;
            }
            String fileName = segments[segments.length - 1];
            boolean check = ApkBuilder.checkFileForPackaging(fileName);
            if (check) {
                ApkBuilder.this.verbosePrintln("=> %s", new Object[]{archivePath});
                File duplicate = ApkBuilder.this.checkFileForDuplicate(archivePath);
                if (duplicate != null) {
                    throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
                }
                ApkBuilder.this.mAddedFiles.put(archivePath, this.mInputFile);
                if (archivePath.endsWith(".so")) {
                    this.mNativeLibs.add(archivePath);
                    if (archivePath.startsWith("lib/")) {
                        this.mNativeLibsConflict = true;
                    }
                } else if (archivePath.endsWith(".jnilib")) {
                    this.mNativeLibs.add(archivePath);
                }
            }
            return check;
        }

        List<String> getNativeLibs() {
            return this.mNativeLibs;
        }

        boolean getNativeLibsConflict() {
            return this.mNativeLibsConflict;
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
            this.mNativeLibs.clear();
            this.mNativeLibsConflict = false;
        }
    }

    private final class NullZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private File mInputFile;

        private NullZipFilter() {
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
        }

        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            ApkBuilder.this.verbosePrintln("=> %s", new Object[]{archivePath});
            File duplicate = ApkBuilder.this.checkFileForDuplicate(archivePath);
            if (duplicate != null) {
                throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
            }
            ApkBuilder.this.mAddedFiles.put(archivePath, this.mInputFile);
            return true;
        }
    }
}

