/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class Proc
implements Serializable {
    private static final long serialVersionUID = 0L;
    final Proc parent;
    final int id;
    String name;
    final List<Proc> children = new ArrayList<Proc>();
    final transient Map<Integer, LinkedList<Operation>> stacks = new HashMap<Integer, LinkedList<Operation>>();
    int operationCount;
    final List<Operation> operations = new ArrayList<Operation>();
    final List<String> nameHistory = new ArrayList<String>();

    Proc(Proc parent, int id) {
        this.parent = parent;
        this.id = id;
    }

    void setName(String name) {
        if (!name.equals(this.name)) {
            if (this.name != null) {
                this.nameHistory.add(this.name);
            }
            this.name = name;
        }
    }

    public boolean fromZygote() {
        return this.parent != null && this.parent.name.equals("zygote") && !this.name.equals("com.android.development");
    }

    void startOperation(int threadId, LoadedClass loadedClass, long time, Operation.Type type) {
        Operation o = new Operation(this, loadedClass, time, this.operationCount++, type);
        this.operations.add(o);
        LinkedList<Operation> stack = this.stacks.get(threadId);
        if (stack == null) {
            stack = new LinkedList();
            this.stacks.put(threadId, stack);
        }
        if (!stack.isEmpty()) {
            stack.getLast().subops.add(o);
        }
        stack.add(o);
    }

    Operation endOperation(int threadId, String className, LoadedClass loadedClass, long time) {
        LinkedList<Operation> stack = this.stacks.get(threadId);
        if (stack == null || stack.isEmpty()) {
            Proc.didNotStart(className);
            return null;
        }
        Operation o = stack.getLast();
        if (loadedClass != o.loadedClass) {
            Proc.didNotStart(className);
            return null;
        }
        stack.removeLast();
        o.endTimeNanos = time;
        return o;
    }

    private static void didNotStart(String name) {
        System.err.println("Warning: An operation ended on " + name + " but it never started!");
    }

    void print() {
        this.print("");
    }

    private void print(String prefix) {
        System.out.println(prefix + "id=" + this.id + ", name=" + this.name);
        for (Proc child : this.children) {
            child.print(prefix + "    ");
        }
    }

    public String toString() {
        return this.name;
    }
}

