/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

class MemoryUsage
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final MemoryUsage NOT_AVAILABLE = new MemoryUsage();
    static int errorCount = 0;
    final int nativeSharedPages;
    final int javaSharedPages;
    final int otherSharedPages;
    final int nativePrivatePages;
    final int javaPrivatePages;
    final int otherPrivatePages;
    final int allocCount;
    final int allocSize;
    final int freedCount;
    final int freedSize;
    final long nativeHeapSize;
    private static final String CLASS_PATH = "-Xbootclasspath:/system/framework/core.jar:/system/framework/ext.jar:/system/framework/framework.jar:/system/framework/framework-tests.jar:/system/framework/services.jar:/system/framework/loadclass.jar";
    private static final String[] GET_DIRTY_PAGES = new String[]{"adb", "shell", "dalvikvm", "-Xbootclasspath:/system/framework/core.jar:/system/framework/ext.jar:/system/framework/framework.jar:/system/framework/framework-tests.jar:/system/framework/services.jar:/system/framework/loadclass.jar", "LoadClass"};

    public MemoryUsage(String line) {
        String[] parsed = line.split(",");
        this.nativeSharedPages = Integer.parseInt(parsed[1]);
        this.javaSharedPages = Integer.parseInt(parsed[2]);
        this.otherSharedPages = Integer.parseInt(parsed[3]);
        this.nativePrivatePages = Integer.parseInt(parsed[4]);
        this.javaPrivatePages = Integer.parseInt(parsed[5]);
        this.otherPrivatePages = Integer.parseInt(parsed[6]);
        this.allocCount = Integer.parseInt(parsed[7]);
        this.allocSize = Integer.parseInt(parsed[8]);
        this.freedCount = Integer.parseInt(parsed[9]);
        this.freedSize = Integer.parseInt(parsed[10]);
        this.nativeHeapSize = Long.parseLong(parsed[11]);
    }

    MemoryUsage() {
        this.nativeSharedPages = -1;
        this.javaSharedPages = -1;
        this.otherSharedPages = -1;
        this.nativePrivatePages = -1;
        this.javaPrivatePages = -1;
        this.otherPrivatePages = -1;
        this.allocCount = -1;
        this.allocSize = -1;
        this.freedCount = -1;
        this.freedSize = -1;
        this.nativeHeapSize = -1L;
    }

    MemoryUsage(int nativeSharedPages, int javaSharedPages, int otherSharedPages, int nativePrivatePages, int javaPrivatePages, int otherPrivatePages, int allocCount, int allocSize, int freedCount, int freedSize, long nativeHeapSize) {
        this.nativeSharedPages = nativeSharedPages;
        this.javaSharedPages = javaSharedPages;
        this.otherSharedPages = otherSharedPages;
        this.nativePrivatePages = nativePrivatePages;
        this.javaPrivatePages = javaPrivatePages;
        this.otherPrivatePages = otherPrivatePages;
        this.allocCount = allocCount;
        this.allocSize = allocSize;
        this.freedCount = freedCount;
        this.freedSize = freedSize;
        this.nativeHeapSize = nativeHeapSize;
    }

    MemoryUsage subtract(MemoryUsage baseline) {
        return new MemoryUsage(this.nativeSharedPages - baseline.nativeSharedPages, this.javaSharedPages - baseline.javaSharedPages, this.otherSharedPages - baseline.otherSharedPages, this.nativePrivatePages - baseline.nativePrivatePages, this.javaPrivatePages - baseline.javaPrivatePages, this.otherPrivatePages - baseline.otherPrivatePages, this.allocCount - baseline.allocCount, this.allocSize - baseline.allocSize, this.freedCount - baseline.freedCount, this.freedSize - baseline.freedSize, this.nativeHeapSize - baseline.nativeHeapSize);
    }

    int javaHeapSize() {
        return this.allocSize - this.freedSize;
    }

    int totalHeap() {
        return this.javaHeapSize() + (int)this.nativeHeapSize;
    }

    int javaPagesInK() {
        return this.javaSharedPages + this.javaPrivatePages;
    }

    int nativePagesInK() {
        return this.nativeSharedPages + this.nativePrivatePages;
    }

    int otherPagesInK() {
        return this.otherSharedPages + this.otherPrivatePages;
    }

    int totalPages() {
        return this.javaSharedPages + this.javaPrivatePages + this.nativeSharedPages + this.nativePrivatePages + this.otherSharedPages + this.otherPrivatePages;
    }

    boolean isAvailable() {
        return this.nativeSharedPages != -1;
    }

    static MemoryUsage baseline() {
        return MemoryUsage.forClass(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MemoryUsage forClass(String className) {
        MeasureWithTimeout measurer = new MeasureWithTimeout(className);
        new Thread(measurer).start();
        MeasureWithTimeout measureWithTimeout = measurer;
        synchronized (measureWithTimeout) {
            if (measurer.memoryUsage == null) {
                try {
                    measurer.wait(30000L);
                }
                catch (InterruptedException e) {
                    System.err.println("Interrupted waiting for measurement.");
                    e.printStackTrace();
                    return NOT_AVAILABLE;
                }
                if (measurer.memoryUsage == null) {
                    System.err.println("Timed out while measuring " + className + ".");
                    return NOT_AVAILABLE;
                }
            }
            System.err.println("Got memory usage for " + className + ".");
            return measurer.memoryUsage;
        }
    }

    private static void copy(InputStream in, OutputStream out) {
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = in.read(buffer)) > -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Root root = Root.fromFile(args[0]);
        root.baseline = MemoryUsage.baseline();
        for (LoadedClass loadedClass : root.loadedClasses.values()) {
            if (!loadedClass.systemClass) continue;
            loadedClass.measureMemoryUsage();
        }
        root.toFile(args[0]);
    }

    static class MeasureWithTimeout
    implements Runnable {
        final String className;
        MemoryUsage memoryUsage = null;

        MeasureWithTimeout(String className) {
            this.className = className;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MemoryUsage measured = this.measure();
            MeasureWithTimeout measureWithTimeout = this;
            synchronized (measureWithTimeout) {
                this.memoryUsage = measured;
                this.notifyAll();
            }
        }

        private MemoryUsage measure() {
            Object[] commands = GET_DIRTY_PAGES;
            if (this.className != null) {
                ArrayList<String> commandList = new ArrayList<String>(GET_DIRTY_PAGES.length + 1);
                commandList.addAll(Arrays.asList(commands));
                commandList.add(this.className);
                commands = commandList.toArray(new String[commandList.size()]);
            }
            try {
                Process process = Runtime.getRuntime().exec((String[])commands);
                final InputStream err = process.getErrorStream();
                Thread errThread = new Thread(){

                    public void run() {
                        MemoryUsage.copy(err, System.err);
                    }
                };
                errThread.setDaemon(true);
                errThread.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = in.readLine();
                if (line == null || !line.startsWith("DECAFBAD,")) {
                    System.err.println("Got bad response for " + this.className + ": " + line + "; command was " + Arrays.toString(commands));
                    ++errorCount;
                    return NOT_AVAILABLE;
                }
                in.close();
                err.close();
                process.destroy();
                return new MemoryUsage(line);
            }
            catch (IOException e) {
                System.err.println("Error getting stats for " + this.className + ".");
                e.printStackTrace();
                return NOT_AVAILABLE;
            }
        }
    }
}

