/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoadedClass
implements Serializable,
Comparable<LoadedClass> {
    private static final long serialVersionUID = 0L;
    final String name;
    final List<Operation> loads = new ArrayList<Operation>();
    final List<Operation> initializations = new ArrayList<Operation>();
    MemoryUsage memoryUsage = MemoryUsage.NOT_AVAILABLE;
    final boolean systemClass;
    boolean preloaded;
    int mlt = -1;
    int mit = -1;

    LoadedClass(String name, boolean systemClass) {
        this.name = name;
        this.systemClass = systemClass;
    }

    void measureMemoryUsage() {
        this.memoryUsage = MemoryUsage.forClass(this.name);
    }

    int medianLoadTimeMicros() {
        if (this.mlt != -1) {
            return this.mlt;
        }
        this.mlt = LoadedClass.calculateMedian(this.loads);
        return this.mlt;
    }

    int medianInitTimeMicros() {
        if (this.mit != -1) {
            return this.mit;
        }
        this.mit = LoadedClass.calculateMedian(this.initializations);
        return this.mit;
    }

    int medianTimeMicros() {
        return this.medianInitTimeMicros() + this.medianLoadTimeMicros();
    }

    private static int calculateMedian(List<Operation> operations) {
        int size = operations.size();
        if (size == 0) {
            return 0;
        }
        int[] times = new int[size];
        for (int i = 0; i < size; ++i) {
            times[i] = operations.get(i).exclusiveTimeMicros();
        }
        Arrays.sort(times);
        int middle = size / 2;
        if (size % 2 == 1) {
            return times[middle];
        }
        return (times[middle - 1] + times[middle]) / 2;
    }

    Set<String> processNames() {
        HashSet<String> names = new HashSet<String>();
        this.addProcessNames(this.loads, names);
        this.addProcessNames(this.initializations, names);
        return names;
    }

    private void addProcessNames(List<Operation> ops, Set<String> names) {
        for (Operation operation : ops) {
            if (!operation.process.fromZygote()) continue;
            names.add(operation.process.name);
        }
    }

    @Override
    public int compareTo(LoadedClass o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.name;
    }
}

