/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import com.android.ninepatch.GraphicsUtilities;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NinePatch {
    public static final String EXTENSION_9PATCH = ".9.png";
    private BufferedImage mImage;
    private int mMinWidth;
    private int mMinHeight;
    private int[] row;
    private int[] column;
    private boolean mVerticalStartWithPatch;
    private boolean mHorizontalStartWithPatch;
    private List<Rectangle> mFixed;
    private List<Rectangle> mPatches;
    private List<Rectangle> mHorizontalPatches;
    private List<Rectangle> mVerticalPatches;
    private Pair<Integer> mHorizontalPadding;
    private Pair<Integer> mVerticalPadding;
    private float mHorizontalPatchesSum;
    private float mVerticalPatchesSum;
    private int mRemainderHorizontal;
    private int mRemainderVertical;

    public static NinePatch load(URL fileUrl, boolean convert) throws IOException {
        BufferedImage image = null;
        try {
            image = GraphicsUtilities.loadCompatibleImage(fileUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
        boolean is9Patch = fileUrl.getPath().toLowerCase().endsWith(EXTENSION_9PATCH);
        return NinePatch.load(image, is9Patch, convert);
    }

    public static NinePatch load(InputStream stream, boolean is9Patch, boolean convert) throws IOException {
        BufferedImage image = null;
        try {
            image = GraphicsUtilities.loadCompatibleImage(stream);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return NinePatch.load(image, is9Patch, convert);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NinePatch load(BufferedImage image, boolean is9Patch, boolean convert) {
        if (!is9Patch) {
            if (!convert) return null;
            image = NinePatch.convertTo9Patch(image);
            return new NinePatch(image);
        } else {
            NinePatch.ensure9Patch(image);
        }
        return new NinePatch(image);
    }

    public int getWidth() {
        return this.mImage.getWidth() - 2;
    }

    public int getHeight() {
        return this.mImage.getHeight() - 2;
    }

    public boolean getPadding(int[] padding) {
        padding[0] = (Integer)this.mHorizontalPadding.mFirst;
        padding[2] = (Integer)this.mHorizontalPadding.mSecond;
        padding[1] = (Integer)this.mVerticalPadding.mFirst;
        padding[3] = (Integer)this.mVerticalPadding.mSecond;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D graphics2D, int x, int y, int scaledWidth, int scaledHeight) {
        if (scaledWidth <= 1 || scaledHeight <= 1) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics2D.create();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            if (this.mPatches.size() == 0) {
                g.drawImage(this.mImage, x, y, scaledWidth, scaledHeight, null);
                return;
            }
            g.translate(x, y);
            y = 0;
            x = 0;
            this.computePatches(scaledWidth, scaledHeight);
            int fixedIndex = 0;
            int horizontalIndex = 0;
            int verticalIndex = 0;
            int patchIndex = 0;
            float vWeightSum = 1.0f;
            float vRemainder = this.mRemainderVertical;
            boolean vStretch = this.mVerticalStartWithPatch;
            while (y < scaledHeight - 1) {
                boolean hStretch = this.mHorizontalStartWithPatch;
                int height = 0;
                float vExtra = 0.0f;
                float hWeightSum = 1.0f;
                float hRemainder = this.mRemainderHorizontal;
                while (x < scaledWidth - 1) {
                    int width;
                    float extra;
                    Rectangle r;
                    if (!vStretch) {
                        if (hStretch) {
                            r = this.mHorizontalPatches.get(horizontalIndex++);
                            extra = (float)r.width / this.mHorizontalPatchesSum;
                            width = (int)(extra * hRemainder / hWeightSum);
                            hWeightSum -= extra;
                            hRemainder -= (float)width;
                            g.drawImage(this.mImage, x, y, x + width, y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                            x += width;
                        } else {
                            r = this.mFixed.get(fixedIndex++);
                            g.drawImage(this.mImage, x, y, x + r.width, y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                            x += r.width;
                        }
                        height = r.height;
                    } else if (hStretch) {
                        r = this.mPatches.get(patchIndex++);
                        vExtra = (float)r.height / this.mVerticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        extra = (float)r.width / this.mHorizontalPatchesSum;
                        width = (int)(extra * hRemainder / hWeightSum);
                        hWeightSum -= extra;
                        hRemainder -= (float)width;
                        g.drawImage(this.mImage, x, y, x + width, y + height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                        x += width;
                    } else {
                        r = this.mVerticalPatches.get(verticalIndex++);
                        vExtra = (float)r.height / this.mVerticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        g.drawImage(this.mImage, x, y, x + r.width, y + height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                        x += r.width;
                    }
                    hStretch = !hStretch;
                }
                x = 0;
                y += height;
                if (vStretch) {
                    vWeightSum -= vExtra;
                    vRemainder -= (float)height;
                }
                vStretch = !vStretch;
            }
        }
        finally {
            g.dispose();
        }
    }

    void computePatches(int scaledWidth, int scaledHeight) {
        int start;
        boolean measuredWidth = false;
        boolean endRow = true;
        int remainderHorizontal = 0;
        int remainderVertical = 0;
        if (this.mFixed.size() > 0) {
            start = this.mFixed.get((int)0).y;
            for (Rectangle rect : this.mFixed) {
                if (rect.y > start) {
                    endRow = true;
                    measuredWidth = true;
                }
                if (!measuredWidth) {
                    remainderHorizontal += rect.width;
                }
                if (!endRow) continue;
                remainderVertical += rect.height;
                endRow = false;
                start = rect.y;
            }
        }
        this.mRemainderHorizontal = scaledWidth - remainderHorizontal;
        this.mRemainderVertical = scaledHeight - remainderVertical;
        this.mHorizontalPatchesSum = 0.0f;
        if (this.mHorizontalPatches.size() > 0) {
            start = -1;
            for (Rectangle rect : this.mHorizontalPatches) {
                if (rect.x <= start) continue;
                this.mHorizontalPatchesSum += (float)rect.width;
                start = rect.x;
            }
        } else {
            start = -1;
            for (Rectangle rect : this.mPatches) {
                if (rect.x <= start) continue;
                this.mHorizontalPatchesSum += (float)rect.width;
                start = rect.x;
            }
        }
        this.mVerticalPatchesSum = 0.0f;
        if (this.mVerticalPatches.size() > 0) {
            start = -1;
            for (Rectangle rect : this.mVerticalPatches) {
                if (rect.y <= start) continue;
                this.mVerticalPatchesSum += (float)rect.height;
                start = rect.y;
            }
        } else {
            start = -1;
            for (Rectangle rect : this.mPatches) {
                if (rect.y <= start) continue;
                this.mVerticalPatchesSum += (float)rect.height;
                start = rect.y;
            }
        }
    }

    private NinePatch(BufferedImage image) {
        this.mImage = image;
        this.findPatches();
    }

    private void findPatches() {
        int width = this.mImage.getWidth();
        int height = this.mImage.getHeight();
        this.row = GraphicsUtilities.getPixels(this.mImage, 0, 0, width, 1, this.row);
        this.column = GraphicsUtilities.getPixels(this.mImage, 0, 0, 1, height, this.column);
        boolean[] result = new boolean[1];
        Pair<List<Pair<Integer>>> left = this.getPatches(this.column, result);
        this.mVerticalStartWithPatch = result[0];
        result = new boolean[1];
        Pair<List<Pair<Integer>>> top = this.getPatches(this.row, result);
        this.mHorizontalStartWithPatch = result[0];
        this.mFixed = this.getRectangles((List)left.mFirst, (List)top.mFirst);
        this.mPatches = this.getRectangles((List)left.mSecond, (List)top.mSecond);
        if (this.mFixed.size() > 0) {
            this.mHorizontalPatches = this.getRectangles((List)left.mFirst, (List)top.mSecond);
            this.mVerticalPatches = this.getRectangles((List)left.mSecond, (List)top.mFirst);
        } else if (((List)top.mFirst).size() > 0) {
            this.mHorizontalPatches = new ArrayList<Rectangle>(0);
            this.mVerticalPatches = this.getVerticalRectangles((List)top.mFirst);
        } else if (((List)left.mFirst).size() > 0) {
            this.mHorizontalPatches = this.getHorizontalRectangles((List)left.mFirst);
            this.mVerticalPatches = new ArrayList<Rectangle>(0);
        } else {
            this.mVerticalPatches = new ArrayList<Rectangle>(0);
            this.mHorizontalPatches = this.mVerticalPatches;
        }
        this.row = GraphicsUtilities.getPixels(this.mImage, 0, height - 1, width, 1, this.row);
        this.column = GraphicsUtilities.getPixels(this.mImage, width - 1, 0, 1, height, this.column);
        top = this.getPatches(this.row, result);
        this.mHorizontalPadding = this.getPadding((List)top.mFirst);
        left = this.getPatches(this.column, result);
        this.mVerticalPadding = this.getPadding((List)left.mFirst);
    }

    private List<Rectangle> getVerticalRectangles(List<Pair<Integer>> topPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> top : topPairs) {
            int x = (Integer)top.mFirst;
            int width = (Integer)top.mSecond - (Integer)top.mFirst;
            rectangles.add(new Rectangle(x, 1, width, this.mImage.getHeight() - 2));
        }
        return rectangles;
    }

    private List<Rectangle> getHorizontalRectangles(List<Pair<Integer>> leftPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> left : leftPairs) {
            int y = (Integer)left.mFirst;
            int height = (Integer)left.mSecond - (Integer)left.mFirst;
            rectangles.add(new Rectangle(1, y, this.mImage.getWidth() - 2, height));
        }
        return rectangles;
    }

    private Pair<Integer> getPadding(List<Pair<Integer>> pairs) {
        if (pairs.size() == 0) {
            return new Pair<Integer>(0, 0);
        }
        if (pairs.size() == 1) {
            if ((Integer)pairs.get((int)0).mFirst == 1) {
                return new Pair<Integer>((Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst, 0);
            }
            return new Pair<Integer>(0, (Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst);
        }
        int index = pairs.size() - 1;
        return new Pair<Integer>((Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst, (Integer)pairs.get((int)index).mSecond - (Integer)pairs.get((int)index).mFirst);
    }

    private List<Rectangle> getRectangles(List<Pair<Integer>> leftPairs, List<Pair<Integer>> topPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> left : leftPairs) {
            int y = (Integer)left.mFirst;
            int height = (Integer)left.mSecond - (Integer)left.mFirst;
            for (Pair<Integer> top : topPairs) {
                int x = (Integer)top.mFirst;
                int width = (Integer)top.mSecond - (Integer)top.mFirst;
                rectangles.add(new Rectangle(x, y, width, height));
            }
        }
        return rectangles;
    }

    private Pair<List<Pair<Integer>>> getPatches(int[] pixels, boolean[] startWithPatch) {
        int lastIndex = 1;
        int lastPixel = pixels[1];
        boolean first = true;
        ArrayList<Pair<Integer>> fixed = new ArrayList<Pair<Integer>>();
        ArrayList<Pair<Integer>> patches = new ArrayList<Pair<Integer>>();
        for (int i = 1; i < pixels.length - 1; ++i) {
            int pixel = pixels[i];
            if (pixel == lastPixel) continue;
            if (lastPixel == -16777216) {
                if (first) {
                    startWithPatch[0] = true;
                }
                patches.add(new Pair<Integer>(lastIndex, i));
            } else {
                fixed.add(new Pair<Integer>(lastIndex, i));
            }
            first = false;
            lastIndex = i;
            lastPixel = pixel;
        }
        if (lastPixel == -16777216) {
            if (first) {
                startWithPatch[0] = true;
            }
            patches.add(new Pair<Integer>(lastIndex, pixels.length - 1));
        } else {
            fixed.add(new Pair<Integer>(lastIndex, pixels.length - 1));
        }
        if (patches.size() == 0) {
            patches.add(new Pair<Integer>(1, pixels.length - 1));
            startWithPatch[0] = true;
            fixed.clear();
        }
        return new Pair<List<Pair<Integer>>>(fixed, patches);
    }

    private static void ensure9Patch(BufferedImage image) {
        int pixel;
        int i;
        int width = image.getWidth();
        int height = image.getHeight();
        for (i = 0; i < width; ++i) {
            pixel = image.getRGB(i, 0);
            if (pixel != 0 && pixel != -16777216) {
                image.setRGB(i, 0, 0);
            }
            if ((pixel = image.getRGB(i, height - 1)) == 0 || pixel == -16777216) continue;
            image.setRGB(i, height - 1, 0);
        }
        for (i = 0; i < height; ++i) {
            pixel = image.getRGB(0, i);
            if (pixel != 0 && pixel != -16777216) {
                image.setRGB(0, i, 0);
            }
            if ((pixel = image.getRGB(width - 1, i)) == 0 || pixel == -16777216) continue;
            image.setRGB(width - 1, i, 0);
        }
    }

    private static BufferedImage convertTo9Patch(BufferedImage image) {
        BufferedImage buffer = GraphicsUtilities.createTranslucentCompatibleImage(image.getWidth() + 2, image.getHeight() + 2);
        Graphics2D g2 = buffer.createGraphics();
        g2.drawImage((Image)image, 1, 1, null);
        g2.dispose();
        return buffer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<E> {
        E mFirst;
        E mSecond;

        Pair(E first, E second) {
            this.mFirst = first;
            this.mSecond = second;
        }

        public String toString() {
            return "Pair[" + this.mFirst + ", " + this.mSecond + "]";
        }
    }
}

