/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.monkeyrunner.MonkeyRecorder;
import com.android.monkeyrunner.ScriptRunner;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class MonkeyRunner {
    static String monkeyServer = "127.0.0.1";
    static int monkeyPort = 1080;
    static Socket monkeySocket = null;
    static IDevice monkeyDevice;
    static BufferedReader monkeyReader;
    static BufferedWriter monkeyWriter;
    static String monkeyResponse;
    static MonkeyRecorder monkeyRecorder;
    static String scriptName;
    private static Logger logger;
    static final int KEY_INPUT_DELAY = 1000;
    static final String monkeyRunnerVersion = "0.4";

    public static void main(String[] args) throws IOException {
        logger.setLevel(Level.parse("WARNING"));
        MonkeyRunner.processOptions(args);
        logger.info("initAdb");
        MonkeyRunner.initAdbConnection();
        logger.info("openMonkeyConnection");
        MonkeyRunner.openMonkeyConnection();
        logger.info("start_script");
        MonkeyRunner.start_script();
        logger.info("ScriptRunner.run");
        ScriptRunner.run(scriptName);
        logger.info("end_script");
        MonkeyRunner.end_script();
        logger.info("closeMonkeyConnection");
        MonkeyRunner.closeMonkeyConnection();
    }

    public static void initAdbConnection() {
        String adbLocation = "adb";
        boolean device = false;
        boolean emulator = false;
        String serial = null;
        AndroidDebugBridge.init((boolean)false);
        try {
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++count;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (count <= 100) continue;
                System.err.println("Timeout getting device list!");
                return;
            }
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 0) {
                MonkeyRunner.printAndExit("No devices found!", true);
            }
            monkeyDevice = null;
            if (emulator || device) {
                for (IDevice d : devices) {
                    if (d.isEmulator() != emulator) continue;
                    if (monkeyDevice != null) {
                        if (emulator) {
                            MonkeyRunner.printAndExit("Error: more than one emulator launched!", true);
                        } else {
                            MonkeyRunner.printAndExit("Error: more than one device connected!", true);
                        }
                    }
                    monkeyDevice = d;
                }
            } else if (serial != null) {
                for (IDevice d : devices) {
                    if (!serial.equals(d.getSerialNumber())) continue;
                    monkeyDevice = d;
                    break;
                }
            } else {
                if (devices.length > 1) {
                    MonkeyRunner.printAndExit("Error: more than one emulator or device available!", true);
                }
                monkeyDevice = devices[0];
            }
            monkeyDevice.createForward(monkeyPort, monkeyPort);
            String command = "monkey --port " + monkeyPort;
            monkeyDevice.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openMonkeyConnection() {
        try {
            InetAddress addr = InetAddress.getByName(monkeyServer);
            monkeySocket = new Socket(addr, monkeyPort);
            monkeyWriter = new BufferedWriter(new OutputStreamWriter(monkeySocket.getOutputStream()));
            monkeyReader = new BufferedReader(new InputStreamReader(monkeySocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void closeMonkeyConnection() {
        try {
            monkeyReader.close();
            monkeyWriter.close();
            monkeySocket.close();
            AndroidDebugBridge.terminate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void start_script() throws IOException {
        MonkeyRunner.press("menu", false);
        MonkeyRunner.press("menu", false);
        MonkeyRunner.press("home", false);
        monkeyRecorder = new MonkeyRecorder(scriptName, monkeyRunnerVersion);
        MonkeyRunner.addDeviceVars();
        MonkeyRecorder.addComment("Script commands");
    }

    public static void end_script() throws IOException {
        String command = "done";
        MonkeyRunner.sendMonkeyEvent(command, false, false);
        monkeyRecorder.close();
    }

    public static void launch_activity(String name) throws IOException {
        System.out.println("Launching: " + name);
        MonkeyRunner.recordCommand("Launching: " + name);
        monkeyDevice.executeShellCommand("am start -a android.intent.action.MAIN -n " + name, (IShellOutputReceiver)new NullOutputReceiver());
        monkeyRecorder.endCommand();
    }

    public static void grabscreen(String tag) throws IOException {
        tag = tag + ".png";
        try {
            Thread.sleep(1000L);
            MonkeyRunner.getDeviceImage(monkeyDevice, tag, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleep(int msec) throws IOException {
        try {
            MonkeyRunner.recordCommand("sleep: " + msec);
            Thread.sleep(msec);
            MonkeyRunner.recordResponse("OK");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean tap(int x, int y) throws IOException {
        String command = "tap " + x + " " + y;
        boolean result = MonkeyRunner.sendMonkeyEvent(command);
        return result;
    }

    public static boolean press(String key) throws IOException {
        return MonkeyRunner.press(key, true);
    }

    private static boolean press(String key, boolean print) throws IOException {
        String command = "press " + key;
        boolean result = MonkeyRunner.sendMonkeyEvent(command, print, true);
        return result;
    }

    public static boolean down() throws IOException {
        return MonkeyRunner.press("dpad_down");
    }

    public static boolean up() throws IOException {
        return MonkeyRunner.press("dpad_up");
    }

    public static boolean type(String text) throws IOException {
        String[] lines;
        boolean result = false;
        for (String line : lines = text.split("[\\r\\n]+")) {
            result = MonkeyRunner.sendMonkeyEvent("type " + line + "\n");
        }
        return result;
    }

    public static boolean getvar(String name) throws IOException {
        return MonkeyRunner.sendMonkeyEvent("getvar " + name + "\n");
    }

    public static boolean listvar() throws IOException {
        return MonkeyRunner.sendMonkeyEvent("listvar \n");
    }

    private static boolean sendMonkeyEvent(String command) throws IOException {
        return MonkeyRunner.sendMonkeyEvent(command, true, true);
    }

    private static boolean sendMonkeyEvent(String command, Boolean print, Boolean record) throws IOException {
        command = command.trim();
        if (print.booleanValue()) {
            System.out.println("MonkeyCommand: " + command);
        }
        if (record.booleanValue()) {
            MonkeyRunner.recordCommand(command);
        }
        logger.info("Monkey Command: " + command + ".");
        monkeyWriter.write(command + "\n");
        monkeyWriter.flush();
        monkeyResponse = monkeyReader.readLine();
        if (monkeyResponse != null) {
            if (print.booleanValue()) {
                System.out.println("MonkeyServer: " + monkeyResponse);
            }
            if (record.booleanValue()) {
                MonkeyRunner.recordResponse(monkeyResponse);
            }
            logger.info("Monkey Response: " + monkeyResponse + ".");
            if (monkeyResponse.startsWith("ERROR")) {
                return false;
            }
            return monkeyResponse.startsWith("OK");
        }
        if (print.booleanValue()) {
            System.out.println("MonkeyServer: ??no response");
        }
        if (record.booleanValue()) {
            MonkeyRunner.recordResponse("??no response");
        }
        logger.info("Monkey Response: ??no response.");
        return false;
    }

    private static void recordCommand(String command) throws IOException {
        if (monkeyRecorder != null) {
            monkeyRecorder.startCommand();
            MonkeyRecorder.addInput(command);
        }
    }

    private static void recordResponse(String response) throws IOException {
        MonkeyRunner.recordResponse(response, "");
    }

    private static void recordResponse(String response, String filename) throws IOException {
        if (monkeyRecorder != null) {
            MonkeyRecorder.addResult(response, filename);
            monkeyRecorder.endCommand();
        }
    }

    private static void addDeviceVars() throws IOException {
        MonkeyRecorder.addComment("Device specific variables");
        MonkeyRunner.sendMonkeyEvent("listvar \n", false, false);
        if (monkeyResponse.startsWith("OK:")) {
            String[] varNames;
            for (String name : varNames = monkeyResponse.substring(3).split("\\s+")) {
                MonkeyRunner.sendMonkeyEvent("getvar " + name, false, false);
                if (monkeyResponse != null) {
                    if (monkeyResponse.startsWith("OK")) {
                        if (monkeyResponse.length() > 2) {
                            MonkeyRecorder.addDeviceVar(name, monkeyResponse.substring(3));
                            continue;
                        }
                        MonkeyRecorder.addDeviceVar(name, "null");
                        continue;
                    }
                    MonkeyRecorder.addDeviceVar(name, monkeyResponse);
                    continue;
                }
                MonkeyRecorder.addDeviceVar(name, "null");
            }
        } else {
            MonkeyRecorder.addAttribute("listvar", monkeyResponse);
        }
    }

    private static void processOptions(String[] args) {
        int index = 0;
        do {
            String argument;
            if ("-s".equals(argument = args[index++])) {
                if (index == args.length) {
                    MonkeyRunner.printUsageAndQuit("Missing Server after -s");
                }
                monkeyServer = args[index++];
                continue;
            }
            if ("-p".equals(argument)) {
                if (index == args.length) {
                    MonkeyRunner.printUsageAndQuit("Missing Server port after -p");
                }
                monkeyPort = Integer.parseInt(args[index++]);
                continue;
            }
            if ("-v".equals(argument)) {
                if (index == args.length) {
                    MonkeyRunner.printUsageAndQuit("Missing Log Level after -v");
                }
                Level level = Level.parse(args[index++]);
                logger.setLevel(level);
                level = logger.getLevel();
                System.out.println("Log level set to: " + level + "(" + level.intValue() + ").");
                System.out.println("Warning: Log levels below INFO(800) not working currently... parent issues");
                continue;
            }
            if (argument.startsWith("-")) {
                MonkeyRunner.printUsageAndQuit("Unrecognized argument: " + argument + ".");
                monkeyPort = Integer.parseInt(args[index++]);
                continue;
            }
            scriptName = argument;
        } while (index < args.length);
    }

    private static void getDeviceImage(IDevice device, String filepath, boolean landscape) throws IOException {
        BufferedImage image;
        RawImage rawImage;
        MonkeyRunner.recordCommand("grabscreen");
        System.out.println("Grabbing Screeshot: " + filepath + ".");
        try {
            rawImage = device.getScreenshot();
        }
        catch (IOException ioe) {
            MonkeyRunner.recordResponse("No frame buffer", "");
            MonkeyRunner.printAndExit("Unable to get frame buffer: " + ioe.getMessage(), true);
            return;
        }
        if (rawImage == null) {
            MonkeyRunner.recordResponse("No image", "");
            return;
        }
        assert (rawImage.bpp == 16);
        logger.info("Raw Image - height: " + rawImage.height + ", width: " + rawImage.width);
        if (landscape) {
            image = new BufferedImage(rawImage.height, rawImage.width, 2);
            byte[] buffer = rawImage.data;
            int index = 0;
            for (int y = 0; y < rawImage.height; ++y) {
                for (int x = 0; x < rawImage.width; ++x) {
                    int value = buffer[index++] & 0xFF;
                    int r = ((value |= buffer[index++] << 8 & 0xFF00) >> 11 & 0x1F) << 3;
                    int g = (value >> 5 & 0x3F) << 2;
                    int b = (value >> 0 & 0x1F) << 3;
                    value = 0xFF000000 | r << 16 | g << 8 | b;
                    image.setRGB(y, rawImage.width - x - 1, value);
                }
            }
        } else {
            image = new BufferedImage(rawImage.width, rawImage.height, 2);
            byte[] buffer = rawImage.data;
            int index = 0;
            for (int y = 0; y < rawImage.height; ++y) {
                for (int x = 0; x < rawImage.width; ++x) {
                    int value = buffer[index++] & 0xFF;
                    int r = ((value |= buffer[index++] << 8 & 0xFF00) >> 11 & 0x1F) << 3;
                    int g = (value >> 5 & 0x3F) << 2;
                    int b = (value >> 0 & 0x1F) << 3;
                    value = 0xFF000000 | r << 16 | g << 8 | b;
                    image.setRGB(x, y, value);
                }
            }
        }
        if (!ImageIO.write((RenderedImage)image, "png", new File(filepath))) {
            MonkeyRunner.recordResponse("No png writer", "");
            throw new IOException("Failed to find png writer");
        }
        MonkeyRunner.recordResponse("OK", filepath);
    }

    private static void printUsageAndQuit(String message) {
        System.out.println(message);
        System.out.println("Usage: monkeyrunner [options] SCRIPT_FILE");
        System.out.println("");
        System.out.println("    -s      MonkeyServer IP Address.");
        System.out.println("    -p      MonkeyServer TCP Port.");
        System.out.println("    -v      MonkeyServer Logging level (ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF)");
        System.out.println("");
        System.out.println("");
        System.exit(1);
    }

    private static void printAndExit(String message, boolean terminate) {
        System.out.println(message);
        if (terminate) {
            AndroidDebugBridge.terminate();
        }
        System.exit(1);
    }

    static {
        scriptName = null;
        logger = Logger.getLogger("com.android.monkeyrunner");
    }
}

