/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs.sourcer;

import com.android.mkstubs.sourcer.AccessSourcer;
import com.android.mkstubs.sourcer.AnnotationSourcer;
import com.android.mkstubs.sourcer.Output;
import com.android.mkstubs.sourcer.SignatureSourcer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;

class FieldSourcer
implements FieldVisitor {
    private final Output mOutput;
    private final int mAccess;
    private final String mName;
    private final String mDesc;
    private final String mSignature;

    public FieldSourcer(Output output, int access, String name, String desc, String signature) {
        this.mOutput = output;
        this.mAccess = access;
        this.mName = name;
        this.mDesc = desc;
        this.mSignature = signature;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.mOutput.write("@%s", desc);
        return new AnnotationSourcer(this.mOutput);
    }

    public void visitAttribute(Attribute attr) {
        this.mOutput.write("%s /* non-standard attribute */ ", attr.type);
    }

    public void visitEnd() {
        AccessSourcer as = new AccessSourcer(this.mOutput);
        as.write(this.mAccess, AccessSourcer.IS_FIELD);
        if (this.mSignature == null) {
            this.mOutput.write(" %s", Type.getType(this.mDesc).getClassName());
        } else {
            this.mOutput.write(" ", new Object[0]);
            SignatureReader sigReader = new SignatureReader(this.mSignature);
            SignatureSourcer sigSourcer = new SignatureSourcer();
            sigReader.acceptType(sigSourcer);
            this.mOutput.write(sigSourcer.toString(), new Object[0]);
        }
        this.mOutput.write(" %s", this.mName);
        this.mOutput.write(";\n", new Object[0]);
    }
}

