/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs.sourcer;

import com.android.mkstubs.sourcer.Output;
import org.objectweb.asm.AnnotationVisitor;

class AnnotationSourcer
implements AnnotationVisitor {
    private final String mOpenChar;
    private final String mCloseChar;
    private final Output mOutput;
    private boolean mNeedClose;

    public AnnotationSourcer(Output output) {
        this(output, false);
    }

    public AnnotationSourcer(Output output, boolean isArray) {
        this.mOutput = output;
        this.mOpenChar = isArray ? "[" : "(";
        this.mCloseChar = isArray ? "]" : ")";
    }

    public void visit(String name, Object value) {
        this.startOpen();
        if (name != null) {
            this.mOutput.write("%s=", name);
        }
        if (value != null) {
            this.mOutput.write(name.toString(), new Object[0]);
        }
    }

    private void startOpen() {
        if (!this.mNeedClose) {
            this.mNeedClose = true;
            this.mOutput.write(this.mOpenChar, new Object[0]);
        }
    }

    public void visitEnd() {
        if (this.mNeedClose) {
            this.mOutput.write(this.mCloseChar, new Object[0]);
        }
        this.mOutput.write("\n", new Object[0]);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.startOpen();
        this.mOutput.write("@%s", name);
        return this;
    }

    public AnnotationVisitor visitArray(String name) {
        this.startOpen();
        return new AnnotationSourcer(this.mOutput, true);
    }

    public void visitEnum(String name, String desc, String value) {
        this.mOutput.write("/* annotation enum not supported: %s */\n", name);
    }
}

