/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs;

import com.android.mkstubs.Filter;
import com.android.mkstubs.FilterClassAdapter;
import com.android.mkstubs.Main;
import com.android.mkstubs.stubber.ClassStubber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StubGenerator {
    private Main.Logger mLog;

    public StubGenerator(Main.Logger log) {
        this.mLog = log;
    }

    public void generateStubbedJar(File destJar, Map<String, ClassReader> classes, Filter filter) throws IOException {
        TreeMap<String, byte[]> all = new TreeMap<String, byte[]>();
        for (Map.Entry<String, ClassReader> entry : classes.entrySet()) {
            ClassReader cr = entry.getValue();
            byte[] b = this.visitClassStubber(cr, filter);
            String name = this.classNameToEntryPath(cr.getClassName());
            all.put(name, b);
        }
        this.createJar(new FileOutputStream(destJar), all);
        this.mLog.debug("Wrote %s", destJar.getPath());
    }

    String classNameToEntryPath(String className) {
        return className.replaceAll("\\.", "/").concat(".class");
    }

    void createJar(FileOutputStream outStream, Map<String, byte[]> all) throws IOException {
        JarOutputStream jar = new JarOutputStream(outStream);
        for (Map.Entry<String, byte[]> entry : all.entrySet()) {
            String name = entry.getKey();
            JarEntry jar_entry = new JarEntry(name);
            jar.putNextEntry(jar_entry);
            jar.write(entry.getValue());
            jar.closeEntry();
        }
        jar.flush();
        jar.close();
    }

    byte[] visitClassStubber(ClassReader cr, Filter filter) {
        this.mLog.debug("Stub " + cr.getClassName(), new Object[0]);
        ClassWriter cw = new ClassWriter(1);
        ClassStubber stubWriter = new ClassStubber(cw);
        FilterClassAdapter classFilter = new FilterClassAdapter(stubWriter, filter, this.mLog);
        cr.accept(classFilter, 0);
        return cw.toByteArray();
    }
}

