/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs;

import com.android.mkstubs.Filter;
import com.android.mkstubs.FilterClassAdapter;
import com.android.mkstubs.Main;
import com.android.mkstubs.sourcer.ClassSourcer;
import com.android.mkstubs.sourcer.Output;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceGenerator {
    private Main.Logger mLog;

    public SourceGenerator(Main.Logger log) {
        this.mLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSource(File baseDir, Map<String, ClassReader> classes, Filter filter) throws IOException {
        for (Map.Entry<String, ClassReader> entry : classes.entrySet()) {
            ClassReader cr = entry.getValue();
            String name = this.classNameToJavaPath(cr.getClassName());
            OutputStreamWriter fw = null;
            try {
                fw = this.createWriter(baseDir, name);
                this.visitClassSource(fw, cr, filter);
            }
            finally {
                fw.close();
            }
        }
    }

    FileWriter createWriter(File baseDir, String name) throws IOException {
        File f = new File(baseDir, name);
        f.getParentFile().mkdirs();
        this.mLog.debug("Writing " + f.getPath(), new Object[0]);
        return new FileWriter(f);
    }

    String classNameToJavaPath(String className) {
        return className.replace('.', '/').concat(".java");
    }

    void visitClassSource(Writer fw, ClassReader cr, Filter filter) {
        this.mLog.debug("Dump " + cr.getClassName(), new Object[0]);
        ClassSourcer javaWriter = new ClassSourcer(new Output(fw));
        FilterClassAdapter classFilter = new FilterClassAdapter(javaWriter, filter, this.mLog);
        cr.accept(classFilter, 0);
    }
}

