/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs;

import com.android.mkstubs.Filter;
import com.android.mkstubs.Main;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class FilterClassAdapter
extends ClassAdapter {
    private final Main.Logger mLog;
    private final Filter mFilter;
    private String mClassName;

    public FilterClassAdapter(ClassVisitor writer, Filter filter, Main.Logger log) {
        super(writer);
        this.mFilter = filter;
        this.mLog = log;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.mClassName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        super.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 5) == 0) {
            return null;
        }
        String filterName = String.format("%s#%s", this.mClassName, name);
        if (!this.mFilter.accept(filterName)) {
            this.mLog.debug("- Remove field " + filterName, new Object[0]);
            return null;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 5) == 0) {
            return null;
        }
        String filterName = String.format("%s#%s%s", this.mClassName, name, desc);
        if (!this.mFilter.accept(filterName)) {
            this.mLog.debug("- Remove method " + filterName, new Object[0]);
            return null;
        }
        if (signature != null && !this.mFilter.accept(filterName = String.format("%s#%s%s", this.mClassName, name, signature))) {
            this.mLog.debug("- Remove method " + filterName, new Object[0]);
            return null;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return super.visitAnnotation(desc, visible);
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 5) == 0) {
            return;
        }
        if (!this.mFilter.accept(name)) {
            return;
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }
}

