/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs;

import com.android.mkstubs.Filter;
import com.android.mkstubs.Main;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsmAnalyzer {
    AsmAnalyzer() {
    }

    Map<String, ClassReader> parseInputJar(String inputJarPath) throws IOException {
        TreeMap<String, ClassReader> classes = new TreeMap<String, ClassReader>();
        ZipFile zip = new ZipFile(inputJarPath);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            ClassReader cr = new ClassReader(zip.getInputStream(entry));
            String className = AsmAnalyzer.classReaderToAsmName(cr);
            classes.put(className, cr);
        }
        return classes;
    }

    static String classReaderToAsmName(ClassReader classReader) {
        if (classReader == null) {
            return null;
        }
        return classReader.getClassName();
    }

    void filter(Map<String, ClassReader> classes, Filter filter, Main.Logger log) {
        Set<String> keys = classes.keySet();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (filter.accept(key)) continue;
            log.debug("- Remove class " + key, new Object[0]);
            it.remove();
        }
    }
}

