/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.utils;

import com.android.layoutlib.utils.ResourceValue;
import com.android.layoutlib.utils.StyleResourceValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ValueResourceParser
extends DefaultHandler {
    private static final String NODE_RESOURCES = "resources";
    private static final String NODE_ITEM = "item";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PARENT = "parent";
    private static final String RES_STYLE = "style";
    private static final String RES_ATTR = "attr";
    private static final String DEFAULT_NS_PREFIX = "android:";
    private static final int DEFAULT_NS_PREFIX_LEN = "android:".length();
    private boolean inResources = false;
    private int mDepth = 0;
    private StyleResourceValue mCurrentStyle = null;
    private ResourceValue mCurrentValue = null;
    private IValueResourceRepository mRepository;
    private final boolean mIsFramework;

    public ValueResourceParser(IValueResourceRepository repository, boolean isFramework) {
        this.mRepository = repository;
        this.mIsFramework = isFramework;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.mCurrentValue != null) {
            this.mCurrentValue.setValue(ValueResourceParser.trimXmlWhitespaces(this.mCurrentValue.getValue()));
        }
        if (this.inResources && qName.equals(NODE_RESOURCES)) {
            this.inResources = false;
        } else if (this.mDepth == 2) {
            this.mCurrentValue = null;
            this.mCurrentStyle = null;
        } else if (this.mDepth == 3) {
            this.mCurrentValue = null;
        }
        --this.mDepth;
        super.endElement(uri, localName, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String name;
            ++this.mDepth;
            if (!this.inResources && this.mDepth == 1) {
                if (qName.equals(NODE_RESOURCES)) {
                    this.inResources = true;
                }
            } else if (this.mDepth == 2 && this.inResources) {
                String name2;
                String type = NODE_ITEM.equals(qName) ? attributes.getValue(ATTR_TYPE) : qName;
                if (type != null && !RES_ATTR.equals(type) && (name2 = attributes.getValue(ATTR_NAME)) != null) {
                    if (RES_STYLE.equals(type)) {
                        String parent = attributes.getValue(ATTR_PARENT);
                        this.mCurrentStyle = new StyleResourceValue(type, name2, parent, this.mIsFramework);
                        this.mRepository.addResourceValue(type, this.mCurrentStyle);
                    } else {
                        this.mCurrentValue = new ResourceValue(type, name2, this.mIsFramework);
                        this.mRepository.addResourceValue(type, this.mCurrentValue);
                    }
                }
            } else if (this.mDepth == 3 && this.mCurrentStyle != null && (name = attributes.getValue(ATTR_NAME)) != null) {
                if (name.startsWith(DEFAULT_NS_PREFIX)) {
                    name = name.substring(DEFAULT_NS_PREFIX_LEN);
                }
                this.mCurrentValue = new ResourceValue(null, name, this.mIsFramework);
                this.mCurrentStyle.addItem(this.mCurrentValue);
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mCurrentValue != null) {
            String value = this.mCurrentValue.getValue();
            if (value == null) {
                this.mCurrentValue.setValue(new String(ch, start, length));
            } else {
                this.mCurrentValue.setValue(value + new String(ch, start, length));
            }
        }
    }

    public static String trimXmlWhitespaces(String value) {
        int index;
        if (value == null) {
            return null;
        }
        while ((index = value.indexOf(10)) != -1) {
            int right;
            int left;
            for (left = index - 1; left >= 0 && Character.isWhitespace(value.charAt(left)); --left) {
            }
            int count = value.length();
            for (right = index + 1; right < count && Character.isWhitespace(value.charAt(right)); ++right) {
            }
            String leftString = null;
            if (left >= 0) {
                leftString = value.substring(0, left + 1);
            }
            String rightString = null;
            if (right < count) {
                rightString = value.substring(right);
            }
            if (leftString != null) {
                value = leftString;
                if (rightString == null) continue;
                value = value + " " + rightString;
                continue;
            }
            value = rightString != null ? rightString : "";
        }
        int length = value.length();
        char[] buffer = value.toCharArray();
        for (int i = 0; i < length; ++i) {
            if (buffer[i] != '\\' || i + 1 >= length) continue;
            if (buffer[i + 1] == 'u') {
                if (i + 5 >= length) continue;
                int unicodeChar = Integer.parseInt(new String(buffer, i + 2, 4), 16);
                buffer[i] = (char)unicodeChar;
                if (i + 6 < buffer.length) {
                    System.arraycopy(buffer, i + 6, buffer, i + 1, length - i - 6);
                }
                length -= 5;
                continue;
            }
            if (buffer[i + 1] == 'n') {
                buffer[i + 1] = 10;
            }
            System.arraycopy(buffer, i + 1, buffer, i, length - i - 1);
            --length;
        }
        return new String(buffer, 0, length);
    }

    public static interface IValueResourceRepository {
        public void addResourceValue(String var1, ResourceValue var2);
    }
}

