/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.harmony.xnet.provider.jsse.HandshakeProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedTask
implements Runnable {
    public final HandshakeProtocol handshaker;
    public final PrivilegedExceptionAction<Void> action;
    public final AccessControlContext context;

    public DelegatedTask(PrivilegedExceptionAction<Void> action, HandshakeProtocol handshaker, AccessControlContext context) {
        this.action = action;
        this.handshaker = handshaker;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HandshakeProtocol handshakeProtocol = this.handshaker;
        synchronized (handshakeProtocol) {
            try {
                AccessController.doPrivileged(this.action, this.context);
            }
            catch (PrivilegedActionException e) {
                this.handshaker.delegatedTaskErr = e.getException();
            }
            catch (RuntimeException e) {
                this.handshaker.delegatedTaskErr = e;
            }
        }
    }
}

