/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.harmony.xml.ExpatAttributes;
import org.apache.harmony.xml.ExpatException;
import org.apache.harmony.xml.ExpatReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class ExpatParser {
    public static final int BUFFER_SIZE = 8096;
    public int pointer;
    public boolean inStartElement = false;
    public int attributeCount = -1;
    public int attributePointer = 0;
    public final Locator locator = new ExpatLocator(null);
    public final ExpatReader xmlReader;
    public final String publicId;
    public final String systemId;
    public final String encoding;
    public final ExpatAttributes attributes = new CurrentAttributes(null);
    public static final String OUTSIDE_START_ELEMENT = "Attributes can only be used within the scope of startElement().";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CHARACTER_ENCODING = "UTF-16";
    public static final int TIMEOUT = 20000;

    public ExpatParser(String encoding, ExpatReader xmlReader, boolean processNamespaces, String publicId, String systemId) {
        this.publicId = publicId;
        this.systemId = systemId;
        this.xmlReader = xmlReader;
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
        this.pointer = this.initialize(this.encoding, processNamespaces);
    }

    public ExpatParser(String encoding, ExpatReader xmlReader, int pointer, String publicId, String systemId) {
        this.encoding = encoding;
        this.xmlReader = xmlReader;
        this.pointer = pointer;
        this.systemId = systemId;
        this.publicId = publicId;
    }

    public int initialize(String string2, boolean bl) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatParser#initialize(Ljava/lang/String;Z)I", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String uri, String localName, String qName, int attributePointer, int attributeCount) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler == null) {
            return;
        }
        try {
            this.inStartElement = true;
            this.attributePointer = attributePointer;
            this.attributeCount = attributeCount;
            contentHandler.startElement(uri, localName, qName, this.attributes);
        }
        finally {
            this.inStartElement = false;
            this.attributeCount = -1;
            this.attributePointer = 0;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.endElement(uri, localName, qName);
        }
    }

    public void text(char[] text, int length) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.characters(text, 0, length);
        }
    }

    public void comment(char[] text, int length) throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.comment(text, 0, length);
        }
    }

    public void startCdata() throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.startCDATA();
        }
    }

    public void endCdata() throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.endCDATA();
        }
    }

    public void startNamespace(String prefix, String uri) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endNamespace(String prefix) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.endPrefixMapping(prefix);
        }
    }

    public void startDtd(String name, String publicId, String systemId) throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDtd() throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.endDTD();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.processingInstruction(target, data);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        DTDHandler dtdHandler = this.xmlReader.dtdHandler;
        if (dtdHandler != null) {
            dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        DTDHandler dtdHandler = this.xmlReader.dtdHandler;
        if (dtdHandler != null) {
            dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExternalEntity(String context, String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        EntityResolver entityResolver = this.xmlReader.entityResolver;
        if (entityResolver == null) {
            return;
        }
        if (this.systemId != null) {
            try {
                URI systemUri = new URI(systemId);
                if (!systemUri.isAbsolute() && !systemUri.isOpaque()) {
                    URI baseUri = new URI(this.systemId);
                    systemUri = baseUri.resolve(systemUri);
                    systemId = systemUri.toString();
                }
            }
            catch (Exception e) {
                Logger.getLogger(ExpatParser.class.getName()).log(Level.INFO, "Could not resolve '" + systemId + "' relative to" + " '" + this.systemId + "' at " + this.locator, e);
            }
        }
        if ((inputSource = entityResolver.resolveEntity(publicId, systemId)) == null) {
            return;
        }
        String encoding = this.pickEncoding(inputSource);
        int pointer = ExpatParser.createEntityParser(this.pointer, context);
        try {
            EntityParser entityParser = new EntityParser(encoding, this.xmlReader, pointer, inputSource.getPublicId(), inputSource.getSystemId(), null);
            this.parseExternalEntity(entityParser, inputSource);
        }
        finally {
            ExpatParser.releaseParser(pointer);
        }
    }

    public String pickEncoding(InputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            return CHARACTER_ENCODING;
        }
        String encoding = inputSource.getEncoding();
        return encoding == null ? DEFAULT_ENCODING : encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseExternalEntity(ExpatParser entityParser, InputSource inputSource) throws IOException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            try {
                entityParser.append("<externalEntity>");
                entityParser.parseFragment(reader);
                entityParser.append("</externalEntity>");
            }
            finally {
                reader.close();
            }
            return;
        }
        InputStream in = inputSource.getByteStream();
        if (in != null) {
            try {
                entityParser.append("<externalEntity>".getBytes(entityParser.encoding));
                entityParser.parseFragment(in);
                entityParser.append("</externalEntity>".getBytes(entityParser.encoding));
            }
            finally {
                in.close();
            }
            return;
        }
        String systemId = inputSource.getSystemId();
        if (systemId == null) {
            throw new ParseException("No input specified.", this.locator, null);
        }
        in = ExpatParser.openUrl(systemId);
        try {
            entityParser.append("<externalEntity>".getBytes(entityParser.encoding));
            entityParser.parseFragment(in);
            entityParser.append("</externalEntity>".getBytes(entityParser.encoding));
        }
        finally {
            in.close();
        }
    }

    public static int createEntityParser(int n, String string2) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatParser#createEntityParser(ILjava/lang/String;)I", true, null);
    }

    public void append(String xml2) throws SAXException {
        try {
            this.appendString(this.pointer, xml2, false);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator, null);
        }
    }

    public void appendString(int n, String string2, boolean bl) throws SAXException, ExpatException {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatParser#appendString(ILjava/lang/String;Z)V", true, this);
    }

    public void append(char[] xml2, int offset, int length) throws SAXException {
        try {
            this.appendChars(this.pointer, xml2, offset, length);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator, null);
        }
    }

    public void appendChars(int n, char[] cArray, int n2, int n3) throws SAXException, ExpatException {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatParser#appendChars(I[CII)V", true, this);
    }

    public void append(byte[] xml2) throws SAXException {
        this.append(xml2, 0, xml2.length);
    }

    public void append(byte[] xml2, int offset, int length) throws SAXException {
        try {
            this.appendBytes(this.pointer, xml2, offset, length);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator, null);
        }
    }

    public void appendBytes(int n, byte[] byArray, int n2, int n3) throws SAXException, ExpatException {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatParser#appendBytes(I[BII)V", true, this);
    }

    public void parseDocument(InputStream in) throws IOException, SAXException {
        this.startDocument();
        this.parseFragment(in);
        this.finish();
        this.endDocument();
    }

    public void parseDocument(Reader in) throws IOException, SAXException {
        this.startDocument();
        this.parseFragment(in);
        this.finish();
        this.endDocument();
    }

    public void parseFragment(Reader in) throws IOException, SAXException {
        int length;
        char[] buffer = new char[4048];
        while ((length = in.read(buffer)) != -1) {
            try {
                this.appendChars(this.pointer, buffer, 0, length);
            }
            catch (ExpatException e) {
                throw new ParseException(e.getMessage(), this.locator, null);
            }
        }
    }

    public void parseFragment(InputStream in) throws IOException, SAXException {
        int length;
        byte[] buffer = new byte[8096];
        while ((length = in.read(buffer)) != -1) {
            try {
                this.appendBytes(this.pointer, buffer, 0, length);
            }
            catch (ExpatException e) {
                throw new ParseException(e.getMessage(), this.locator, null);
            }
        }
    }

    public void startDocument() throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.setDocumentLocator(this.locator);
            contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.endDocument();
        }
    }

    public void finish() throws SAXException {
        try {
            this.appendString(this.pointer, "", true);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        try {
            if (this.pointer != 0) {
                this.release(this.pointer);
                this.pointer = 0;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void release(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatParser#release(I)V", true, this);
    }

    public static void releaseParser(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatParser#releaseParser(I)V", true, null);
    }

    public static void staticInitialize(String string2) {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatParser#staticInitialize(Ljava/lang/String;)V", true, null);
    }

    public int line() {
        return ExpatParser.line(this.pointer);
    }

    public static int line(int n) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatParser#line(I)I", true, null);
    }

    public int column() {
        return ExpatParser.column(this.pointer);
    }

    public static int column(int n) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatParser#column(I)I", true, null);
    }

    public Attributes cloneAttributes() {
        if (!this.inStartElement) {
            throw new IllegalStateException(OUTSIDE_START_ELEMENT);
        }
        if (this.attributeCount == 0) {
            return ClonedAttributes.EMPTY;
        }
        int clonePointer = ExpatParser.cloneAttributes(this.attributePointer, this.attributeCount);
        return new ClonedAttributes(this.pointer, clonePointer, this.attributeCount, null);
    }

    public static int cloneAttributes(int n, int n2) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatParser#cloneAttributes(II)I", true, null);
    }

    public static InputStream openUrl(String url) throws IOException {
        try {
            URLConnection urlConnection = new URL(url).openConnection();
            urlConnection.setConnectTimeout(20000);
            urlConnection.setReadTimeout(20000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(false);
            return urlConnection.getInputStream();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Couldn't open " + url);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public /* synthetic */ ExpatParser(String x0, ExpatReader x1, int x2, String x3, String x4, 1 x5) {
        this(x0, x1, x2, x3, x4);
    }

    static {
        ExpatParser.staticInitialize("");
    }

    public static class 1 {
    }

    public static class EntityParser
    extends ExpatParser {
        public int depth = 0;

        public EntityParser(String encoding, ExpatReader xmlReader, int pointer, String publicId, String systemId) {
            super(encoding, xmlReader, pointer, publicId, systemId, null);
        }

        public void startElement(String uri, String localName, String qName, int attributePointer, int attributeCount) throws SAXException {
            if (this.depth++ > 0) {
                super.startElement(uri, localName, qName, attributePointer, attributeCount);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (--this.depth > 0) {
                super.endElement(uri, localName, qName);
            }
        }

        public synchronized void finalize() throws Throwable {
        }

        public /* synthetic */ EntityParser(String x0, ExpatReader x1, int x2, String x3, String x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    public static class ParseException
    extends SAXParseException {
        public ParseException(String message, Locator locator) {
            super(ParseException.makeMessage(message, locator), locator);
        }

        public static String makeMessage(String message, Locator locator) {
            return ParseException.makeMessage(message, locator.getLineNumber(), locator.getColumnNumber());
        }

        public static String makeMessage(String message, int line, int column) {
            return "At line " + line + ", column " + column + ": " + message;
        }

        public /* synthetic */ ParseException(String x0, Locator x1, 1 x2) {
            this(x0, x1);
        }
    }

    public class CurrentAttributes
    extends ExpatAttributes {
        public CurrentAttributes() {
        }

        public int getParserPointer() {
            return ExpatParser.this.pointer;
        }

        public int getPointer() {
            if (!ExpatParser.this.inStartElement) {
                throw new IllegalStateException(ExpatParser.OUTSIDE_START_ELEMENT);
            }
            return ExpatParser.this.attributePointer;
        }

        public int getLength() {
            if (!ExpatParser.this.inStartElement) {
                throw new IllegalStateException(ExpatParser.OUTSIDE_START_ELEMENT);
            }
            return ExpatParser.this.attributeCount;
        }

        public /* synthetic */ CurrentAttributes(1 x1) {
            this();
        }
    }

    public class ExpatLocator
    implements Locator {
        public ExpatLocator() {
        }

        public String getPublicId() {
            return ExpatParser.this.publicId;
        }

        public String getSystemId() {
            return ExpatParser.this.systemId;
        }

        public int getLineNumber() {
            return ExpatParser.this.line();
        }

        public int getColumnNumber() {
            return ExpatParser.this.column();
        }

        public String toString() {
            return "Locator[publicId: " + ExpatParser.this.publicId + ", systemId: " + ExpatParser.this.systemId + ", line: " + this.getLineNumber() + ", column: " + this.getColumnNumber() + "]";
        }

        public /* synthetic */ ExpatLocator(1 x1) {
            this();
        }
    }

    public static class ClonedAttributes
    extends ExpatAttributes {
        public static final Attributes EMPTY = new ClonedAttributes(0, 0, 0);
        public final int parserPointer;
        public int pointer;
        public final int length;

        public ClonedAttributes(int parserPointer, int pointer, int length) {
            this.parserPointer = parserPointer;
            this.pointer = pointer;
            this.length = length;
        }

        public int getParserPointer() {
            return this.parserPointer;
        }

        public int getPointer() {
            return this.pointer;
        }

        public int getLength() {
            return this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void finalize() throws Throwable {
            try {
                if (this.pointer != 0) {
                    this.freeAttributes(this.pointer);
                    this.pointer = 0;
                }
            }
            finally {
                super.finalize();
            }
        }

        public /* synthetic */ ClonedAttributes(int x0, int x1, int x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

