/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeInflater;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgeWindow;
import com.android.layoutlib.bridge.android.BridgeWindowSession;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.PhoneSystemBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ResourceValue mWindowBackground;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private Canvas mCanvas;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private boolean mIsAlphaChannelImage;
    private boolean mWindowIsFloating;
    private int mStatusBarSize;
    private int mTitleBarSize;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;

    public RenderSessionImpl(SessionParams params) {
        super(new SessionParams(params));
    }

    @Override
    public Result init(long timeout) {
        Result result = super.init(timeout);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams params = (SessionParams)this.getParams();
        BridgeContext context = this.getContext();
        RenderResources resources = ((SessionParams)this.getParams()).getResources();
        DisplayMetrics metrics = this.getContext().getMetrics();
        this.mIsAlphaChannelImage = this.getBooleanThemeValue(resources, "windowIsFloating", true);
        this.mWindowIsFloating = this.getBooleanThemeValue(resources, "windowIsFloating", true);
        this.findBackground(resources);
        this.findStatusBar(resources, metrics);
        this.findTitleBar(resources, metrics);
        this.mInflater = new BridgeInflater(context, params.getProjectCallback());
        context.setBridgeInflater(this.mInflater);
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)params.getLayoutDescription(), context, false);
        return Result.Status.SUCCESS.createResult();
    }

    public Result inflate() {
        this.checkLock();
        try {
            SessionParams params = (SessionParams)this.getParams();
            BridgeContext context = this.getContext();
            ViewGroup backgroundView = null;
            if (this.mWindowIsFloating || params.isForceNoDecor()) {
                this.mContentRoot = new FrameLayout(context);
                this.mViewRoot = this.mContentRoot;
                backgroundView = this.mContentRoot;
            } else {
                LinearLayout topLayout = new LinearLayout(context);
                this.mViewRoot = topLayout;
                topLayout.setOrientation(1);
                if (this.mStatusBarSize > 0) {
                    try {
                        PhoneSystemBar systemBar = new PhoneSystemBar((Context)context, params.getDensity());
                        systemBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mStatusBarSize));
                        topLayout.addView(systemBar);
                    }
                    catch (XmlPullParserException e) {
                        // empty catch block
                    }
                }
                LinearLayout backgroundLayout = new LinearLayout(context);
                backgroundView = backgroundLayout;
                backgroundLayout.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
                layoutParams.weight = 1.0f;
                backgroundLayout.setLayoutParams(layoutParams);
                topLayout.addView(backgroundLayout);
                if (this.mTitleBarSize > 0) {
                    try {
                        TitleBar titleBar = new TitleBar((Context)context, params.getDensity(), params.getAppLabel());
                        titleBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mTitleBarSize));
                        backgroundLayout.addView(titleBar);
                    }
                    catch (XmlPullParserException e) {
                        // empty catch block
                    }
                }
                this.mContentRoot = new FrameLayout(context);
                layoutParams = new LinearLayout.LayoutParams(-1, -2);
                layoutParams.weight = 1.0f;
                this.mContentRoot.setLayoutParams(layoutParams);
                backgroundLayout.addView(this.mContentRoot);
            }
            View view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            context.popParser();
            View.AttachInfo info = new View.AttachInfo(new BridgeWindowSession(), new BridgeWindow(), new Handler(), null);
            info.mHasWindowFocus = true;
            info.mWindowVisibility = 0;
            info.mInTouchMode = false;
            this.mViewRoot.dispatchAttachedToWindow(info, 0);
            this.postInflateProcess(view, params.getProjectCallback());
            if (this.mWindowBackground != null && backgroundView != null) {
                Drawable d = ResourceHelper.getDrawable(this.mWindowBackground, context);
                backgroundView.setBackgroundDrawable(d);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException e) {
            return Result.Status.ERROR_INFLATION.createResult(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(t.getMessage(), t);
        }
    }

    public Result render(boolean freshRender) {
        this.checkLock();
        SessionParams params = (SessionParams)this.getParams();
        try {
            if (this.mViewRoot == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            SessionParams.RenderingMode renderingMode = params.getRenderingMode();
            boolean newRenderSize = false;
            if (this.mMeasuredScreenWidth == -1) {
                newRenderSize = true;
                this.mMeasuredScreenWidth = params.getScreenWidth();
                this.mMeasuredScreenHeight = params.getScreenHeight();
                if (renderingMode != SessionParams.RenderingMode.NORMAL) {
                    int widthMeasureSpecMode = renderingMode.isHorizExpand() ? 0 : 0x40000000;
                    int heightMeasureSpecMode = renderingMode.isVertExpand() ? 0 : 0x40000000;
                    Pair<Integer, Integer> exactMeasure = this.measureView(this.mViewRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
                    Pair<Integer, Integer> result = this.measureView(this.mContentRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, widthMeasureSpecMode, this.mMeasuredScreenHeight, heightMeasureSpecMode);
                    if (renderingMode.isHorizExpand()) {
                        int measuredWidth = (Integer)exactMeasure.getFirst();
                        int neededWidth = (Integer)result.getFirst();
                        if (neededWidth > measuredWidth) {
                            this.mMeasuredScreenWidth += neededWidth - measuredWidth;
                        }
                    }
                    if (renderingMode.isVertExpand()) {
                        int measuredHeight = (Integer)exactMeasure.getSecond();
                        int neededHeight = (Integer)result.getSecond();
                        if (neededHeight > measuredHeight) {
                            this.mMeasuredScreenHeight += neededHeight - measuredHeight;
                        }
                    }
                }
            }
            this.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            if (params.isLayoutOnly()) {
                this.mImage = null;
                this.mCanvas = null;
            } else {
                this.mViewRoot.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
                boolean newImage = false;
                if (newRenderSize || this.mCanvas == null) {
                    if (params.getImageFactory() != null) {
                        this.mImage = params.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    } else {
                        this.mImage = new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 2);
                        newImage = true;
                    }
                    if (params.isBgColorOverridden()) {
                        newImage = true;
                        Graphics2D gc = this.mImage.createGraphics();
                        gc.setColor(new Color(params.getOverrideBgColor(), true));
                        gc.setComposite(AlphaComposite.Src);
                        gc.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                        gc.dispose();
                    }
                    Bitmap bitmap = Bitmap_Delegate.createBitmap(this.mImage, true, params.getDensity());
                    this.mCanvas = new Canvas(bitmap);
                    this.mCanvas.setDensity(params.getDensity().getDpiValue());
                }
                if (freshRender && !newImage) {
                    Graphics2D gc = this.mImage.createGraphics();
                    gc.setComposite(AlphaComposite.Src);
                    gc.setColor(new Color(0, true));
                    gc.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    gc.dispose();
                }
                this.mViewRoot.draw(this.mCanvas);
            }
            this.mViewInfoList = this.startVisitingViews(this.mViewRoot, 0, params.getExtendedViewInfoMode());
            return Result.Status.SUCCESS.createResult();
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t.getMessage(), t);
        }
    }

    private Pair<Integer, Integer> measureView(ViewGroup viewToMeasure, View measuredView, int width, int widthMode, int height, int heightMode) {
        int w_spec = View.MeasureSpec.makeMeasureSpec(width, widthMode);
        int h_spec = View.MeasureSpec.makeMeasureSpec(height, heightMode);
        viewToMeasure.measure(w_spec, h_spec);
        if (measuredView != null) {
            return Pair.of((Object)measuredView.getMeasuredWidth(), (Object)measuredView.getMeasuredHeight());
        }
        return null;
    }

    public Result insertChild(final ViewGroup parentView, ILayoutPullParser childXml, final int index, final IAnimationListener listener) {
        this.checkLock();
        BridgeContext context = this.getContext();
        BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser((XmlPullParser)childXml, context, false);
        final View child = this.mInflater.inflate(blockParser, parentView, false);
        blockParser.ensurePopped();
        this.invalidateRenderingSize();
        if (listener != null) {
            new Thread("not animated insertChild"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Result result = RenderSessionImpl.this.addView(parentView, child, index);
                    if (!result.isSuccess()) {
                        listener.done(result);
                    }
                    if (!(result = RenderSessionImpl.this.acquire(250L)).isSuccess()) {
                        listener.done(result);
                        return;
                    }
                    try {
                        result = RenderSessionImpl.this.render(false);
                        if (result.isSuccess()) {
                            listener.onNewFrame(RenderSessionImpl.this.getSession());
                        }
                    }
                    finally {
                        RenderSessionImpl.this.release();
                    }
                    listener.done(result);
                }
            }.start();
            return Result.Status.SUCCESS.createResult((Object)child);
        }
        Result result = this.addView(parentView, child, index);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (result.isSuccess()) {
            result = result.getCopyWithData((Object)child);
        }
        return result;
    }

    private Result addView(ViewGroup parent, View view, int index) {
        try {
            parent.addView(view, index);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException e) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result moveChild(final ViewGroup newParentView, final View childView, final int index, Map<String, String> layoutParamsMap, final IAnimationListener listener) {
        this.checkLock();
        this.invalidateRenderingSize();
        ViewGroup.LayoutParams layoutParams = null;
        if (layoutParamsMap != null) {
            layoutParams = newParentView.generateLayoutParams(new BridgeLayoutParamsMapAttributes(layoutParamsMap));
        }
        final ViewGroup previousParent = (ViewGroup)childView.getParent();
        if (listener != null) {
            final ViewGroup.LayoutParams params = layoutParams;
            new Thread("not animated moveChild"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Result result = RenderSessionImpl.this.moveView(previousParent, newParentView, childView, index, params);
                    if (!result.isSuccess()) {
                        listener.done(result);
                    }
                    if (!(result = RenderSessionImpl.this.acquire(250L)).isSuccess()) {
                        listener.done(result);
                        return;
                    }
                    try {
                        result = RenderSessionImpl.this.render(false);
                        if (result.isSuccess()) {
                            listener.onNewFrame(RenderSessionImpl.this.getSession());
                        }
                    }
                    finally {
                        RenderSessionImpl.this.release();
                    }
                    listener.done(result);
                }
            }.start();
            return Result.Status.SUCCESS.createResult((Object)layoutParams);
        }
        Result result = this.moveView(previousParent, newParentView, childView, index, layoutParams);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (layoutParams != null && result.isSuccess()) {
            result = result.getCopyWithData((Object)layoutParams);
        }
        return result;
    }

    private Result moveView(ViewGroup previousParent, ViewGroup newParent, View movedView, int index, ViewGroup.LayoutParams params) {
        try {
            previousParent.removeView(movedView);
            if (params != null) {
                newParent.addView(movedView, index, params);
            } else {
                newParent.addView(movedView, index);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException e) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result removeChild(final View childView, final IAnimationListener listener) {
        this.checkLock();
        this.invalidateRenderingSize();
        final ViewGroup parent = (ViewGroup)childView.getParent();
        if (listener != null) {
            new Thread("not animated moveChild"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Result result = RenderSessionImpl.this.removeView(parent, childView);
                    if (!result.isSuccess()) {
                        listener.done(result);
                    }
                    if (!(result = RenderSessionImpl.this.acquire(250L)).isSuccess()) {
                        listener.done(result);
                        return;
                    }
                    try {
                        result = RenderSessionImpl.this.render(false);
                        if (result.isSuccess()) {
                            listener.onNewFrame(RenderSessionImpl.this.getSession());
                        }
                    }
                    finally {
                        RenderSessionImpl.this.release();
                    }
                    listener.done(result);
                }
            }.start();
            return Result.Status.SUCCESS.createResult();
        }
        Result result = this.removeView(parent, childView);
        if (!result.isSuccess()) {
            return result;
        }
        return this.render(false);
    }

    private Result removeView(ViewGroup parent, View view) {
        try {
            parent.removeView(view);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException e) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    private void findBackground(RenderResources resources) {
        if (!((SessionParams)this.getParams()).isBgColorOverridden()) {
            this.mWindowBackground = resources.findItemInTheme("windowBackground");
            if (this.mWindowBackground != null) {
                this.mWindowBackground = resources.resolveResValue(this.mWindowBackground);
            }
        }
    }

    private void findStatusBar(RenderResources resources, DisplayMetrics metrics) {
        boolean windowFullscreen = this.getBooleanThemeValue(resources, "windowFullscreen", false);
        if (!windowFullscreen && !this.mWindowIsFloating) {
            TypedValue typedValue;
            this.mStatusBarSize = 25;
            ResourceValue value = resources.getFrameworkResource(ResourceType.DIMEN, "status_bar_height");
            if (value != null && (typedValue = ResourceHelper.getValue(value.getValue())) != null) {
                this.mStatusBarSize = (int)typedValue.getDimension(metrics);
            }
        }
    }

    private void findTitleBar(RenderResources resources, DisplayMetrics metrics) {
        if (this.mWindowIsFloating) {
            return;
        }
        boolean windowNoTitle = this.getBooleanThemeValue(resources, "windowNoTitle", false);
        if (!windowNoTitle) {
            TypedValue typedValue;
            this.mTitleBarSize = 25;
            ResourceValue value = resources.findItemInTheme("windowTitleSize");
            if ((value = resources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue(value.getValue())) != null) {
                this.mTitleBarSize = (int)typedValue.getDimension(metrics);
            }
        }
    }

    private boolean getBooleanThemeValue(RenderResources resources, String name, boolean defaultValue) {
        ResourceValue value = resources.findItemInTheme(name);
        if ((value = resources.resolveResValue(value)) == null || value.getValue() == null) {
            return defaultValue;
        }
        return XmlUtils.convertValueToBoolean(value.getValue(), defaultValue);
    }

    private void postInflateProcess(View view, IProjectCallback projectCallback) throws PostInflateException {
        block11: {
            block12: {
                AdapterBinding binding;
                SessionParams params;
                ResourceReference listRef;
                block13: {
                    block10: {
                        if (!(view instanceof TabHost)) break block10;
                        this.setupTabHost((TabHost)view, projectCallback);
                        break block11;
                    }
                    if (!(view instanceof AdapterView)) break block12;
                    int id2 = view.getId();
                    BridgeContext context = this.getContext();
                    listRef = context.resolveId(id2);
                    if (listRef == null) break block11;
                    params = (SessionParams)this.getParams();
                    binding = (AdapterBinding)params.getAdapterBindings().get(listRef);
                    if (binding == null) {
                        binding = params.getProjectCallback().getAdapterBinding(listRef, context.getViewKey(view), (Object)view);
                    }
                    if (binding == null) break block11;
                    if (!(view instanceof AbsListView)) break block13;
                    if ((binding.getFooterCount() > 0 || binding.getHeaderCount() > 0) && view instanceof ListView) {
                        Pair<View, Boolean> pair;
                        int i;
                        ListView list = (ListView)view;
                        boolean skipCallbackParser = false;
                        int count = binding.getHeaderCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getHeaderAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addHeaderView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                        count = binding.getFooterCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getFooterAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addFooterView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                    }
                    if (view instanceof ExpandableListView) {
                        ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(listRef, binding, params.getProjectCallback()));
                    } else {
                        ((AbsListView)view).setAdapter(new FakeAdapter(listRef, binding, params.getProjectCallback()));
                    }
                    break block11;
                }
                if (!(view instanceof AbsSpinner)) break block11;
                ((AbsSpinner)view).setAdapter(new FakeAdapter(listRef, binding, params.getProjectCallback()));
                break block11;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int c = 0; c < count; ++c) {
                    View child = group.getChildAt(c);
                    this.postInflateProcess(child, projectCallback);
                }
            }
        }
    }

    private void setupTabHost(TabHost tabHost, IProjectCallback projectCallback) throws PostInflateException {
        View v = tabHost.findViewById(16908307);
        if (v == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(v instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", v.getClass().getCanonicalName()));
        }
        v = tabHost.findViewById(0x1020011);
        if (v == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(v instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", v.getClass().getCanonicalName()));
        }
        FrameLayout content = (FrameLayout)v;
        int count = content.getChildCount();
        tabHost.setup();
        if (count == 0) {
            TabHost.TabSpec spec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569)).setContent(new TabHost.TabContentFactory(){

                public View createTabContent(String tag) {
                    return new LinearLayout(RenderSessionImpl.this.getContext());
                }
            });
            tabHost.addTab(spec);
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = content.getChildAt(i);
            String tabSpec = String.format("tab_spec%d", i + 1);
            int id2 = child.getId();
            Pair resource = projectCallback.resolveResourceId(id2);
            String name = resource != null ? (String)resource.getSecond() : String.format("Tab %d", i + 1);
            tabHost.addTab(tabHost.newTabSpec(tabSpec).setIndicator(name).setContent(id2));
        }
    }

    private List<ViewInfo> startVisitingViews(View view, int offset, boolean setExtendedInfo) {
        if (view == null) {
            return null;
        }
        offset += view.getTop();
        if (view == this.mContentRoot) {
            return this.visitAllChildren(this.mContentRoot, offset, setExtendedInfo);
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                List<ViewInfo> list = this.startVisitingViews(group.getChildAt(i), offset, setExtendedInfo);
                if (list == null) continue;
                return list;
            }
        }
        return null;
    }

    private ViewInfo visit(View view, int offset, boolean setExtendedInfo) {
        if (view == null) {
            return null;
        }
        ViewInfo result = new ViewInfo(view.getClass().getName(), this.getContext().getViewKey(view), view.getLeft(), view.getTop() + offset, view.getRight(), view.getBottom() + offset, (Object)view, (Object)view.getLayoutParams());
        if (setExtendedInfo) {
            ViewGroup.MarginLayoutParams marginParams = null;
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                marginParams = (ViewGroup.MarginLayoutParams)params;
            }
            result.setExtendedInfo(view.getBaseline(), marginParams != null ? marginParams.leftMargin : 0, marginParams != null ? marginParams.topMargin : 0, marginParams != null ? marginParams.rightMargin : 0, marginParams != null ? marginParams.bottomMargin : 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            result.setChildren(this.visitAllChildren(group, 0, setExtendedInfo));
        }
        return result;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int offset, boolean setExtendedInfo) {
        if (viewGroup == null) {
            return null;
        }
        ArrayList<ViewInfo> children = new ArrayList<ViewInfo>();
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            children.add(this.visit(viewGroup.getChildAt(i), offset, setExtendedInfo));
        }
        return children;
    }

    private void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public boolean isAlphaChannelImage() {
        return this.mIsAlphaChannelImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public Map<String, String> getDefaultProperties(Object viewObject) {
        return this.getContext().getDefaultPropMap(viewObject);
    }

    public void setScene(RenderSession session) {
        this.mScene = session;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PostInflateException(String message) {
            super(message);
        }
    }
}

