/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.util.XmlPullAttributes;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.ResourceType;
import org.xmlpull.v1.XmlPullParser;

public class BridgeXmlPullAttributes
extends XmlPullAttributes {
    private final BridgeContext mContext;
    private final boolean mPlatformFile;

    public BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, boolean platformFile) {
        super(parser);
        this.mContext = context;
        this.mPlatformFile = platformFile;
    }

    public int getAttributeNameResource(int index) {
        Integer v;
        String name = this.getAttributeName(index);
        String ns = this.mParser.getAttributeNamespace(index);
        if ("http://schemas.android.com/apk/res/android".equals(ns)) {
            Integer v2 = Bridge.getResourceId(ResourceType.ATTR, name);
            if (v2 != null) {
                return v2;
            }
            return 0;
        }
        if (this.mContext.getProjectCallback().getNamespace().equals(ns) && (v = this.mContext.getProjectCallback().getResourceId(ResourceType.ATTR, name)) != null) {
            return v;
        }
        return 0;
    }

    public int getAttributeResourceValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        return this.resolveResourceValue(value, defaultValue);
    }

    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        return this.resolveResourceValue(value, defaultValue);
    }

    private int resolveResourceValue(String value, int defaultValue) {
        RenderResources resources = this.mContext.getRenderResources();
        ResourceValue resource = resources.resolveResValue(resources.findResValue(value, this.mPlatformFile));
        if (resource != null) {
            Integer id2 = null;
            id2 = this.mPlatformFile || resource.isFramework() ? Bridge.getResourceId(resource.getResourceType(), resource.getName()) : this.mContext.getProjectCallback().getResourceId(resource.getResourceType(), resource.getName());
            if (id2 != null) {
                return id2;
            }
        }
        return defaultValue;
    }
}

