/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater_Delegate;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeResources;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class BridgeTypedArray
extends TypedArray {
    private BridgeResources mBridgeResources;
    private BridgeContext mContext;
    private ResourceValue[] mResourceData;
    private String[] mNames;
    private final boolean mPlatformFile;

    public BridgeTypedArray(BridgeResources resources, BridgeContext context, int len, boolean platformFile) {
        super(null, null, null, 0);
        this.mBridgeResources = resources;
        this.mContext = context;
        this.mPlatformFile = platformFile;
        this.mResourceData = new ResourceValue[len];
        this.mNames = new String[len];
    }

    public void bridgeSetValue(int index, String name, ResourceValue value) {
        this.mResourceData[index] = value;
        this.mNames[index] = name;
    }

    public void sealArray() {
        int count = 0;
        for (ResourceValue data : this.mResourceData) {
            if (data == null) continue;
            ++count;
        }
        this.mIndices = new int[count + 1];
        this.mIndices[0] = count;
        int index = 1;
        for (int i = 0; i < this.mResourceData.length; ++i) {
            if (this.mResourceData[i] == null) continue;
            this.mIndices[index++] = i;
        }
    }

    public int length() {
        return this.mResourceData.length;
    }

    public Resources getResources() {
        return this.mBridgeResources;
    }

    public CharSequence getText(int index) {
        if (this.mResourceData[index] != null) {
            return this.mResourceData[index].getValue();
        }
        return null;
    }

    public String getString(int index) {
        if (this.mResourceData[index] != null) {
            return this.mResourceData[index].getValue();
        }
        return null;
    }

    public boolean getBoolean(int index, boolean defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        String s = this.mResourceData[index].getValue();
        if (s != null) {
            return XmlUtils.convertValueToBoolean(s, defValue);
        }
        return defValue;
    }

    public int getInt(int index, int defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        String s = this.mResourceData[index].getValue();
        if ("@null".equals(s)) {
            return defValue;
        }
        try {
            return s == null ? defValue : XmlUtils.convertValueToInt(s, defValue);
        }
        catch (NumberFormatException e) {
            Map<String, Integer> map = Bridge.getEnumValues(this.mNames[index]);
            if (map != null) {
                String[] keywords;
                int result = 0;
                for (String keyword : keywords = s.split("\\|")) {
                    Integer i = map.get(keyword.trim());
                    if (i != null) {
                        result |= i.intValue();
                        continue;
                    }
                    Bridge.getLog().warning("resources.format", String.format("\"%s\" in attribute \"%2$s\" is not a valid value", keyword, this.mNames[index]), null);
                }
                return result;
            }
            return defValue;
        }
    }

    public float getFloat(int index, float defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        String s = this.mResourceData[index].getValue();
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                Bridge.getLog().warning("resources.format", String.format("\"%s\" in attribute \"%2$s\" cannot be converted to float.", s, this.mNames[index]), null);
            }
        }
        return defValue;
    }

    public int getColor(int index, int defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        ColorStateList colorStateList = ResourceHelper.getColorStateList(this.mResourceData[index], this.mContext);
        if (colorStateList != null) {
            return colorStateList.getDefaultColor();
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList(int index) {
        if (this.mResourceData[index] == null) {
            return null;
        }
        ResourceValue resValue = this.mResourceData[index];
        String value = resValue.getValue();
        if (value == null) {
            return null;
        }
        if ("@null".equals(value)) {
            return null;
        }
        File f = new File(value);
        if (f.isFile()) {
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((InputStream)new FileInputStream(f), "UTF-8");
            BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser((XmlPullParser)parser, this.mContext, resValue.isFramework());
            try {
                ColorStateList colorStateList = ColorStateList.createFromXml(this.mContext.getResources(), blockParser);
                blockParser.ensurePopped();
                return colorStateList;
            }
            catch (Throwable throwable) {
                try {
                    blockParser.ensurePopped();
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    Bridge.getLog().error("broken", "Failed to configure parser for " + value, (Throwable)e, null);
                    return null;
                }
                catch (Exception e) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + value, (Throwable)e, null);
                    return null;
                }
            }
        }
        try {
            int color2 = ResourceHelper.getColor(value);
            return ColorStateList.valueOf(color2);
        }
        catch (NumberFormatException e) {
            Bridge.getLog().error("resources.format", e.getMessage(), (Throwable)e, null);
            return null;
        }
    }

    public int getInteger(int index, int defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        String s = this.mResourceData[index].getValue();
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Bridge.getLog().warning("resources.format", String.format("\"%s\" in attribute \"%2$s\" cannont be converted to an integer.", s, this.mNames[index]), null);
            }
        }
        return defValue;
    }

    public float getDimension(int index, float defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        String s = this.mResourceData[index].getValue();
        if (s == null) {
            return defValue;
        }
        if (s.equals("match_parent") || s.equals("fill_parent")) {
            return -1.0f;
        }
        if (s.equals("wrap_content")) {
            return -2.0f;
        }
        if ("@null".equals(s)) {
            return defValue;
        }
        if (ResourceHelper.stringToFloat(s, this.mValue)) {
            return this.mValue.getDimension(this.mBridgeResources.mMetrics);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", s, this.mNames[index]), null);
        return defValue;
    }

    public int getDimensionPixelOffset(int index, int defValue) {
        return (int)this.getDimension(index, defValue);
    }

    public int getDimensionPixelSize(int index, int defValue) {
        try {
            return this.getDimension(index);
        }
        catch (RuntimeException e) {
            String s;
            if (this.mResourceData[index] != null && (s = this.mResourceData[index].getValue()) != null) {
                Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", s, this.mNames[index]), null);
            }
            return defValue;
        }
    }

    public int getLayoutDimension(int index, String name) {
        try {
            return this.getDimension(index);
        }
        catch (RuntimeException e) {
            if (LayoutInflater_Delegate.sIsInInclude) {
                throw new RuntimeException();
            }
            Bridge.getLog().warning("resources.format", "You must supply a " + name + " attribute.", null);
            return 0;
        }
    }

    public int getLayoutDimension(int index, int defValue) {
        return this.getDimensionPixelSize(index, defValue);
    }

    private int getDimension(int index) {
        if (this.mResourceData[index] == null) {
            throw new RuntimeException();
        }
        String s = this.mResourceData[index].getValue();
        if (s == null) {
            throw new RuntimeException();
        }
        if (s.equals("match_parent") || s.equals("fill_parent")) {
            return -1;
        }
        if (s.equals("wrap_content")) {
            return -2;
        }
        if ("@null".equals(s)) {
            throw new RuntimeException();
        }
        if (ResourceHelper.stringToFloat(s, this.mValue)) {
            float f = this.mValue.getDimension(this.mBridgeResources.mMetrics);
            int res = (int)(f + 0.5f);
            if (res != 0) {
                return res;
            }
            if (f == 0.0f) {
                return 0;
            }
            if (f > 0.0f) {
                return 1;
            }
        }
        throw new RuntimeException();
    }

    public float getFraction(int index, int base, int pbase, float defValue) {
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        String value = this.mResourceData[index].getValue();
        if (value == null) {
            return defValue;
        }
        if (ResourceHelper.stringToFloat(value, this.mValue)) {
            return this.mValue.getFraction(base, pbase);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannont be converted to a fraction.", value, this.mNames[index]), null);
        return defValue;
    }

    public int getResourceId(int index, int defValue) {
        ResourceValue resValue = this.mResourceData[index];
        if (resValue == null) {
            return defValue;
        }
        if (resValue instanceof StyleResourceValue) {
            return this.mContext.getDynamicIdByStyle((StyleResourceValue)resValue);
        }
        if ("@null".equals(resValue.getValue())) {
            return defValue;
        }
        if (resValue.getResourceType() != null) {
            if (this.mPlatformFile || resValue.isFramework()) {
                return this.mContext.getFrameworkResourceValue(resValue.getResourceType(), resValue.getName(), defValue);
            }
            return this.mContext.getProjectResourceValue(resValue.getResourceType(), resValue.getName(), defValue);
        }
        String value = resValue.getValue();
        if (value == null) {
            return defValue;
        }
        try {
            int i = Integer.parseInt(value);
            if (Integer.toString(i).equals(value)) {
                return i;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (value.startsWith("@id/") || value.startsWith("@+") || value.startsWith("@android:id/")) {
            int pos = value.indexOf(47);
            String idName = value.substring(pos + 1);
            if (this.mPlatformFile || value.startsWith("@android") || value.startsWith("@+android")) {
                return this.mContext.getFrameworkResourceValue(ResourceType.ID, idName, defValue);
            }
            return this.mContext.getProjectResourceValue(ResourceType.ID, idName, defValue);
        }
        Integer idValue = null;
        idValue = resValue.isFramework() ? Bridge.getResourceId(resValue.getResourceType(), resValue.getName()) : this.mContext.getProjectCallback().getResourceId(resValue.getResourceType(), resValue.getName());
        if (idValue != null) {
            return idValue;
        }
        Bridge.getLog().warning("resources.resolve", String.format("Unable to resolve id \"%1$s\" for attribute \"%2$s\"", value, this.mNames[index]), (Object)resValue);
        return defValue;
    }

    public Drawable getDrawable(int index) {
        if (this.mResourceData[index] == null) {
            return null;
        }
        ResourceValue value = this.mResourceData[index];
        String stringValue = value.getValue();
        if (stringValue == null || "@null".equals(stringValue)) {
            return null;
        }
        return ResourceHelper.getDrawable(value, this.mContext);
    }

    public CharSequence[] getTextArray(int index) {
        if (this.mResourceData[index] == null) {
            return null;
        }
        String value = this.mResourceData[index].getValue();
        if (value != null) {
            if ("@null".equals(value)) {
                return null;
            }
            return new CharSequence[]{value};
        }
        Bridge.getLog().warning("resources.format", String.format(String.format("Unknown value for getTextArray(%d) => %s", index, this.mResourceData[index].getName()), new Object[0]), null);
        return null;
    }

    public boolean getValue(int index, TypedValue outValue) {
        if (this.mResourceData[index] == null) {
            return false;
        }
        String s = this.mResourceData[index].getValue();
        return ResourceHelper.stringToFloat(s, outValue);
    }

    public boolean hasValue(int index) {
        return this.mResourceData[index] != null;
    }

    public TypedValue peekValue(int index) {
        if (this.getValue(index, this.mValue)) {
            return this.mValue;
        }
        return null;
    }

    public String getPositionDescription() {
        return "<internal -- stub if needed>";
    }

    public void recycle() {
    }

    public boolean getValueAt(int index, TypedValue outValue) {
        return false;
    }

    public String toString() {
        return Arrays.toString(this.mResourceData);
    }
}

