/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRenderSession
extends RenderSession {
    private final RenderSessionImpl mSession;
    private Result mLastResult;

    public Result getResult() {
        return this.mLastResult;
    }

    public BufferedImage getImage() {
        return this.mSession.getImage();
    }

    public boolean isAlphaChannelImage() {
        return this.mSession.isAlphaChannelImage();
    }

    public List<ViewInfo> getRootViews() {
        return this.mSession.getViewInfos();
    }

    public Map<String, String> getDefaultProperties(Object viewObject) {
        return this.mSession.getDefaultProperties(viewObject);
    }

    public Result getProperty(Object objectView, String propertyName) {
        return super.getProperty(objectView, propertyName);
    }

    public Result setProperty(Object objectView, String propertyName, String propertyValue) {
        return super.setProperty(objectView, propertyName, propertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result render(long timeout) {
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(timeout);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.render(false);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    public Result animate(Object targetObject, String animationName, boolean isFrameworkAnimation, IAnimationListener listener) {
        return super.animate(targetObject, animationName, isFrameworkAnimation, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result insertChild(Object parentView, ILayoutPullParser childXml, int index, IAnimationListener listener) {
        if (!(parentView instanceof ViewGroup)) {
            throw new IllegalArgumentException("parentView is not a ViewGroup");
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.insertChild((ViewGroup)parentView, childXml, index, listener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result moveChild(Object parentView, Object childView, int index, Map<String, String> layoutParams, IAnimationListener listener) {
        if (!(parentView instanceof ViewGroup)) {
            throw new IllegalArgumentException("parentView is not a ViewGroup");
        }
        if (!(childView instanceof View)) {
            throw new IllegalArgumentException("childView is not a View");
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.moveChild((ViewGroup)parentView, (View)childView, index, layoutParams, listener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result removeChild(Object childView, IAnimationListener listener) {
        if (!(childView instanceof View)) {
            throw new IllegalArgumentException("childView is not a View");
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.removeChild((View)childView, listener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    public void dispose() {
    }

    BridgeRenderSession(RenderSessionImpl scene, Result lastResult) {
        this.mSession = scene;
        if (scene != null) {
            this.mSession.setScene(this);
        }
        this.mLastResult = lastResult;
    }
}

