/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import com.android.internal.telephony.gsm.stk.StkLog;

public class ImageDescriptor {
    public int width = 0;
    public int height = 0;
    public int codingScheme = 0;
    public int imageId = 0;
    public int highOffset = 0;
    public int lowOffset = 0;
    public int length = 0;
    public static final int CODING_SCHEME_BASIC = 17;
    public static final int CODING_SCHEME_COLOUR = 33;

    public static ImageDescriptor parse(byte[] rawData, int valueIndex) {
        ImageDescriptor d = new ImageDescriptor();
        try {
            d.width = rawData[valueIndex++] & 0xFF;
            d.height = rawData[valueIndex++] & 0xFF;
            d.codingScheme = rawData[valueIndex++] & 0xFF;
            d.imageId = (rawData[valueIndex++] & 0xFF) << 8;
            d.imageId |= rawData[valueIndex++] & 0xFF;
            d.highOffset = rawData[valueIndex++] & 0xFF;
            d.lowOffset = rawData[valueIndex++] & 0xFF;
            d.length = (rawData[valueIndex++] & 0xFF) << 8 | rawData[valueIndex++] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            StkLog.d("ImageDescripter", "parse; failed parsing image descriptor");
            d = null;
        }
        return d;
    }
}

