/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.PhoneBase;
import java.util.ArrayList;

public class AdnRecordLoader
extends Handler {
    public static String LOG_TAG;
    public PhoneBase phone;
    public int ef;
    public int extensionEF;
    public int pendingExtLoads;
    public Message userResponse;
    public String pin2;
    public int recordNumber;
    public ArrayList<AdnRecord> adns;
    public Object result;
    public static final int EVENT_ADN_LOAD_DONE = 1;
    public static final int EVENT_EXT_RECORD_LOAD_DONE = 2;
    public static final int EVENT_ADN_LOAD_ALL_DONE = 3;
    public static final int EVENT_EF_LINEAR_RECORD_SIZE_DONE = 4;
    public static final int EVENT_UPDATE_RECORD_DONE = 5;

    public AdnRecordLoader(PhoneBase phone) {
        super(phone.getHandler().getLooper());
        this.phone = phone;
        LOG_TAG = phone.getPhoneName();
    }

    public void loadFromEF(int ef, int extensionEF, int recordNumber, Message response) {
        this.ef = ef;
        this.extensionEF = extensionEF;
        this.recordNumber = recordNumber;
        this.userResponse = response;
        this.phone.mIccFileHandler.loadEFLinearFixed(ef, recordNumber, this.obtainMessage(1));
    }

    public void loadAllFromEF(int ef, int extensionEF, Message response) {
        this.ef = ef;
        this.extensionEF = extensionEF;
        this.userResponse = response;
        this.phone.mIccFileHandler.loadEFLinearFixedAll(ef, this.obtainMessage(3));
    }

    public void updateEF(AdnRecord adn, int ef, int extensionEF, int recordNumber, String pin2, Message response) {
        this.ef = ef;
        this.extensionEF = extensionEF;
        this.recordNumber = recordNumber;
        this.userResponse = response;
        this.pin2 = pin2;
        this.phone.mIccFileHandler.getEFLinearRecordSize(ef, this.obtainMessage(4, adn));
    }

    public void handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    AdnRecord adn = (AdnRecord)ar.userObj;
                    if (ar.exception != null) {
                        throw new RuntimeException("get EF record size failed", ar.exception);
                    }
                    int[] recordSize = (int[])ar.result;
                    if (recordSize.length != 3 || this.recordNumber > recordSize[2]) {
                        throw new RuntimeException("get wrong EF record size format", ar.exception);
                    }
                    byte[] data = adn.buildAdnString(recordSize[0]);
                    if (data == null) {
                        throw new RuntimeException("wrong ADN format", ar.exception);
                    }
                    this.phone.mIccFileHandler.updateEFLinearFixed(this.ef, this.recordNumber, data, this.pin2, this.obtainMessage(5));
                    this.pendingExtLoads = 1;
                    break;
                }
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        throw new RuntimeException("update EF adn record failed", ar.exception);
                    }
                    this.pendingExtLoads = 0;
                    this.result = null;
                    break;
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        throw new RuntimeException("load failed", ar.exception);
                    }
                    AdnRecord adn = new AdnRecord(this.ef, this.recordNumber, data);
                    this.result = adn;
                    if (!adn.hasExtendedRecord()) break;
                    this.pendingExtLoads = 1;
                    this.phone.mIccFileHandler.loadEFLinearFixed(this.extensionEF, adn.extRecord, this.obtainMessage(2, adn));
                    break;
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    AdnRecord adn = (AdnRecord)ar.userObj;
                    if (ar.exception != null) {
                        throw new RuntimeException("load failed", ar.exception);
                    }
                    Log.d(LOG_TAG, "ADN extension EF: 0x" + Integer.toHexString(this.extensionEF) + ":" + adn.extRecord + "\n" + IccUtils.bytesToHexString(data));
                    adn.appendExtRecord(data);
                    --this.pendingExtLoads;
                    break;
                }
                case 3: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ArrayList datas = (ArrayList)ar.result;
                    if (ar.exception != null) {
                        throw new RuntimeException("load failed", ar.exception);
                    }
                    this.result = this.adns = new ArrayList(datas.size());
                    this.pendingExtLoads = 0;
                    int s = datas.size();
                    for (int i = 0; i < s; ++i) {
                        AdnRecord adn = new AdnRecord(this.ef, 1 + i, (byte[])datas.get(i));
                        this.adns.add(adn);
                        if (!adn.hasExtendedRecord()) continue;
                        ++this.pendingExtLoads;
                        this.phone.mIccFileHandler.loadEFLinearFixed(this.extensionEF, adn.extRecord, this.obtainMessage(2, adn));
                    }
                    break;
                }
            }
        }
        catch (RuntimeException exc) {
            if (this.userResponse != null) {
                AsyncResult.forMessage((Message)this.userResponse).exception = exc;
                this.userResponse.sendToTarget();
                this.userResponse = null;
            }
            return;
        }
        if (this.userResponse != null && this.pendingExtLoads == 0) {
            AsyncResult.forMessage((Message)this.userResponse).result = this.result;
            this.userResponse.sendToTarget();
            this.userResponse = null;
        }
    }
}

