/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import java.util.ArrayList;

public class ViewManager {
    public final WebView mWebView;
    public final ArrayList<ChildView> mChildren = new ArrayList();
    public boolean mHidden;
    public boolean mReadyToDraw;
    public boolean mZoomInProgress = false;
    public final int MAX_SURFACE_AREA;
    public static final int MAX_SURFACE_DIMENSION = 2048;

    public ViewManager(WebView w) {
        this.mWebView = w;
        int pixelArea = w.getResources().getDisplayMetrics().widthPixels * w.getResources().getDisplayMetrics().heightPixels;
        this.MAX_SURFACE_AREA = (int)((double)pixelArea * 2.75);
    }

    public ChildView createView() {
        return new ChildView();
    }

    public void requestLayout(ChildView v) {
        AbsoluteLayout.LayoutParams lp;
        int width = this.mWebView.contentToViewDimension(v.width);
        int height = this.mWebView.contentToViewDimension(v.height);
        int x = this.mWebView.contentToViewX(v.x);
        int y = this.mWebView.contentToViewY(v.y);
        ViewGroup.LayoutParams layoutParams = v.mView.getLayoutParams();
        if (layoutParams instanceof AbsoluteLayout.LayoutParams) {
            lp = (AbsoluteLayout.LayoutParams)layoutParams;
            lp.width = width;
            lp.height = height;
            lp.x = x;
            lp.y = y;
        } else {
            lp = new AbsoluteLayout.LayoutParams(width, height, x, y);
        }
        v.mView.setLayoutParams(lp);
        if (v.mView instanceof SurfaceView) {
            final SurfaceView sView = (SurfaceView)v.mView;
            if (sView.isFixedSize() && this.mZoomInProgress) {
                return;
            }
            int fixedW = width;
            int fixedH = height;
            if (fixedW > 2048 || fixedH > 2048) {
                if (v.width > v.height) {
                    fixedW = 2048;
                    fixedH = v.height * 2048 / v.width;
                } else {
                    fixedH = 2048;
                    fixedW = v.width * 2048 / v.height;
                }
            }
            if (fixedW * fixedH > this.MAX_SURFACE_AREA) {
                float area = this.MAX_SURFACE_AREA;
                if (v.width > v.height) {
                    fixedW = (int)Math.sqrt(area * (float)v.width / (float)v.height);
                    fixedH = v.height * fixedW / v.width;
                } else {
                    fixedH = (int)Math.sqrt(area * (float)v.height / (float)v.width);
                    fixedW = v.width * fixedH / v.height;
                }
            }
            if (fixedW != width || fixedH != height) {
                sView.getHolder().setFixedSize(fixedW, fixedH);
            } else if (!sView.isFixedSize() && this.mZoomInProgress) {
                sView.getHolder().setFixedSize(sView.getWidth(), sView.getHeight());
            } else if (sView.isFixedSize() && !this.mZoomInProgress) {
                if (sView.getVisibility() == 0) {
                    sView.setVisibility(4);
                    sView.getHolder().setSizeFromLayout();
                    this.mWebView.mPrivateHandler.post(new Runnable(){

                        public void run() {
                            sView.setVisibility(0);
                        }
                    });
                } else {
                    sView.getHolder().setSizeFromLayout();
                }
            }
        }
    }

    public void startZoom() {
        this.mZoomInProgress = true;
        for (ChildView v : this.mChildren) {
            this.requestLayout(v);
        }
    }

    public void endZoom() {
        this.mZoomInProgress = false;
        for (ChildView v : this.mChildren) {
            this.requestLayout(v);
        }
    }

    public void scaleAll() {
        for (ChildView v : this.mChildren) {
            this.requestLayout(v);
        }
    }

    public void hideAll() {
        if (this.mHidden) {
            return;
        }
        for (ChildView v : this.mChildren) {
            v.mView.setVisibility(8);
        }
        this.mHidden = true;
    }

    public void showAll() {
        if (!this.mHidden) {
            return;
        }
        for (ChildView v : this.mChildren) {
            v.mView.setVisibility(0);
        }
        this.mHidden = false;
    }

    public void postResetStateAll() {
        this.mWebView.mPrivateHandler.post(new Runnable(){

            public void run() {
                ViewManager.this.mReadyToDraw = false;
            }
        });
    }

    public void postReadyToDrawAll() {
        this.mWebView.mPrivateHandler.post(new Runnable(){

            public void run() {
                ViewManager.this.mReadyToDraw = true;
                for (ChildView v : ViewManager.this.mChildren) {
                    v.mView.setVisibility(0);
                }
            }
        });
    }

    public ChildView hitTest(int contentX, int contentY) {
        if (this.mHidden) {
            return null;
        }
        for (ChildView v : this.mChildren) {
            if (v.mView.getVisibility() != 0 || contentX < v.x || contentX >= v.x + v.width || contentY < v.y || contentY >= v.y + v.height) continue;
            return v;
        }
        return null;
    }

    public class ChildView {
        public int x;
        public int y;
        public int width;
        public int height;
        public View mView;

        public void setBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void attachView(int x, int y, int width, int height) {
            if (this.mView == null) {
                return;
            }
            this.setBounds(x, y, width, height);
            ((ViewManager)ViewManager.this).mWebView.mPrivateHandler.post(new Runnable(){

                public void run() {
                    ViewManager.this.requestLayout(ChildView.this);
                    if (ChildView.this.mView.getParent() == null) {
                        ChildView.this.attachViewOnUIThread();
                    }
                }
            });
        }

        public void attachViewOnUIThread() {
            ViewManager.this.mWebView.addView(this.mView);
            ViewManager.this.mChildren.add(this);
            if (!ViewManager.this.mReadyToDraw) {
                this.mView.setVisibility(8);
            }
        }

        public void removeView() {
            if (this.mView == null) {
                return;
            }
            ((ViewManager)ViewManager.this).mWebView.mPrivateHandler.post(new Runnable(){

                public void run() {
                    ChildView.this.removeViewOnUIThread();
                }
            });
        }

        public void removeViewOnUIThread() {
            ViewManager.this.mWebView.removeView(this.mView);
            ViewManager.this.mChildren.remove(this);
        }
    }
}

