/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class ViewStub
extends View {
    public int mLayoutResource = 0;
    public int mInflatedId;
    public WeakReference<View> mInflatedViewRef;
    public OnInflateListener mInflateListener;

    public ViewStub(Context context) {
        this.initialize(context);
    }

    public ViewStub(Context context, int layoutResource) {
        this.mLayoutResource = layoutResource;
        this.initialize(context);
    }

    public ViewStub(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewStub(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewStub, defStyle, 0);
        this.mInflatedId = a.getResourceId(1, -1);
        this.mLayoutResource = a.getResourceId(0, 0);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        this.mID = a.getResourceId(8, -1);
        a.recycle();
        this.initialize(context);
    }

    public void initialize(Context context) {
        this.mContext = context;
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    public int getInflatedId() {
        return this.mInflatedId;
    }

    public void setInflatedId(int inflatedId) {
        this.mInflatedId = inflatedId;
    }

    public int getLayoutResource() {
        return this.mLayoutResource;
    }

    public void setLayoutResource(int layoutResource) {
        this.mLayoutResource = layoutResource;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    public void draw(Canvas canvas) {
    }

    public void dispatchDraw(Canvas canvas) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setVisibility(int visibility) {
        if (this.mInflatedViewRef != null) {
            View view = (View)this.mInflatedViewRef.get();
            if (view == null) throw new IllegalStateException("setVisibility called on un-referenced view");
            view.setVisibility(visibility);
            return;
        } else {
            super.setVisibility(visibility);
            if (visibility != 0 && visibility != 4) return;
            this.inflate();
        }
    }

    public View inflate() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (this.mLayoutResource != 0) {
                ViewGroup parent = (ViewGroup)viewParent;
                LayoutInflater factory = LayoutInflater.from(this.mContext);
                View view = factory.inflate(this.mLayoutResource, parent, false);
                if (this.mInflatedId != -1) {
                    view.setId(this.mInflatedId);
                }
                int index = parent.indexOfChild(this);
                parent.removeViewInLayout(this);
                ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                if (layoutParams != null) {
                    parent.addView(view, index, layoutParams);
                } else {
                    parent.addView(view, index);
                }
                this.mInflatedViewRef = new WeakReference<View>(view);
                if (this.mInflateListener != null) {
                    this.mInflateListener.onInflate(this, view);
                }
                return view;
            }
            throw new IllegalArgumentException("ViewStub must have a valid layoutResource");
        }
        throw new IllegalStateException("ViewStub must have a non-null ViewGroup viewParent");
    }

    public void setOnInflateListener(OnInflateListener inflateListener) {
        this.mInflateListener = inflateListener;
    }

    public static interface OnInflateListener {
        public void onInflate(ViewStub var1, View var2);
    }
}

