/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;

public class ProgramStore
extends BaseObj {
    public ProgramStore(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public static class Builder {
        public RenderScript mRS;
        public Element mIn;
        public Element mOut;
        public DepthFunc mDepthFunc;
        public boolean mDepthMask;
        public boolean mColorMaskR;
        public boolean mColorMaskG;
        public boolean mColorMaskB;
        public boolean mColorMaskA;
        public BlendSrcFunc mBlendSrc;
        public BlendDstFunc mBlendDst;
        public boolean mDither;

        public Builder(RenderScript rs, Element in, Element out) {
            this.mRS = rs;
            this.mIn = in;
            this.mOut = out;
            this.mDepthFunc = DepthFunc.ALWAYS;
            this.mDepthMask = false;
            this.mColorMaskR = true;
            this.mColorMaskG = true;
            this.mColorMaskB = true;
            this.mColorMaskA = true;
            this.mBlendSrc = BlendSrcFunc.ONE;
            this.mBlendDst = BlendDstFunc.ZERO;
        }

        public void setDepthFunc(DepthFunc func) {
            this.mDepthFunc = func;
        }

        public void setDepthMask(boolean enable) {
            this.mDepthMask = enable;
        }

        public void setColorMask(boolean r, boolean g, boolean b, boolean a) {
            this.mColorMaskR = r;
            this.mColorMaskG = g;
            this.mColorMaskB = b;
            this.mColorMaskA = a;
        }

        public void setBlendFunc(BlendSrcFunc src, BlendDstFunc dst) {
            this.mBlendSrc = src;
            this.mBlendDst = dst;
        }

        public void setDitherEnable(boolean enable) {
            this.mDither = enable;
        }

        public static synchronized ProgramStore internalCreate(RenderScript rs, Builder b) {
            int inID = 0;
            int outID = 0;
            if (b.mIn != null) {
                inID = b.mIn.mID;
            }
            if (b.mOut != null) {
                outID = b.mOut.mID;
            }
            rs.nProgramFragmentStoreBegin(inID, outID);
            rs.nProgramFragmentStoreDepthFunc(b.mDepthFunc.mID);
            rs.nProgramFragmentStoreDepthMask(b.mDepthMask);
            rs.nProgramFragmentStoreColorMask(b.mColorMaskR, b.mColorMaskG, b.mColorMaskB, b.mColorMaskA);
            rs.nProgramFragmentStoreBlendFunc(b.mBlendSrc.mID, b.mBlendDst.mID);
            rs.nProgramFragmentStoreDither(b.mDither);
            int id2 = rs.nProgramFragmentStoreCreate();
            return new ProgramStore(id2, rs);
        }

        public ProgramStore create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendDstFunc {
        ZERO(0),
        ONE(1),
        SRC_COLOR(2),
        ONE_MINUS_SRC_COLOR(3),
        SRC_ALPHA(4),
        ONE_MINUS_SRC_ALPHA(5),
        DST_ALPHA(6),
        ONE_MINUS_DST_ALPHA(7);

        public int mID;

        public BlendDstFunc(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendSrcFunc {
        ZERO(0),
        ONE(1),
        DST_COLOR(2),
        ONE_MINUS_DST_COLOR(3),
        SRC_ALPHA(4),
        ONE_MINUS_SRC_ALPHA(5),
        DST_ALPHA(6),
        ONE_MINUS_DST_ALPHA(7),
        SRC_ALPHA_SATURATE(8);

        public int mID;

        public BlendSrcFunc(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DepthFunc {
        ALWAYS(0),
        LESS(1),
        LEQUAL(2),
        GREATER(3),
        GEQUAL(4),
        EQUAL(5),
        NOTEQUAL(6);

        public int mID;

        public DepthFunc(int id2) {
            this.mID = id2;
        }
    }
}

