/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.OnDependencyChangeListener;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.CharSequences;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preference
implements Comparable<Preference>,
OnDependencyChangeListener {
    public static final int DEFAULT_ORDER = Integer.MAX_VALUE;
    public Context mContext;
    public PreferenceManager mPreferenceManager;
    public long mId;
    public OnPreferenceChangeListener mOnChangeListener;
    public OnPreferenceClickListener mOnClickListener;
    public int mOrder = Integer.MAX_VALUE;
    public CharSequence mTitle;
    public CharSequence mSummary;
    public String mKey;
    public Intent mIntent;
    public boolean mEnabled = true;
    public boolean mSelectable = true;
    public boolean mRequiresKey;
    public boolean mPersistent = true;
    public String mDependencyKey;
    public Object mDefaultValue;
    public boolean mDependencyMet = true;
    public boolean mShouldDisableView = true;
    public int mLayoutResId = 17367111;
    public int mWidgetLayoutResId;
    public boolean mHasSpecifiedLayout = false;
    public OnPreferenceChangeInternalListener mListener;
    public List<Preference> mDependents;
    public boolean mBaseMethodCalled;

    public Preference(Context context, AttributeSet attrs, int defStyle) {
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Preference, defStyle, 0);
        block14: for (int i = a.getIndexCount(); i >= 0; --i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 5: {
                    this.mKey = a.getString(attr2);
                    continue block14;
                }
                case 3: {
                    this.mTitle = a.getString(attr2);
                    continue block14;
                }
                case 6: {
                    this.mSummary = a.getString(attr2);
                    continue block14;
                }
                case 7: {
                    this.mOrder = a.getInt(attr2, this.mOrder);
                    continue block14;
                }
                case 2: {
                    this.mLayoutResId = a.getResourceId(attr2, this.mLayoutResId);
                    continue block14;
                }
                case 8: {
                    this.mWidgetLayoutResId = a.getResourceId(attr2, this.mWidgetLayoutResId);
                    continue block14;
                }
                case 1: {
                    this.mEnabled = a.getBoolean(attr2, true);
                    continue block14;
                }
                case 4: {
                    this.mSelectable = a.getBoolean(attr2, true);
                    continue block14;
                }
                case 0: {
                    this.mPersistent = a.getBoolean(attr2, this.mPersistent);
                    continue block14;
                }
                case 9: {
                    this.mDependencyKey = a.getString(attr2);
                    continue block14;
                }
                case 10: {
                    this.mDefaultValue = this.onGetDefaultValue(a, attr2);
                    continue block14;
                }
                case 11: {
                    this.mShouldDisableView = a.getBoolean(attr2, this.mShouldDisableView);
                }
            }
        }
        a.recycle();
        if (!this.getClass().getName().startsWith("android.preference")) {
            this.mHasSpecifiedLayout = true;
        }
    }

    public Preference(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Preference(Context context) {
        this(context, null);
    }

    public Object onGetDefaultValue(TypedArray a, int index) {
        return null;
    }

    public void setIntent(Intent intent) {
        this.mIntent = intent;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public void setLayoutResource(int layoutResId) {
        if (layoutResId != this.mLayoutResId) {
            this.mHasSpecifiedLayout = true;
        }
        this.mLayoutResId = layoutResId;
    }

    public int getLayoutResource() {
        return this.mLayoutResId;
    }

    public void setWidgetLayoutResource(int widgetLayoutResId) {
        if (widgetLayoutResId != this.mWidgetLayoutResId) {
            this.mHasSpecifiedLayout = true;
        }
        this.mWidgetLayoutResId = widgetLayoutResId;
    }

    public int getWidgetLayoutResource() {
        return this.mWidgetLayoutResId;
    }

    public View getView(View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.onCreateView(parent);
        }
        this.onBindView(convertView);
        return convertView;
    }

    public View onCreateView(ViewGroup parent) {
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View layout2 = layoutInflater.inflate(this.mLayoutResId, parent, false);
        if (this.mWidgetLayoutResId != 0) {
            ViewGroup widgetFrame = (ViewGroup)layout2.findViewById(16908312);
            layoutInflater.inflate(this.mWidgetLayoutResId, widgetFrame);
        }
        return layout2;
    }

    public void onBindView(View view) {
        TextView textView = (TextView)view.findViewById(16908310);
        if (textView != null) {
            textView.setText(this.getTitle());
        }
        if ((textView = (TextView)view.findViewById(0x1020010)) != null) {
            CharSequence summary = this.getSummary();
            if (!TextUtils.isEmpty(summary)) {
                if (textView.getVisibility() != 0) {
                    textView.setVisibility(0);
                }
                textView.setText(this.getSummary());
            } else if (textView.getVisibility() != 8) {
                textView.setVisibility(8);
            }
        }
        if (this.mShouldDisableView) {
            this.setEnabledStateOnViews(view, this.isEnabled());
        }
    }

    public void setEnabledStateOnViews(View v, boolean enabled) {
        v.setEnabled(enabled);
        if (v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = vg.getChildCount() - 1; i >= 0; --i) {
                this.setEnabledStateOnViews(vg.getChildAt(i), enabled);
            }
        }
    }

    public void setOrder(int order) {
        if (order != this.mOrder) {
            this.mOrder = order;
            this.notifyHierarchyChanged();
        }
    }

    public int getOrder() {
        return this.mOrder;
    }

    public void setTitle(CharSequence title) {
        if (title == null && this.mTitle != null || title != null && !title.equals(this.mTitle)) {
            this.mTitle = title;
            this.notifyChanged();
        }
    }

    public void setTitle(int titleResId) {
        this.setTitle(this.mContext.getString(titleResId));
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public void setSummary(CharSequence summary) {
        if (summary == null && this.mSummary != null || summary != null && !summary.equals(this.mSummary)) {
            this.mSummary = summary;
            this.notifyChanged();
        }
    }

    public void setSummary(int summaryResId) {
        this.setSummary(this.mContext.getString(summaryResId));
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public boolean isEnabled() {
        return this.mEnabled && this.mDependencyMet;
    }

    public void setSelectable(boolean selectable) {
        if (this.mSelectable != selectable) {
            this.mSelectable = selectable;
            this.notifyChanged();
        }
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    public void setShouldDisableView(boolean shouldDisableView) {
        this.mShouldDisableView = shouldDisableView;
        this.notifyChanged();
    }

    public boolean getShouldDisableView() {
        return this.mShouldDisableView;
    }

    public long getId() {
        return this.mId;
    }

    public void onClick() {
    }

    public void setKey(String key) {
        this.mKey = key;
        if (this.mRequiresKey && !this.hasKey()) {
            this.requireKey();
        }
    }

    public String getKey() {
        return this.mKey;
    }

    public void requireKey() {
        if (this.mKey == null) {
            throw new IllegalStateException("Preference does not have a key assigned.");
        }
        this.mRequiresKey = true;
    }

    public boolean hasKey() {
        return !TextUtils.isEmpty(this.mKey);
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public boolean shouldPersist() {
        return this.mPreferenceManager != null && this.isPersistent() && this.hasKey();
    }

    public void setPersistent(boolean persistent) {
        this.mPersistent = persistent;
    }

    public boolean callChangeListener(Object newValue) {
        return this.mOnChangeListener == null ? true : this.mOnChangeListener.onPreferenceChange(this, newValue);
    }

    public void setOnPreferenceChangeListener(OnPreferenceChangeListener onPreferenceChangeListener) {
        this.mOnChangeListener = onPreferenceChangeListener;
    }

    public OnPreferenceChangeListener getOnPreferenceChangeListener() {
        return this.mOnChangeListener;
    }

    public void setOnPreferenceClickListener(OnPreferenceClickListener onPreferenceClickListener) {
        this.mOnClickListener = onPreferenceClickListener;
    }

    public OnPreferenceClickListener getOnPreferenceClickListener() {
        return this.mOnClickListener;
    }

    public void performClick(PreferenceScreen preferenceScreen) {
        if (!this.isEnabled()) {
            return;
        }
        this.onClick();
        if (this.mOnClickListener != null && this.mOnClickListener.onPreferenceClick(this)) {
            return;
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        if (preferenceManager != null) {
            PreferenceManager.OnPreferenceTreeClickListener listener = preferenceManager.getOnPreferenceTreeClickListener();
            if (preferenceScreen != null && listener != null && listener.onPreferenceTreeClick(preferenceScreen, this)) {
                return;
            }
        }
        if (this.mIntent != null) {
            Context context = this.getContext();
            context.startActivity(this.mIntent);
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.getSharedPreferences();
    }

    public SharedPreferences.Editor getEditor() {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.getEditor();
    }

    public boolean shouldCommit() {
        if (this.mPreferenceManager == null) {
            return false;
        }
        return this.mPreferenceManager.shouldCommit();
    }

    @Override
    public int compareTo(Preference another) {
        if (this.mOrder != Integer.MAX_VALUE || this.mOrder == Integer.MAX_VALUE && another.mOrder != Integer.MAX_VALUE) {
            return this.mOrder - another.mOrder;
        }
        if (this.mTitle == null) {
            return 1;
        }
        if (another.mTitle == null) {
            return -1;
        }
        return CharSequences.compareToIgnoreCase(this.mTitle, another.mTitle);
    }

    public void setOnPreferenceChangeInternalListener(OnPreferenceChangeInternalListener listener) {
        this.mListener = listener;
    }

    public void notifyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceChange(this);
        }
    }

    public void notifyHierarchyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceHierarchyChange(this);
        }
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.mId = preferenceManager.getNextId();
        this.dispatchSetInitialValue();
    }

    public void onAttachedToActivity() {
        this.registerDependency();
    }

    public void registerDependency() {
        if (TextUtils.isEmpty(this.mDependencyKey)) {
            return;
        }
        Preference preference = this.findPreferenceInHierarchy(this.mDependencyKey);
        if (preference == null) {
            throw new IllegalStateException("Dependency \"" + this.mDependencyKey + "\" not found for preference \"" + this.mKey + "\" (title: \"" + this.mTitle + "\"");
        }
        preference.registerDependent(this);
    }

    public void unregisterDependency() {
        Preference oldDependency;
        if (this.mDependencyKey != null && (oldDependency = this.findPreferenceInHierarchy(this.mDependencyKey)) != null) {
            oldDependency.unregisterDependent(this);
        }
    }

    public Preference findPreferenceInHierarchy(String key) {
        if (TextUtils.isEmpty(key) || this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    public void registerDependent(Preference dependent) {
        if (this.mDependents == null) {
            this.mDependents = new ArrayList<Preference>();
        }
        this.mDependents.add(dependent);
        dependent.onDependencyChanged(this, this.shouldDisableDependents());
    }

    public void unregisterDependent(Preference dependent) {
        if (this.mDependents != null) {
            this.mDependents.remove(dependent);
        }
    }

    public void notifyDependencyChange(boolean disableDependents) {
        List<Preference> dependents = this.mDependents;
        if (dependents == null) {
            return;
        }
        int dependentsCount = dependents.size();
        for (int i = 0; i < dependentsCount; ++i) {
            dependents.get(i).onDependencyChanged(this, disableDependents);
        }
    }

    @Override
    public void onDependencyChanged(Preference dependency, boolean disableDependent) {
        if (this.mDependencyMet == disableDependent) {
            this.mDependencyMet = !disableDependent;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public boolean shouldDisableDependents() {
        return !this.isEnabled();
    }

    public void setDependency(String dependencyKey) {
        this.unregisterDependency();
        this.mDependencyKey = dependencyKey;
        this.registerDependency();
    }

    public String getDependency() {
        return this.mDependencyKey;
    }

    public void onPrepareForRemoval() {
        this.unregisterDependency();
    }

    public void setDefaultValue(Object defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    public void dispatchSetInitialValue() {
        boolean shouldPersist = this.shouldPersist();
        if (!shouldPersist || !this.getSharedPreferences().contains(this.mKey)) {
            if (this.mDefaultValue != null) {
                this.onSetInitialValue(false, this.mDefaultValue);
            }
        } else {
            this.onSetInitialValue(true, null);
        }
    }

    public void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
    }

    public void tryCommit(SharedPreferences.Editor editor) {
        if (this.mPreferenceManager.shouldCommit()) {
            try {
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
        }
    }

    public boolean persistString(String value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedString(null)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putString(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    public String getPersistedString(String defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getString(this.mKey, defaultReturnValue);
    }

    public boolean persistInt(int value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedInt(~value)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putInt(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    public int getPersistedInt(int defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getInt(this.mKey, defaultReturnValue);
    }

    public boolean persistFloat(float value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedFloat(Float.NaN)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putFloat(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    public float getPersistedFloat(float defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getFloat(this.mKey, defaultReturnValue);
    }

    public boolean persistLong(long value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedLong(value ^ 0xFFFFFFFFFFFFFFFFL)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putLong(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    public long getPersistedLong(long defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getLong(this.mKey, defaultReturnValue);
    }

    public boolean persistBoolean(boolean value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedBoolean(!value)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putBoolean(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    public boolean getPersistedBoolean(boolean defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getBoolean(this.mKey, defaultReturnValue);
    }

    public boolean hasSpecifiedLayout() {
        return this.mHasSpecifiedLayout;
    }

    public String toString() {
        return this.getFilterableStringBuilder().toString();
    }

    public StringBuilder getFilterableStringBuilder() {
        CharSequence summary;
        StringBuilder sb = new StringBuilder();
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty(title)) {
            sb.append(title).append(' ');
        }
        if (!TextUtils.isEmpty(summary = this.getSummary())) {
            sb.append(summary).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    public void saveHierarchyState(Bundle container) {
        this.dispatchSaveInstanceState(container);
    }

    public void dispatchSaveInstanceState(Bundle container) {
        if (this.hasKey()) {
            this.mBaseMethodCalled = false;
            Parcelable state = this.onSaveInstanceState();
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.putParcelable(this.mKey, state);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        this.mBaseMethodCalled = true;
        return BaseSavedState.EMPTY_STATE;
    }

    public void restoreHierarchyState(Bundle container) {
        this.dispatchRestoreInstanceState(container);
    }

    public void dispatchRestoreInstanceState(Bundle container) {
        Object state;
        if (this.hasKey() && (state = container.getParcelable(this.mKey)) != null) {
            this.mBaseMethodCalled = false;
            this.onRestoreInstanceState((Parcelable)state);
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        this.mBaseMethodCalled = true;
        if (state != BaseSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class -- expecting Preference State");
        }
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            @Override
            public BaseSavedState createFromParcel(Parcel in) {
                return new BaseSavedState(in);
            }

            public BaseSavedState[] newArray(int size) {
                return new BaseSavedState[size];
            }
        };

        public BaseSavedState(Parcel source) {
            super(source);
        }

        public BaseSavedState(Parcelable superState) {
            super(superState);
        }
    }

    public static interface OnPreferenceChangeInternalListener {
        public void onPreferenceChange(Preference var1);

        public void onPreferenceHierarchyChange(Preference var1);
    }

    public static interface OnPreferenceClickListener {
        public boolean onPreferenceClick(Preference var1);
    }

    public static interface OnPreferenceChangeListener {
        public boolean onPreferenceChange(Preference var1, Object var2);
    }
}

