/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.BitSet;

public class WifiConfiguration
implements Parcelable {
    public static final String ssidVarName = "ssid";
    public static final String bssidVarName = "bssid";
    public static final String pskVarName = "psk";
    public static final String[] wepKeyVarNames = new String[]{"wep_key0", "wep_key1", "wep_key2", "wep_key3"};
    public static final String wepTxKeyIdxVarName = "wep_tx_keyidx";
    public static final String priorityVarName = "priority";
    public static final String hiddenSSIDVarName = "scan_ssid";
    public EnterpriseField eap = new EnterpriseField("eap", null);
    public EnterpriseField phase2 = new EnterpriseField("phase2", null);
    public EnterpriseField identity = new EnterpriseField("identity", null);
    public EnterpriseField anonymous_identity = new EnterpriseField("anonymous_identity", null);
    public EnterpriseField password = new EnterpriseField("password", null);
    public EnterpriseField client_cert = new EnterpriseField("client_cert", null);
    public EnterpriseField private_key = new EnterpriseField("private_key", null);
    public EnterpriseField ca_cert = new EnterpriseField("ca_cert", null);
    public EnterpriseField[] enterpriseFields = new EnterpriseField[]{this.eap, this.phase2, this.identity, this.anonymous_identity, this.password, this.client_cert, this.private_key, this.ca_cert};
    public int networkId = -1;
    public int status;
    public String SSID = null;
    public String BSSID = null;
    public String preSharedKey;
    public String[] wepKeys;
    public int wepTxKeyIndex;
    public int priority = 0;
    public boolean hiddenSSID = false;
    public BitSet allowedKeyManagement = new BitSet();
    public BitSet allowedProtocols = new BitSet();
    public BitSet allowedAuthAlgorithms = new BitSet();
    public BitSet allowedPairwiseCiphers = new BitSet();
    public BitSet allowedGroupCiphers = new BitSet();
    public static final Parcelable.Creator<WifiConfiguration> CREATOR = new Parcelable.Creator<WifiConfiguration>(){

        @Override
        public WifiConfiguration createFromParcel(Parcel in) {
            WifiConfiguration config = new WifiConfiguration();
            config.networkId = in.readInt();
            config.status = in.readInt();
            config.SSID = in.readString();
            config.BSSID = in.readString();
            config.preSharedKey = in.readString();
            for (int i = 0; i < config.wepKeys.length; ++i) {
                config.wepKeys[i] = in.readString();
            }
            config.wepTxKeyIndex = in.readInt();
            config.priority = in.readInt();
            config.hiddenSSID = in.readInt() != 0;
            config.allowedKeyManagement = WifiConfiguration.readBitSet(in);
            config.allowedProtocols = WifiConfiguration.readBitSet(in);
            config.allowedAuthAlgorithms = WifiConfiguration.readBitSet(in);
            config.allowedPairwiseCiphers = WifiConfiguration.readBitSet(in);
            config.allowedGroupCiphers = WifiConfiguration.readBitSet(in);
            for (EnterpriseField field : config.enterpriseFields) {
                field.setValue(in.readString());
            }
            return config;
        }

        public WifiConfiguration[] newArray(int size) {
            return new WifiConfiguration[size];
        }
    };

    public WifiConfiguration() {
        this.wepKeys = new String[4];
        for (int i = 0; i < this.wepKeys.length; ++i) {
            this.wepKeys[i] = null;
        }
        for (EnterpriseField field : this.enterpriseFields) {
            field.setValue(null);
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.status == 0) {
            sbuf.append("* ");
        } else if (this.status == 1) {
            sbuf.append("- ");
        }
        sbuf.append("ID: ").append(this.networkId).append(" SSID: ").append(this.SSID).append(" BSSID: ").append(this.BSSID).append(" PRIO: ").append(this.priority).append('\n');
        sbuf.append(" KeyMgmt:");
        for (int k = 0; k < this.allowedKeyManagement.size(); ++k) {
            if (!this.allowedKeyManagement.get(k)) continue;
            sbuf.append(" ");
            if (k < KeyMgmt.strings.length) {
                sbuf.append(KeyMgmt.strings[k]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append(" Protocols:");
        for (int p = 0; p < this.allowedProtocols.size(); ++p) {
            if (!this.allowedProtocols.get(p)) continue;
            sbuf.append(" ");
            if (p < Protocol.strings.length) {
                sbuf.append(Protocol.strings[p]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" AuthAlgorithms:");
        for (int a = 0; a < this.allowedAuthAlgorithms.size(); ++a) {
            if (!this.allowedAuthAlgorithms.get(a)) continue;
            sbuf.append(" ");
            if (a < AuthAlgorithm.strings.length) {
                sbuf.append(AuthAlgorithm.strings[a]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" PairwiseCiphers:");
        for (int pc = 0; pc < this.allowedPairwiseCiphers.size(); ++pc) {
            if (!this.allowedPairwiseCiphers.get(pc)) continue;
            sbuf.append(" ");
            if (pc < PairwiseCipher.strings.length) {
                sbuf.append(PairwiseCipher.strings[pc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupCiphers:");
        for (int gc = 0; gc < this.allowedGroupCiphers.size(); ++gc) {
            if (!this.allowedGroupCiphers.get(gc)) continue;
            sbuf.append(" ");
            if (gc < GroupCipher.strings.length) {
                sbuf.append(GroupCipher.strings[gc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n').append(" PSK: ");
        if (this.preSharedKey != null) {
            sbuf.append('*');
        }
        for (EnterpriseField field : this.enterpriseFields) {
            sbuf.append('\n').append(" " + field.varName() + ": ");
            String value = field.value();
            if (value == null) continue;
            sbuf.append(value);
        }
        sbuf.append('\n');
        return sbuf.toString();
    }

    public static BitSet readBitSet(Parcel src) {
        int cardinality = src.readInt();
        BitSet set = new BitSet();
        for (int i = 0; i < cardinality; ++i) {
            set.set(src.readInt());
        }
        return set;
    }

    public static void writeBitSet(Parcel dest, BitSet set) {
        int nextSetBit = -1;
        dest.writeInt(set.cardinality());
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            dest.writeInt(nextSetBit);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.networkId);
        dest.writeInt(this.status);
        dest.writeString(this.SSID);
        dest.writeString(this.BSSID);
        dest.writeString(this.preSharedKey);
        for (String wepKey : this.wepKeys) {
            dest.writeString(wepKey);
        }
        dest.writeInt(this.wepTxKeyIndex);
        dest.writeInt(this.priority);
        dest.writeInt(this.hiddenSSID ? 1 : 0);
        WifiConfiguration.writeBitSet(dest, this.allowedKeyManagement);
        WifiConfiguration.writeBitSet(dest, this.allowedProtocols);
        WifiConfiguration.writeBitSet(dest, this.allowedAuthAlgorithms);
        WifiConfiguration.writeBitSet(dest, this.allowedPairwiseCiphers);
        WifiConfiguration.writeBitSet(dest, this.allowedGroupCiphers);
        for (EnterpriseField field : this.enterpriseFields) {
            dest.writeString(field.value());
        }
    }

    public static class Status {
        public static final int CURRENT = 0;
        public static final int DISABLED = 1;
        public static final int ENABLED = 2;
        public static final String[] strings = new String[]{"current", "disabled", "enabled"};
    }

    public static class GroupCipher {
        public static final int WEP40 = 0;
        public static final int WEP104 = 1;
        public static final int TKIP = 2;
        public static final int CCMP = 3;
        public static final String varName = "group";
        public static final String[] strings = new String[]{"WEP40", "WEP104", "TKIP", "CCMP"};
    }

    public static class PairwiseCipher {
        public static final int NONE = 0;
        public static final int TKIP = 1;
        public static final int CCMP = 2;
        public static final String varName = "pairwise";
        public static final String[] strings = new String[]{"NONE", "TKIP", "CCMP"};
    }

    public static class AuthAlgorithm {
        public static final int OPEN = 0;
        public static final int SHARED = 1;
        public static final int LEAP = 2;
        public static final String varName = "auth_alg";
        public static final String[] strings = new String[]{"OPEN", "SHARED", "LEAP"};
    }

    public static class Protocol {
        public static final int WPA = 0;
        public static final int RSN = 1;
        public static final String varName = "proto";
        public static final String[] strings = new String[]{"WPA", "RSN"};
    }

    public static class KeyMgmt {
        public static final int NONE = 0;
        public static final int WPA_PSK = 1;
        public static final int WPA_EAP = 2;
        public static final int IEEE8021X = 3;
        public static final String varName = "key_mgmt";
        public static final String[] strings = new String[]{"NONE", "WPA_PSK", "WPA_EAP", "IEEE8021X"};
    }

    public class EnterpriseField {
        public String varName;
        public String value;

        public EnterpriseField(String varName) {
            this.varName = varName;
            this.value = null;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String varName() {
            return this.varName;
        }

        public String value() {
            return this.value;
        }

        public /* synthetic */ EnterpriseField(String x1, 1 x2) {
            this(x1);
        }
    }
}

