/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;

public class SQLiteDirectCursorDriver
implements SQLiteCursorDriver {
    public String mEditTable;
    public SQLiteDatabase mDatabase;
    public Cursor mCursor;
    public String mSql;
    public SQLiteQuery mQuery;

    public SQLiteDirectCursorDriver(SQLiteDatabase db, String sql, String editTable) {
        this.mDatabase = db;
        this.mEditTable = editTable;
        this.mSql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor query(SQLiteDatabase.CursorFactory factory, String[] selectionArgs) {
        SQLiteQuery query = new SQLiteQuery(this.mDatabase, this.mSql, 0, selectionArgs);
        try {
            int numArgs = selectionArgs == null ? 0 : selectionArgs.length;
            for (int i = 0; i < numArgs; ++i) {
                query.bindString(i + 1, selectionArgs[i]);
            }
            this.mCursor = factory == null ? new SQLiteCursor(this.mDatabase, this, this.mEditTable, query) : factory.newCursor(this.mDatabase, this, this.mEditTable, query);
            this.mQuery = query;
            query = null;
            Cursor cursor = this.mCursor;
            return cursor;
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    public void cursorClosed() {
        this.mCursor = null;
    }

    public void setBindArguments(String[] bindArgs) {
        int numArgs = bindArgs.length;
        for (int i = 0; i < numArgs; ++i) {
            this.mQuery.bindString(i + 1, bindArgs[i]);
        }
    }

    public void cursorDeactivated() {
    }

    public void cursorRequeried(Cursor cursor) {
    }

    public String toString() {
        return "SQLiteDirectCursorDriver: " + this.mSql;
    }
}

