/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public class RenameClassAdapter
extends ClassAdapter {
    private final String mOldName;
    private final String mNewName;
    private String mOldBase;
    private String mNewBase;

    public RenameClassAdapter(ClassWriter cv, String oldName, String newName) {
        super(cv);
        this.mOldBase = this.mOldName = oldName;
        this.mNewBase = this.mNewName = newName;
        int pos = this.mOldName.indexOf(36);
        if (pos > 0) {
            this.mOldBase = this.mOldName.substring(0, pos);
        }
        if ((pos = this.mNewName.indexOf(36)) > 0) {
            this.mNewBase = this.mNewName.substring(0, pos);
        }
        assert (this.mOldBase == null && this.mNewBase == null || this.mOldBase != null && this.mNewBase != null);
    }

    String renameTypeDesc(String desc) {
        if (desc == null) {
            return null;
        }
        return this.renameType(Type.getType(desc));
    }

    String renameType(Type type) {
        if (type == null) {
            return null;
        }
        if (type.getSort() == 10) {
            String in = type.getInternalName();
            return "L" + this.renameInternalType(in) + ";";
        }
        if (type.getSort() == 9) {
            StringBuilder sb = new StringBuilder();
            for (int n = type.getDimensions(); n > 0; --n) {
                sb.append('[');
            }
            sb.append(this.renameType(type.getElementType()));
            return sb.toString();
        }
        return type.getDescriptor();
    }

    Type renameTypeAsType(Type type) {
        if (type == null) {
            return null;
        }
        if (type.getSort() == 10) {
            String in = type.getInternalName();
            String newIn = this.renameInternalType(in);
            if (newIn != in) {
                return Type.getType("L" + newIn + ";");
            }
        } else if (type.getSort() == 9) {
            StringBuilder sb = new StringBuilder();
            for (int n = type.getDimensions(); n > 0; --n) {
                sb.append('[');
            }
            sb.append(this.renameType(type.getElementType()));
            return Type.getType(sb.toString());
        }
        return type;
    }

    String renameInternalType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(this.mOldName)) {
            return this.mNewName;
        }
        if (this.mOldBase != this.mOldName && type.equals(this.mOldBase)) {
            return this.mNewBase;
        }
        int pos = type.indexOf(36);
        if (pos == this.mOldBase.length() && type.startsWith(this.mOldBase)) {
            return this.mNewBase + type.substring(pos);
        }
        if (type.indexOf(59) > 0) {
            type = this.renameTypeDesc(type);
        }
        return type;
    }

    String renameMethodDesc(String desc) {
        if (desc == null) {
            return null;
        }
        Type[] args = Type.getArgumentTypes(desc);
        StringBuilder sb = new StringBuilder("(");
        for (Type arg : args) {
            String name = this.renameType(arg);
            sb.append(name);
        }
        sb.append(')');
        Type ret = Type.getReturnType(desc);
        String name = this.renameType(ret);
        sb.append(name);
        return sb.toString();
    }

    String renameTypeSignature(String sig) {
        if (sig == null) {
            return null;
        }
        SignatureReader reader = new SignatureReader(sig);
        SignatureWriter writer = new SignatureWriter();
        reader.accept(new RenameSignatureAdapter(writer));
        sig = writer.toString();
        return sig;
    }

    String renameFieldSignature(String sig) {
        if (sig == null) {
            return null;
        }
        SignatureReader reader = new SignatureReader(sig);
        SignatureWriter writer = new SignatureWriter();
        reader.acceptType(new RenameSignatureAdapter(writer));
        sig = writer.toString();
        return sig;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        name = this.renameInternalType(name);
        superName = this.renameInternalType(superName);
        signature = this.renameTypeSignature(signature);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        assert (outerName.equals(this.mOldName));
        outerName = this.renameInternalType(outerName);
        name = outerName + "$" + innerName;
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        desc = this.renameMethodDesc(desc);
        signature = this.renameTypeSignature(signature);
        MethodVisitor mw = super.visitMethod(access, name, desc, signature, exceptions);
        return new RenameMethodAdapter(mw);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        desc = this.renameTypeDesc(desc);
        return super.visitAnnotation(desc, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        desc = this.renameTypeDesc(desc);
        signature = this.renameFieldSignature(signature);
        return super.visitField(access, name, desc, signature, value);
    }

    public class RenameSignatureAdapter
    implements SignatureVisitor {
        private final SignatureVisitor mSv;

        public RenameSignatureAdapter(SignatureVisitor sv) {
            this.mSv = sv;
        }

        public void visitClassType(String name) {
            name = RenameClassAdapter.this.renameInternalType(name);
            this.mSv.visitClassType(name);
        }

        public void visitInnerClassType(String name) {
            name = RenameClassAdapter.this.renameInternalType(name);
            this.mSv.visitInnerClassType(name);
        }

        public SignatureVisitor visitArrayType() {
            SignatureVisitor sv = this.mSv.visitArrayType();
            return new RenameSignatureAdapter(sv);
        }

        public void visitBaseType(char descriptor) {
            this.mSv.visitBaseType(descriptor);
        }

        public SignatureVisitor visitClassBound() {
            SignatureVisitor sv = this.mSv.visitClassBound();
            return new RenameSignatureAdapter(sv);
        }

        public void visitEnd() {
            this.mSv.visitEnd();
        }

        public SignatureVisitor visitExceptionType() {
            SignatureVisitor sv = this.mSv.visitExceptionType();
            return new RenameSignatureAdapter(sv);
        }

        public void visitFormalTypeParameter(String name) {
            this.mSv.visitFormalTypeParameter(name);
        }

        public SignatureVisitor visitInterface() {
            SignatureVisitor sv = this.mSv.visitInterface();
            return new RenameSignatureAdapter(sv);
        }

        public SignatureVisitor visitInterfaceBound() {
            SignatureVisitor sv = this.mSv.visitInterfaceBound();
            return new RenameSignatureAdapter(sv);
        }

        public SignatureVisitor visitParameterType() {
            SignatureVisitor sv = this.mSv.visitParameterType();
            return new RenameSignatureAdapter(sv);
        }

        public SignatureVisitor visitReturnType() {
            SignatureVisitor sv = this.mSv.visitReturnType();
            return new RenameSignatureAdapter(sv);
        }

        public SignatureVisitor visitSuperclass() {
            SignatureVisitor sv = this.mSv.visitSuperclass();
            return new RenameSignatureAdapter(sv);
        }

        public void visitTypeArgument() {
            this.mSv.visitTypeArgument();
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            SignatureVisitor sv = this.mSv.visitTypeArgument(wildcard);
            return new RenameSignatureAdapter(sv);
        }

        public void visitTypeVariable(String name) {
            this.mSv.visitTypeVariable(name);
        }
    }

    public class RenameMethodAdapter
    extends MethodAdapter {
        public RenameMethodAdapter(MethodVisitor mv) {
            super(mv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            desc = RenameClassAdapter.this.renameTypeDesc(desc);
            return super.visitAnnotation(desc, visible);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            desc = RenameClassAdapter.this.renameTypeDesc(desc);
            return super.visitParameterAnnotation(parameter, desc, visible);
        }

        public void visitTypeInsn(int opcode, String type) {
            type = RenameClassAdapter.this.renameInternalType(type);
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            owner = RenameClassAdapter.this.renameInternalType(owner);
            desc = RenameClassAdapter.this.renameTypeDesc(desc);
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            owner = RenameClassAdapter.this.renameInternalType(owner);
            desc = RenameClassAdapter.this.renameMethodDesc(desc);
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                cst = RenameClassAdapter.this.renameTypeAsType((Type)cst);
            }
            super.visitLdcInsn(cst);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            desc = RenameClassAdapter.this.renameTypeDesc(desc);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            type = RenameClassAdapter.this.renameInternalType(type);
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            desc = RenameClassAdapter.this.renameTypeDesc(desc);
            signature = RenameClassAdapter.this.renameFieldSignature(signature);
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }
}

