/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.Log;
import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class DelegateMethodAdapter
implements MethodVisitor {
    public static final String DELEGATE_SUFFIX = "_Delegate";
    private static String CONSTRUCTOR = "<init>";
    private static String CLASS_INIT = "<clinit>";
    private MethodVisitor mParentVisitor;
    private boolean mOutputFirstLineNumber = true;
    private String mDesc;
    private final boolean mIsStatic;
    private final String mClassName;
    private final String mMethodName;
    private final Log mLog;
    private boolean mVisitCodeCalled;

    public DelegateMethodAdapter(Log log, MethodVisitor mv, String className, String methodName, String desc, boolean isStatic) {
        this.mLog = log;
        this.mParentVisitor = mv;
        this.mClassName = className;
        this.mMethodName = methodName;
        this.mDesc = desc;
        this.mIsStatic = isStatic;
        if (CONSTRUCTOR.equals(methodName) || CLASS_INIT.equals(methodName)) {
            throw new UnsupportedOperationException(String.format("Delegate doesn't support overriding constructor %1$s:%2$s(%3$s)", className, methodName, desc));
        }
    }

    public void generateCode() {
        AnnotationVisitor aw = this.mParentVisitor.visitAnnotation(Type.getObjectType(Type.getInternalName(LayoutlibDelegate.class)).toString(), true);
        aw.visitEnd();
        if (!this.mVisitCodeCalled) {
            this.mParentVisitor.visitCode();
            this.mVisitCodeCalled = true;
        }
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        String delegateClassName = this.mClassName + DELEGATE_SUFFIX;
        boolean pushedArg0 = false;
        int maxStack = 0;
        if (!this.mIsStatic) {
            int slash = this.mClassName.lastIndexOf(47);
            int dol = this.mClassName.lastIndexOf(36);
            if (dol != -1 && dol > slash && dol == this.mClassName.indexOf(36)) {
                String outerClass = this.mClassName.substring(0, dol);
                Type outerType = Type.getObjectType(outerClass);
                delegateClassName = delegateClassName.replace('$', '_');
                this.mParentVisitor.visitVarInsn(25, 0);
                this.mParentVisitor.visitFieldInsn(180, this.mClassName, "this$0", outerType.getDescriptor());
                ++maxStack;
                paramTypes.add(outerType);
            }
            this.mParentVisitor.visitVarInsn(25, 0);
            ++maxStack;
            pushedArg0 = true;
            paramTypes.add(Type.getObjectType(this.mClassName));
        }
        Type[] argTypes = Type.getArgumentTypes(this.mDesc);
        int maxLocals = pushedArg0 ? 1 : 0;
        for (Type t : argTypes) {
            int size = t.getSize();
            this.mParentVisitor.visitVarInsn(t.getOpcode(21), maxLocals);
            maxLocals += size;
            maxStack += size;
            paramTypes.add(t);
        }
        String desc = Type.getMethodDescriptor(Type.getReturnType(this.mDesc), paramTypes.toArray(new Type[paramTypes.size()]));
        this.mParentVisitor.visitMethodInsn(184, delegateClassName, this.mMethodName, desc);
        Type returnType = Type.getReturnType(this.mDesc);
        this.mParentVisitor.visitInsn(returnType.getOpcode(172));
        this.mParentVisitor.visitMaxs(maxStack, maxLocals);
        this.mParentVisitor.visitEnd();
        this.mLog.debug("Delegate: %1$s # %2$s %3$s", delegateClassName, this.mMethodName, desc);
    }

    public void visitCode() {
        this.mVisitCodeCalled = true;
        this.mParentVisitor.visitCode();
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitEnd() {
        this.generateCode();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.mParentVisitor.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.mParentVisitor.visitAnnotationDefault();
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return this.mParentVisitor.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        this.mParentVisitor.visitAttribute(attr);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.mOutputFirstLineNumber) {
            this.mParentVisitor.visitLineNumber(line, start);
            this.mOutputFirstLineNumber = false;
        }
    }

    public void visitInsn(int opcode) {
    }

    public void visitLabel(Label label) {
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public void visitIincInsn(int var, int increment) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    public void visitJumpInsn(int opcode, Label label) {
    }

    public void visitLdcInsn(Object cst) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
    }

    public void visitTypeInsn(int opcode, String type) {
    }

    public void visitVarInsn(int opcode, int var) {
    }
}

