/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import com.android.tools.layoutlib.create.DelegateMethodAdapter;
import com.android.tools.layoutlib.create.Log;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateClassAdapter
extends ClassAdapter {
    public static final String ALL_NATIVES = "<<all_natives>>";
    private final String mClassName;
    private final Set<String> mDelegateMethods;
    private final Log mLog;

    public DelegateClassAdapter(Log log, ClassVisitor cv, String className, Set<String> delegateMethods) {
        super(cv);
        this.mLog = log;
        this.mClassName = className;
        this.mDelegateMethods = delegateMethods;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean useDelegate;
        boolean isStatic = (access & 8) != 0;
        boolean isNative = (access & 0x100) != 0;
        boolean bl = useDelegate = isNative && this.mDelegateMethods.contains(ALL_NATIVES) || this.mDelegateMethods.contains(name);
        if (useDelegate) {
            access &= 0xFFFFFEFF;
        }
        MethodVisitor mw = super.visitMethod(access, name, desc, signature, exceptions);
        if (useDelegate) {
            DelegateMethodAdapter a = new DelegateMethodAdapter(this.mLog, mw, this.mClassName, name, desc, isStatic);
            if (isNative) {
                a.generateCode();
            } else {
                return a;
            }
        }
        return mw;
    }
}

