/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import com.android.tools.layoutlib.create.AsmGenerator;
import com.android.tools.layoutlib.create.Log;
import com.android.tools.layoutlib.create.LogAbortException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmAnalyzer {
    private final Log mLog;
    private final List<String> mOsSourceJar;
    private final AsmGenerator mGen;
    private final String[] mDeriveFrom;
    private final String[] mIncludeGlobs;

    public AsmAnalyzer(Log log, List<String> osJarPath, AsmGenerator gen, String[] deriveFrom, String[] includeGlobs) {
        this.mLog = log;
        this.mGen = gen;
        this.mOsSourceJar = osJarPath != null ? osJarPath : new ArrayList();
        this.mDeriveFrom = deriveFrom != null ? deriveFrom : new String[]{};
        this.mIncludeGlobs = includeGlobs != null ? includeGlobs : new String[]{};
    }

    public void analyze() throws IOException, LogAbortException {
        AsmAnalyzer visitor = this;
        Map<String, ClassReader> zipClasses = this.parseZip(this.mOsSourceJar);
        this.mLog.info("Found %d classes in input JAR%s.", zipClasses.size(), this.mOsSourceJar.size() > 1 ? "s" : "");
        Map<String, ClassReader> found = this.findIncludes(zipClasses);
        Map<String, ClassReader> deps = this.findDeps(zipClasses, found);
        if (this.mGen != null) {
            this.mGen.setKeep(found);
            this.mGen.setDeps(deps);
        }
    }

    Map<String, ClassReader> parseZip(List<String> jarPathList) throws IOException {
        TreeMap<String, ClassReader> classes = new TreeMap<String, ClassReader>();
        for (String jarPath : jarPathList) {
            ZipFile zip = new ZipFile(jarPath);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                ClassReader cr = new ClassReader(zip.getInputStream(entry));
                String className = AsmAnalyzer.classReaderToClassName(cr);
                classes.put(className, cr);
            }
        }
        return classes;
    }

    static String classReaderToClassName(ClassReader classReader) {
        if (classReader == null) {
            return null;
        }
        return classReader.getClassName().replace('/', '.');
    }

    static String internalToBinaryClassName(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('/', '.');
    }

    Map<String, ClassReader> findIncludes(Map<String, ClassReader> zipClasses) throws LogAbortException {
        TreeMap<String, ClassReader> found = new TreeMap<String, ClassReader>();
        this.mLog.debug("Find classes to include.", new Object[0]);
        for (String s : this.mIncludeGlobs) {
            this.findGlobs(s, zipClasses, found);
        }
        for (String s : this.mDeriveFrom) {
            this.findClassesDerivingFrom(s, zipClasses, found);
        }
        return found;
    }

    ClassReader findClass(String className, Map<String, ClassReader> zipClasses, Map<String, ClassReader> inOutFound) throws LogAbortException {
        ClassReader classReader = zipClasses.get(className);
        if (classReader == null) {
            throw new LogAbortException("Class %s not found by ASM in %s", className, this.mOsSourceJar);
        }
        inOutFound.put(className, classReader);
        return classReader;
    }

    void findGlobs(String globPattern, Map<String, ClassReader> zipClasses, Map<String, ClassReader> inOutFound) throws LogAbortException {
        globPattern = globPattern.replaceAll("\\$", "\\\\\\$");
        globPattern = globPattern.replaceAll("\\.", "\\\\.");
        globPattern = globPattern.replaceAll("\\*\\*", "@");
        globPattern = globPattern.replaceAll("\\*", "[^.]*");
        globPattern = globPattern.replaceAll("@", ".*");
        globPattern = globPattern + "$";
        Pattern regexp = Pattern.compile(globPattern);
        for (Map.Entry<String, ClassReader> entry : zipClasses.entrySet()) {
            String class_name = entry.getKey();
            if (!regexp.matcher(class_name).matches()) continue;
            this.findClass(class_name, zipClasses, inOutFound);
        }
    }

    void findClassesDerivingFrom(String super_name, Map<String, ClassReader> zipClasses, Map<String, ClassReader> inOutFound) throws LogAbortException {
        ClassReader super_clazz = this.findClass(super_name, zipClasses, inOutFound);
        block0: for (Map.Entry<String, ClassReader> entry : zipClasses.entrySet()) {
            String parent_name;
            ClassReader classReader;
            String className = entry.getKey();
            if (super_name.equals(className)) continue;
            ClassReader parent_cr = classReader = entry.getValue();
            while (parent_cr != null && (parent_name = AsmAnalyzer.internalToBinaryClassName(parent_cr.getSuperName())) != null) {
                if (super_name.equals(parent_name)) {
                    inOutFound.put(className, classReader);
                    continue block0;
                }
                parent_cr = zipClasses.get(parent_name);
            }
        }
    }

    DependencyVisitor getVisitor(Map<String, ClassReader> zipClasses, Map<String, ClassReader> inKeep, Map<String, ClassReader> outKeep, Map<String, ClassReader> inDeps, Map<String, ClassReader> outDeps) {
        return new DependencyVisitor(zipClasses, inKeep, outKeep, inDeps, outDeps);
    }

    Map<String, ClassReader> findDeps(Map<String, ClassReader> zipClasses, Map<String, ClassReader> inOutKeepClasses) {
        TreeMap<String, ClassReader> deps = new TreeMap<String, ClassReader>();
        TreeMap<String, ClassReader> new_deps = new TreeMap<String, ClassReader>();
        TreeMap<String, ClassReader> new_keep = new TreeMap<String, ClassReader>();
        TreeMap<String, ClassReader> temp = new TreeMap<String, ClassReader>();
        DependencyVisitor visitor = this.getVisitor(zipClasses, inOutKeepClasses, new_keep, deps, new_deps);
        for (ClassReader cr : inOutKeepClasses.values()) {
            cr.accept(visitor, 0);
        }
        while (new_deps.size() > 0 || new_keep.size() > 0) {
            deps.putAll(new_deps);
            inOutKeepClasses.putAll(new_keep);
            temp.clear();
            temp.putAll(new_deps);
            temp.putAll(new_keep);
            new_deps.clear();
            new_keep.clear();
            this.mLog.debug("Found %1$d to keep, %2$d dependencies.", inOutKeepClasses.size(), deps.size());
            for (ClassReader cr : temp.values()) {
                cr.accept(visitor, 0);
            }
        }
        this.mLog.info("Found %1$d classes to keep, %2$d class dependencies.", inOutKeepClasses.size(), deps.size());
        return deps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DependencyVisitor
    implements ClassVisitor,
    FieldVisitor,
    MethodVisitor,
    SignatureVisitor,
    AnnotationVisitor {
        private final Map<String, ClassReader> mZipClasses;
        private final Map<String, ClassReader> mInKeep;
        private final Map<String, ClassReader> mInDeps;
        private final Map<String, ClassReader> mOutDeps;
        private final Map<String, ClassReader> mOutKeep;
        private String mCurrentSignatureClass = null;

        public DependencyVisitor(Map<String, ClassReader> zipClasses, Map<String, ClassReader> inKeep, Map<String, ClassReader> outKeep, Map<String, ClassReader> inDeps, Map<String, ClassReader> outDeps) {
            this.mZipClasses = zipClasses;
            this.mInKeep = inKeep;
            this.mOutKeep = outKeep;
            this.mInDeps = inDeps;
            this.mOutDeps = outDeps;
        }

        public void considerName(String className) {
            if (className == null) {
                return;
            }
            if (this.mInKeep.containsKey(className = AsmAnalyzer.internalToBinaryClassName(className)) || this.mOutKeep.containsKey(className) || this.mInDeps.containsKey(className) || this.mOutDeps.containsKey(className)) {
                return;
            }
            ClassReader cr = this.mZipClasses.get(className);
            if (cr == null) {
                return;
            }
            try {
                if (this.getClass().getClassLoader().loadClass(className) != null) {
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (className.indexOf("android") >= 0) {
                this.mOutDeps.put(className, cr);
            } else {
                this.mOutKeep.put(className, cr);
            }
        }

        public void considerNames(String[] classNames) {
            if (classNames != null) {
                for (String className : classNames) {
                    this.considerName(className);
                }
            }
        }

        public void considerSignature(String signature) {
            if (signature != null) {
                SignatureReader sr = new SignatureReader(signature);
                sr.accept(this);
            }
        }

        public void considerType(Type t) {
            if (t != null) {
                if (t.getSort() == 9) {
                    t = t.getElementType();
                }
                if (t.getSort() == 10) {
                    this.considerName(t.getInternalName());
                }
            }
        }

        public void considerDesc(String desc) {
            if (desc != null) {
                try {
                    Type t = Type.getType(desc);
                    this.considerType(t);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (signature != null) {
                this.considerSignature(signature);
            }
            this.considerName(superName);
            this.considerNames(interfaces);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.considerDesc(desc);
            return this;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.considerDesc(desc);
            this.considerSignature(signature);
            return this;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.considerName(name);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.considerDesc(desc);
            this.considerSignature(signature);
            return this;
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return this;
        }

        @Override
        public void visitCode() {
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.considerName(name);
            this.considerDesc(desc);
        }

        @Override
        public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
        }

        @Override
        public void visitIincInsn(int var, int increment) {
        }

        @Override
        public void visitInsn(int opcode) {
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                this.considerType((Type)cst);
            }
        }

        @Override
        public void visitLineNumber(int line, Label start) {
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.considerDesc(desc);
            this.considerSignature(signature);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.considerName(owner);
            this.considerDesc(desc);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.considerDesc(desc);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            this.considerDesc(desc);
            return this;
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.considerName(type);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            this.considerName(type);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
        }

        @Override
        public void visitClassType(String name) {
            this.mCurrentSignatureClass = name;
            this.considerName(name);
        }

        @Override
        public void visitInnerClassType(String name) {
            if (this.mCurrentSignatureClass != null) {
                this.mCurrentSignatureClass = this.mCurrentSignatureClass + "$" + name;
                this.considerName(this.mCurrentSignatureClass);
            }
        }

        @Override
        public SignatureVisitor visitArrayType() {
            return this;
        }

        @Override
        public void visitBaseType(char descriptor) {
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this;
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            return this;
        }

        @Override
        public void visitFormalTypeParameter(String name) {
        }

        @Override
        public SignatureVisitor visitInterface() {
            return this;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            return this;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return this;
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return this;
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        @Override
        public void visitTypeVariable(String name) {
        }

        @Override
        public void visitTypeArgument() {
        }

        @Override
        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.considerType((Type)value);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.considerDesc(desc);
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.considerDesc(desc);
        }
    }
}

