/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.CreateInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDelegates
extends TestCase {
    public void testNativeDelegates() {
        String[] classes = CreateInfo.DELEGATE_CLASS_NATIVES;
        int count = classes.length;
        for (int i = 0; i < count; ++i) {
            this.loadAndCompareClasses(classes[i], classes[i] + "_Delegate");
        }
    }

    public void testMethodDelegates() {
        for (String methodName : CreateInfo.DELEGATE_METHODS) {
            String className = methodName.substring(0, methodName.indexOf(35));
            String targetClassName = className.replace('$', '_') + "_Delegate";
            this.loadAndCompareClasses(className, targetClassName);
        }
    }

    private void loadAndCompareClasses(String originalClassName, String delegateClassName) {
        try {
            ClassLoader classLoader = TestDelegates.class.getClassLoader();
            Class<?> originalClass = classLoader.loadClass(originalClassName);
            Class<?> delegateClass = classLoader.loadClass(delegateClassName);
            this.compare(originalClass, delegateClass);
        }
        catch (ClassNotFoundException e) {
            TestDelegates.fail((String)("Failed to load class: " + e.getMessage()));
        }
        catch (SecurityException e) {
            TestDelegates.fail((String)("Failed to load class: " + e.getMessage()));
        }
    }

    private void compare(Class<?> originalClass, Class<?> delegateClass) throws SecurityException {
        Method[] delegateMethods;
        Method[] originalMethods;
        ArrayList<Method> checkedDelegateMethods = new ArrayList<Method>();
        for (Method originalMethod : originalMethods = originalClass.getDeclaredMethods()) {
            Class[] newParameters;
            if (originalMethod.getAnnotation(LayoutlibDelegate.class) == null) continue;
            Class<?>[] parameters = originalMethod.getParameterTypes();
            if ((originalMethod.getModifiers() & 8) == 0) {
                newParameters = new Class[parameters.length + 1];
                newParameters[0] = originalClass;
                System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
                parameters = newParameters;
            }
            if (originalClass.getEnclosingClass() != null && (originalClass.getModifiers() & 8) == 0) {
                newParameters = new Class[parameters.length + 1];
                newParameters[0] = originalClass.getEnclosingClass();
                System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
                parameters = newParameters;
            }
            try {
                Method delegateMethod = delegateClass.getDeclaredMethod(originalMethod.getName(), parameters);
                TestDelegates.assertNotNull((String)String.format("Delegate method %1$s for class %2$s does not have the @LayoutlibDelegate annotation", delegateMethod.getName(), originalClass.getName()), (Object)delegateMethod.getAnnotation(LayoutlibDelegate.class));
                TestDelegates.assertTrue((String)String.format("Delegate method %1$s for class %2$s is not static", delegateMethod.getName(), originalClass.getName()), ((delegateMethod.getModifiers() & 8) == 8 ? 1 : 0) != 0);
                checkedDelegateMethods.add(delegateMethod);
            }
            catch (NoSuchMethodException e) {
                String name = this.getMethodName(originalMethod, parameters);
                TestDelegates.fail((String)String.format("Missing %1$s.%2$s", delegateClass.getName(), name));
            }
        }
        for (Method delegateMethod : delegateMethods = delegateClass.getDeclaredMethods()) {
            if (delegateMethod.getAnnotation(LayoutlibDelegate.class) == null) continue;
            TestDelegates.assertTrue((String)String.format("Delegate method %1$s.%2$s is not used anymore and must be removed", delegateClass.getName(), this.getMethodName(delegateMethod)), (boolean)checkedDelegateMethods.contains(delegateMethod));
        }
    }

    private String getMethodName(Method method) {
        return this.getMethodName(method, method.getParameterTypes());
    }

    private String getMethodName(Method method, Class<?>[] parameters) {
        StringBuilder sb = new StringBuilder(method.getName() + "(");
        for (int j = 0; j < parameters.length; ++j) {
            Class<?> theClass = parameters[j];
            sb.append(theClass.getName());
            int dimensions = 0;
            while (theClass.isArray()) {
                ++dimensions;
                theClass = theClass.getComponentType();
            }
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[]");
            }
            if (j >= parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

