/*
 * Decompiled with CFR 0.152.
 */
package com.android.hosttest;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;

public class DeviceConnector {
    private static final int MAX_WAIT_DEVICE_TIME = 5000;

    public IDevice connectToDevice(String deviceSerial) {
        AndroidDebugBridge.init((boolean)false);
        AndroidDebugBridge adbBridge = AndroidDebugBridge.createBridge();
        for (IDevice device : adbBridge.getDevices()) {
            if (deviceSerial == null) {
                return device;
            }
            if (!deviceSerial.equals(device.getSerialNumber())) continue;
            return device;
        }
        System.out.println("Waiting for device...");
        NewDeviceListener listener = new NewDeviceListener(deviceSerial);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
        IDevice device = listener.waitForDevice(5000L);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
        if (device == null) {
            throw new IllegalArgumentException("Could not connect to device");
        }
        System.out.println(String.format("Connected to %s", device.getSerialNumber()));
        return device;
    }

    private static class NewDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private IDevice mDevice;
        private String mSerial;

        public NewDeviceListener(String serial) {
            this.mSerial = serial;
        }

        public void deviceChanged(IDevice device, int changeMask) {
        }

        public void deviceConnected(IDevice device) {
            if (this.mSerial == null) {
                this.setDevice(device);
            } else if (this.mSerial.equals(device.getSerialNumber())) {
                this.setDevice(device);
            }
        }

        private synchronized void setDevice(IDevice device) {
            this.mDevice = device;
            this.notify();
        }

        public void deviceDisconnected(IDevice device) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IDevice waitForDevice(long waitTime) {
            NewDeviceListener newDeviceListener = this;
            synchronized (newDeviceListener) {
                if (this.mDevice == null) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Waiting for device interrupted");
                    }
                }
            }
            return this.mDevice;
        }
    }
}

