/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui.util;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class PsdFile {
    private final Header mHeader;
    private final ColorMode mColorMode;
    private final ImageResources mImageResources;
    private final LayersMasksInfo mLayersMasksInfo;
    private final LayersInfo mLayersInfo;
    private final BufferedImage mMergedImage;
    private final Graphics2D mGraphics;

    public PsdFile(int width, int height) {
        this.mHeader = new Header(width, height);
        this.mColorMode = new ColorMode();
        this.mImageResources = new ImageResources();
        this.mLayersMasksInfo = new LayersMasksInfo();
        this.mLayersInfo = new LayersInfo();
        this.mMergedImage = new BufferedImage(width, height, 2);
        this.mGraphics = this.mMergedImage.createGraphics();
    }

    public void addLayer(String name, BufferedImage image, Point offset) {
        this.addLayer(name, image, offset, true);
    }

    public void addLayer(String name, BufferedImage image, Point offset, boolean visible) {
        this.mLayersInfo.addLayer(name, image, offset, visible);
        if (visible) {
            this.mGraphics.drawImage(image, null, offset.x, offset.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream stream) {
        this.mLayersMasksInfo.setLayersInfo(this.mLayersInfo);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));
        try {
            this.mHeader.write(out);
            out.flush();
            this.mColorMode.write(out);
            this.mImageResources.write(out);
            this.mLayersMasksInfo.write(out);
            this.mLayersInfo.write(out);
            out.flush();
            this.mLayersInfo.writeImageData(out);
            out.flush();
            PsdFile.writeImage(this.mMergedImage, out, false);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void writeImage(BufferedImage image, DataOutputStream out, boolean split) throws IOException {
        if (!split) {
            out.writeShort(0);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int length = width * height;
        int[] pixels = new int[length];
        image.getData().getDataElements(0, 0, width, height, pixels);
        byte[] a = new byte[length];
        byte[] r = new byte[length];
        byte[] g = new byte[length];
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pixel = pixels[i];
            a[i] = (byte)(pixel >> 24 & 0xFF);
            r[i] = (byte)(pixel >> 16 & 0xFF);
            g[i] = (byte)(pixel >> 8 & 0xFF);
            b[i] = (byte)(pixel & 0xFF);
        }
        if (split) {
            out.writeShort(0);
        }
        if (split) {
            out.write(a);
        }
        if (split) {
            out.writeShort(0);
        }
        out.write(r);
        if (split) {
            out.writeShort(0);
        }
        out.write(g);
        if (split) {
            out.writeShort(0);
        }
        out.write(b);
        if (!split) {
            out.write(a);
        }
    }

    static class Channel {
        static final short ID_RED = 0;
        static final short ID_GREEN = 1;
        static final short ID_BLUE = 2;
        static final short ID_ALPHA = -1;
        static final short ID_LAYER_MASK = -2;
        final short mId;
        final int mDataLength;

        Channel(short id, int dataLength) {
            this.mId = id;
            this.mDataLength = dataLength + 2;
        }

        int getLength() {
            return 6 + this.mDataLength;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeShort(this.mId);
            out.writeInt(this.mDataLength);
        }
    }

    static class Layer {
        static final byte OPACITY_TRANSPARENT = 0;
        static final byte OPACITY_OPAQUE = -1;
        static final byte CLIPPING_BASE = 0;
        static final byte CLIPPING_NON_BASE = 1;
        static final byte FLAG_TRANSPARENCY_PROTECTED = 1;
        static final byte FLAG_INVISIBLE = 2;
        final int mTop;
        final int mLeft;
        final int mBottom;
        final int mRight;
        final short mChannelCount = (short)4;
        final Channel[] mChannelInfo = new Channel[4];
        final byte[] mBlendSignature = "8BIM".getBytes();
        final byte[] mBlendMode = "norm".getBytes();
        final byte mOpacity = (byte)-1;
        final byte mClipping = 0;
        byte mFlags = 0;
        final byte mFiller = 0;
        int mExtraSize = 8;
        final int mMaskDataLength = 0;
        final int mBlendRangeDataLength = 0;
        final byte[] mName;
        final byte[] mLayerExtraSignature = "8BIM".getBytes();
        final byte[] mLayerExtraKey = "luni".getBytes();
        int mLayerExtraLength;
        final String mOriginalName;
        private BufferedImage mImage;

        Layer(String name, BufferedImage image, Point offset, boolean visible) {
            int height = image.getHeight();
            int width = image.getWidth();
            int length = width * height;
            this.mChannelInfo[0] = new Channel(-1, length);
            this.mChannelInfo[1] = new Channel(0, length);
            this.mChannelInfo[2] = new Channel(1, length);
            this.mChannelInfo[3] = new Channel(2, length);
            this.mTop = offset.y;
            this.mLeft = offset.x;
            this.mBottom = offset.y + height;
            this.mRight = offset.x + width;
            this.mOriginalName = name;
            byte[] data = name.getBytes();
            try {
                this.mLayerExtraLength = 4 + this.mOriginalName.getBytes("UTF-16").length;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            byte[] nameData = new byte[data.length + 1];
            nameData[0] = (byte)(data.length & 0xFF);
            System.arraycopy(data, 0, nameData, 1, data.length);
            if (nameData.length % 4 != 0) {
                data = new byte[nameData.length + 4 - nameData.length % 4];
                System.arraycopy(nameData, 0, data, 0, nameData.length);
                this.mName = data;
            } else {
                this.mName = nameData;
            }
            this.mExtraSize += this.mName.length;
            this.mExtraSize += this.mLayerExtraLength + 4 + this.mLayerExtraKey.length + this.mLayerExtraSignature.length;
            this.mImage = image;
            if (!visible) {
                this.mFlags = (byte)(this.mFlags | 2);
            }
        }

        int getLength() {
            int length = 18;
            for (Channel channel : this.mChannelInfo) {
                length += channel.getLength();
            }
            length += this.mBlendSignature.length;
            length += this.mBlendMode.length;
            length += 4;
            length += 4;
            return length += this.mExtraSize;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeInt(this.mTop);
            out.writeInt(this.mLeft);
            out.writeInt(this.mBottom);
            out.writeInt(this.mRight);
            out.writeShort(4);
            for (Channel channel : this.mChannelInfo) {
                channel.write(out);
            }
            out.write(this.mBlendSignature);
            out.write(this.mBlendMode);
            out.write(-1);
            out.write(0);
            out.write(this.mFlags);
            out.write(0);
            out.writeInt(this.mExtraSize);
            out.writeInt(0);
            out.writeInt(0);
            out.write(this.mName);
            out.write(this.mLayerExtraSignature);
            out.write(this.mLayerExtraKey);
            out.writeInt(this.mLayerExtraLength);
            out.writeInt(this.mOriginalName.length() + 1);
            out.write(this.mOriginalName.getBytes("UTF-16"));
        }

        void writeImageData(DataOutputStream out) throws IOException {
            PsdFile.writeImage(this.mImage, out, true);
        }
    }

    static class LayersInfo {
        final List<Layer> mLayers = new ArrayList<Layer>();

        LayersInfo() {
        }

        void addLayer(String name, BufferedImage image, Point offset, boolean visible) {
            this.mLayers.add(new Layer(name, image, offset, visible));
        }

        int getLength() {
            int length = 2;
            for (Layer layer : this.mLayers) {
                length += layer.getLength();
            }
            return length;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeShort((short)(-this.mLayers.size()));
            for (Layer layer : this.mLayers) {
                layer.write(out);
            }
        }

        void writeImageData(DataOutputStream out) throws IOException {
            for (Layer layer : this.mLayers) {
                layer.writeImageData(out);
            }
            out.writeInt(0);
        }
    }

    static class LayersMasksInfo {
        int mMiscLength;
        int mLayerInfoLength;

        LayersMasksInfo() {
        }

        void setLayersInfo(LayersInfo layersInfo) {
            this.mLayerInfoLength = layersInfo.getLength();
            if ((this.mLayerInfoLength & 1) == 1) {
                ++this.mLayerInfoLength;
            }
            this.mMiscLength = this.mLayerInfoLength + 8;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeInt(this.mMiscLength);
            out.writeInt(this.mLayerInfoLength);
        }
    }

    static class ImageResources {
        static final short RESOURCE_RESOLUTION_INFO = 1005;
        int mLength = 0;
        final byte[] mSignature = "8BIM".getBytes();
        final short mResourceId = (short)1005;
        final short mPad = 0;
        final int mDataLength = 16;
        final short mHorizontalDisplayUnit = (short)72;
        final int mHorizontalResolution = 1;
        final short mWidthDisplayUnit = 1;
        final short mVerticalDisplayUnit = (short)72;
        final int mVerticalResolution = 1;
        final short mHeightDisplayUnit = 1;

        ImageResources() {
            this.mLength = this.mSignature.length;
            this.mLength += 2;
            this.mLength += 2;
            this.mLength += 4;
            this.mLength += 8;
            this.mLength += 8;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeInt(this.mLength);
            out.write(this.mSignature);
            out.writeShort(1005);
            out.writeShort(0);
            out.writeInt(16);
            out.writeShort(72);
            out.writeInt(1);
            out.writeShort(1);
            out.writeShort(72);
            out.writeInt(1);
            out.writeShort(1);
        }
    }

    static class ColorMode {
        final int mLength = 0;

        ColorMode() {
        }

        void write(DataOutputStream out) throws IOException {
            out.writeInt(0);
        }
    }

    static class Header {
        static final short MODE_BITMAP = 0;
        static final short MODE_GRAYSCALE = 1;
        static final short MODE_INDEXED = 2;
        static final short MODE_RGB = 3;
        static final short MODE_CMYK = 4;
        static final short MODE_MULTI_CHANNEL = 7;
        static final short MODE_DUOTONE = 8;
        static final short MODE_LAB = 9;
        final byte[] mSignature = "8BPS".getBytes();
        final short mVersion = 1;
        final byte[] mReserved = new byte[6];
        final short mChannelCount = (short)4;
        final int mHeight;
        final int mWidth;
        final short mDepth = (short)8;
        final short mMode = (short)3;

        Header(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        void write(DataOutputStream out) throws IOException {
            out.write(this.mSignature);
            out.writeShort(1);
            out.write(this.mReserved);
            out.writeShort(4);
            out.writeInt(this.mHeight);
            out.writeInt(this.mWidth);
            out.writeShort(8);
            out.writeShort(3);
        }
    }
}

