/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import com.android.hierarchyviewer.laf.UnifiedContentBorder;
import com.android.hierarchyviewer.scene.CaptureLoader;
import com.android.hierarchyviewer.scene.ProfilesLoader;
import com.android.hierarchyviewer.scene.VersionLoader;
import com.android.hierarchyviewer.scene.ViewHierarchyLoader;
import com.android.hierarchyviewer.scene.ViewHierarchyScene;
import com.android.hierarchyviewer.scene.ViewManager;
import com.android.hierarchyviewer.scene.ViewNode;
import com.android.hierarchyviewer.scene.WindowsLoader;
import com.android.hierarchyviewer.ui.CaptureRenderer;
import com.android.hierarchyviewer.ui.LayoutRenderer;
import com.android.hierarchyviewer.ui.ScreenViewer;
import com.android.hierarchyviewer.ui.action.CaptureLayersAction;
import com.android.hierarchyviewer.ui.action.CaptureNodeAction;
import com.android.hierarchyviewer.ui.action.ExitAction;
import com.android.hierarchyviewer.ui.action.InvalidateAction;
import com.android.hierarchyviewer.ui.action.LoadGraphAction;
import com.android.hierarchyviewer.ui.action.RefreshWindowsAction;
import com.android.hierarchyviewer.ui.action.RequestLayoutAction;
import com.android.hierarchyviewer.ui.action.SaveSceneAction;
import com.android.hierarchyviewer.ui.action.ShowDevicesAction;
import com.android.hierarchyviewer.ui.action.StartServerAction;
import com.android.hierarchyviewer.ui.action.StopServerAction;
import com.android.hierarchyviewer.ui.model.ProfilesTableModel;
import com.android.hierarchyviewer.ui.model.PropertiesTableModel;
import com.android.hierarchyviewer.ui.model.ViewsTreeModel;
import com.android.hierarchyviewer.ui.util.IconLoader;
import com.android.hierarchyviewer.ui.util.PngFileFilter;
import com.android.hierarchyviewer.ui.util.PsdFileFilter;
import com.android.hierarchyviewer.util.OS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingworker.SwingWorker;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.TreeGraphLayout;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends JFrame {
    private JLabel viewCountLabel;
    private JSlider zoomSlider;
    private JSplitPane sideSplitter;
    private JSplitPane mainSplitter;
    private JTable propertiesTable;
    private JTable profilingTable;
    private JComponent pixelPerfectPanel;
    private JTree pixelPerfectTree;
    private ScreenViewer screenViewer;
    private JPanel extrasPanel;
    private LayoutRenderer layoutView;
    private JScrollPane sceneScroller;
    private JComponent sceneView;
    private ViewHierarchyScene scene;
    private ActionMap actionsMap;
    private JPanel mainPanel;
    private JProgressBar progress;
    private JToolBar buttonsPanel;
    private JComponent deviceSelector;
    private DevicesTableModel devicesTableModel;
    private WindowsTableModel windowsTableModel;
    private IDevice currentDevice;
    private Window currentWindow = Window.FOCUSED_WINDOW;
    private JButton displayNodeButton;
    private JButton captureLayersButton;
    private JButton invalidateButton;
    private JButton requestLayoutButton;
    private JButton loadButton;
    private JButton startButton;
    private JButton stopButton;
    private JButton showDevicesButton;
    private JButton refreshButton;
    private JToggleButton graphViewButton;
    private JToggleButton pixelPerfectViewButton;
    private JMenuItem saveMenuItem;
    private JMenuItem showDevicesMenuItem;
    private JMenuItem loadMenuItem;
    private JMenuItem startMenuItem;
    private JMenuItem stopMenuItem;
    private JTable devices;
    private JTable windows;
    private JLabel minZoomLabel;
    private JLabel maxZoomLabel;
    private JTextField filterText;
    private JLabel filterLabel;
    private int protocolVersion;
    private int serverVersion;

    public Workspace() {
        super("Hierarchy Viewer");
        this.buildActions();
        this.add(this.buildMainPanel());
        this.setJMenuBar(this.buildMenuBar());
        this.devices.changeSelection(0, 0, false, false);
        this.currentDeviceChanged();
        this.pack();
    }

    private void buildActions() {
        this.actionsMap = new ActionMap();
        this.actionsMap.put("exit", new ExitAction(this));
        this.actionsMap.put("showDevices", new ShowDevicesAction(this));
        this.actionsMap.put("loadGraph", new LoadGraphAction(this));
        this.actionsMap.put("saveScene", new SaveSceneAction(this));
        this.actionsMap.put("startServer", new StartServerAction(this));
        this.actionsMap.put("stopServer", new StopServerAction(this));
        this.actionsMap.put("invalidate", new InvalidateAction(this));
        this.actionsMap.put("requestLayout", new RequestLayoutAction(this));
        this.actionsMap.put("captureNode", new CaptureNodeAction(this));
        this.actionsMap.put("captureLayers", new CaptureLayersAction(this));
        this.actionsMap.put("refreshWindows", new RefreshWindowsAction(this));
    }

    private JComponent buildMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.buildToolBar(), "First");
        this.deviceSelector = this.buildDeviceSelector();
        this.mainPanel.add((Component)this.deviceSelector, "Center");
        this.mainPanel.add((Component)this.buildStatusPanel(), "South");
        this.mainPanel.setPreferredSize(new Dimension(950, 800));
        return this.mainPanel;
    }

    private JComponent buildGraphPanel() {
        this.sceneScroller = new JScrollPane();
        this.sceneScroller.setBorder(null);
        this.mainSplitter = new JSplitPane();
        this.mainSplitter.setResizeWeight(1.0);
        this.mainSplitter.setContinuousLayout(true);
        if (OS.isMacOsX() && OS.isLeopardOrLater()) {
            this.mainSplitter.setBorder(new UnifiedContentBorder());
        }
        this.mainSplitter.setLeftComponent(this.sceneScroller);
        this.mainSplitter.setRightComponent(this.buildSideSplitter());
        return this.mainSplitter;
    }

    private JComponent buildDeviceSelector() {
        JPanel panel = new JPanel(new GridBagLayout());
        if (OS.isMacOsX() && OS.isLeopardOrLater()) {
            panel.setBorder(new UnifiedContentBorder());
        }
        this.devicesTableModel = new DevicesTableModel();
        for (IDevice device : DeviceBridge.getDevices()) {
            DeviceBridge.setupDeviceForward(device);
            this.devicesTableModel.addDevice(device);
        }
        DeviceBridge.startListenForDevices(this.devicesTableModel);
        this.devices = new JTable(this.devicesTableModel);
        this.devices.getSelectionModel().addListSelectionListener(new DeviceSelectedListener());
        this.devices.setSelectionMode(0);
        this.devices.setBorder(null);
        JScrollPane devicesScroller = new JScrollPane(this.devices);
        devicesScroller.setBorder(null);
        panel.add((Component)devicesScroller, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.windowsTableModel = new WindowsTableModel();
        this.windowsTableModel.setVisible(false);
        this.windows = new JTable(this.windowsTableModel);
        this.windows.getSelectionModel().addListSelectionListener(new WindowSelectedListener());
        this.windows.setSelectionMode(0);
        this.windows.setBorder(null);
        JScrollPane windowsScroller = new JScrollPane(this.windows);
        windowsScroller.setBorder(null);
        panel.add((Component)windowsScroller, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JComponent buildSideSplitter() {
        this.propertiesTable = new JTable();
        this.propertiesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Property", "Value"}));
        this.propertiesTable.setBorder(null);
        this.propertiesTable.getTableHeader().setBorder(null);
        JScrollPane tableScroller = new JScrollPane(this.propertiesTable);
        tableScroller.setBorder(null);
        this.profilingTable = new JTable();
        this.profilingTable.setModel(new DefaultTableModel(new Object[][]{{" ", " "}, {" ", " "}, {" ", " "}}, new String[]{"Operation", "Duration (ms)"}));
        this.profilingTable.setBorder(null);
        this.profilingTable.getTableHeader().setBorder(null);
        JScrollPane firstTableScroller = new JScrollPane(this.profilingTable);
        firstTableScroller.setBorder(null);
        Workspace.setVisibleRowCount(this.profilingTable, 5);
        firstTableScroller.setMinimumSize(this.profilingTable.getPreferredScrollableViewportSize());
        JSplitPane tablesSplitter = new JSplitPane();
        tablesSplitter.setBorder(null);
        tablesSplitter.setOrientation(0);
        tablesSplitter.setResizeWeight(0.0);
        tablesSplitter.setLeftComponent(firstTableScroller);
        tablesSplitter.setBottomComponent(tableScroller);
        tablesSplitter.setContinuousLayout(true);
        this.sideSplitter = new JSplitPane();
        this.sideSplitter.setBorder(null);
        this.sideSplitter.setOrientation(0);
        this.sideSplitter.setResizeWeight(0.5);
        this.sideSplitter.setLeftComponent(tablesSplitter);
        this.sideSplitter.setBottomComponent(null);
        this.sideSplitter.setContinuousLayout(true);
        return this.sideSplitter;
    }

    private JPanel buildStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        JPanel leftSide = new JPanel();
        leftSide.setOpaque(false);
        leftSide.setLayout(new FlowLayout(0, 0, 5));
        leftSide.add(Box.createHorizontalStrut(6));
        ButtonGroup group = new ButtonGroup();
        this.graphViewButton = new JToggleButton(IconLoader.load(this.getClass(), "/images/icon-graph-view.png"));
        this.graphViewButton.setSelectedIcon(IconLoader.load(this.getClass(), "/images/icon-graph-view-selected.png"));
        this.graphViewButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.graphViewButton.putClientProperty("JButton.segmentPosition", "first");
        this.graphViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Workspace.this.toggleGraphView();
            }
        });
        group.add(this.graphViewButton);
        leftSide.add(this.graphViewButton);
        this.pixelPerfectViewButton = new JToggleButton(IconLoader.load(this.getClass(), "/images/icon-pixel-perfect-view.png"));
        this.pixelPerfectViewButton.setSelectedIcon(IconLoader.load(this.getClass(), "/images/icon-pixel-perfect-view-selected.png"));
        this.pixelPerfectViewButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.pixelPerfectViewButton.putClientProperty("JButton.segmentPosition", "last");
        this.pixelPerfectViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Workspace.this.togglePixelPerfectView();
            }
        });
        group.add(this.pixelPerfectViewButton);
        leftSide.add(this.pixelPerfectViewButton);
        this.graphViewButton.setSelected(true);
        this.filterText = new JTextField(20);
        this.filterText.putClientProperty("JComponent.sizeVariant", "small");
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                Workspace.this.updateFilter(e);
            }

            public void removeUpdate(DocumentEvent e) {
                Workspace.this.updateFilter(e);
            }

            public void changedUpdate(DocumentEvent e) {
                Workspace.this.updateFilter(e);
            }
        });
        this.filterLabel = new JLabel("Filter by class or id:");
        this.filterLabel.putClientProperty("JComponent.sizeVariant", "small");
        this.filterLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        leftSide.add(this.filterLabel);
        leftSide.add(this.filterText);
        this.minZoomLabel = new JLabel();
        this.minZoomLabel.setText("20%");
        this.minZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        this.minZoomLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        leftSide.add(this.minZoomLabel);
        this.zoomSlider = new JSlider();
        this.zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        this.zoomSlider.setMaximum(200);
        this.zoomSlider.setMinimum(20);
        this.zoomSlider.setValue(100);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Workspace.this.zoomSliderStateChanged(evt);
            }
        });
        leftSide.add(this.zoomSlider);
        this.maxZoomLabel = new JLabel();
        this.maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        this.maxZoomLabel.setText("200%");
        leftSide.add(this.maxZoomLabel);
        this.viewCountLabel = new JLabel();
        this.viewCountLabel.setText("0 views");
        this.viewCountLabel.putClientProperty("JComponent.sizeVariant", "small");
        this.viewCountLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        leftSide.add(this.viewCountLabel);
        statusPanel.add((Component)leftSide, "Before");
        JPanel rightSide = new JPanel();
        rightSide.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        rightSide.setLayout(new FlowLayout(2));
        this.progress = new JProgressBar();
        this.progress.setVisible(false);
        this.progress.setIndeterminate(true);
        this.progress.putClientProperty("JComponent.sizeVariant", "mini");
        this.progress.putClientProperty("JProgressBar.style", "circular");
        rightSide.add(this.progress);
        statusPanel.add((Component)rightSide, "After");
        this.hideStatusBarComponents();
        return statusPanel;
    }

    private void hideStatusBarComponents() {
        this.viewCountLabel.setVisible(false);
        this.zoomSlider.setVisible(false);
        this.minZoomLabel.setVisible(false);
        this.maxZoomLabel.setVisible(false);
        this.filterLabel.setVisible(false);
        this.filterText.setVisible(false);
    }

    private JToolBar buildToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.startButton = new JButton();
        this.startButton.setAction(this.actionsMap.get("startServer"));
        this.startButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.startButton.putClientProperty("JButton.segmentPosition", "first");
        toolBar.add(this.startButton);
        this.stopButton = new JButton();
        this.stopButton.setAction(this.actionsMap.get("stopServer"));
        this.stopButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.stopButton.putClientProperty("JButton.segmentPosition", "middle");
        toolBar.add(this.stopButton);
        this.refreshButton = new JButton();
        this.refreshButton.setAction(this.actionsMap.get("refreshWindows"));
        this.refreshButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.refreshButton.putClientProperty("JButton.segmentPosition", "last");
        toolBar.add(this.refreshButton);
        this.showDevicesButton = new JButton();
        this.showDevicesButton.setAction(this.actionsMap.get("showDevices"));
        this.showDevicesButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.showDevicesButton.putClientProperty("JButton.segmentPosition", "first");
        toolBar.add(this.showDevicesButton);
        this.showDevicesButton.setEnabled(false);
        this.loadButton = new JButton();
        this.loadButton.setAction(this.actionsMap.get("loadGraph"));
        this.loadButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.loadButton.putClientProperty("JButton.segmentPosition", "last");
        toolBar.add(this.loadButton);
        this.displayNodeButton = new JButton();
        this.displayNodeButton.setAction(this.actionsMap.get("captureNode"));
        this.displayNodeButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.displayNodeButton.putClientProperty("JButton.segmentPosition", "first");
        toolBar.add(this.displayNodeButton);
        this.captureLayersButton = new JButton();
        this.captureLayersButton.setAction(this.actionsMap.get("captureLayers"));
        this.captureLayersButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.captureLayersButton.putClientProperty("JButton.segmentPosition", "middle");
        toolBar.add(this.captureLayersButton);
        this.invalidateButton = new JButton();
        this.invalidateButton.setAction(this.actionsMap.get("invalidate"));
        this.invalidateButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.invalidateButton.putClientProperty("JButton.segmentPosition", "middle");
        toolBar.add(this.invalidateButton);
        this.requestLayoutButton = new JButton();
        this.requestLayoutButton.setAction(this.actionsMap.get("requestLayout"));
        this.requestLayoutButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.requestLayoutButton.putClientProperty("JButton.segmentPosition", "last");
        toolBar.add(this.requestLayoutButton);
        return toolBar;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenu viewMenu = new JMenu();
        JMenu viewHierarchyMenu = new JMenu();
        JMenu serverMenu = new JMenu();
        this.saveMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.showDevicesMenuItem = new JMenuItem();
        this.loadMenuItem = new JMenuItem();
        this.startMenuItem = new JMenuItem();
        this.stopMenuItem = new JMenuItem();
        fileMenu.setText("File");
        this.saveMenuItem.setAction(this.actionsMap.get("saveScene"));
        fileMenu.add(this.saveMenuItem);
        exitMenuItem.setAction(this.actionsMap.get("exit"));
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        viewMenu.setText("View");
        this.showDevicesMenuItem.setAction(this.actionsMap.get("showDevices"));
        this.showDevicesMenuItem.setEnabled(false);
        viewMenu.add(this.showDevicesMenuItem);
        menuBar.add(viewMenu);
        viewHierarchyMenu.setText("Hierarchy");
        this.loadMenuItem.setAction(this.actionsMap.get("loadGraph"));
        viewHierarchyMenu.add(this.loadMenuItem);
        menuBar.add(viewHierarchyMenu);
        serverMenu.setText("Server");
        this.startMenuItem.setAction(this.actionsMap.get("startServer"));
        serverMenu.add(this.startMenuItem);
        this.stopMenuItem.setAction(this.actionsMap.get("stopServer"));
        serverMenu.add(this.stopMenuItem);
        menuBar.add(serverMenu);
        return menuBar;
    }

    private JComponent buildPixelPerfectPanel() {
        JSplitPane splitter = new JSplitPane(1);
        this.pixelPerfectTree = new JTree(new Object[0]);
        this.pixelPerfectTree.setBorder(null);
        this.pixelPerfectTree.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.pixelPerfectTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                ViewNode node = (ViewNode)event.getPath().getLastPathComponent();
                Workspace.this.screenViewer.select(node);
            }
        });
        JScrollPane scroller = new JScrollPane(this.pixelPerfectTree);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        splitter.setContinuousLayout(true);
        splitter.setLeftComponent(scroller);
        splitter.setRightComponent(this.buildPixelPerfectViewer(splitter));
        splitter.setBorder(null);
        if (OS.isMacOsX() && OS.isLeopardOrLater()) {
            splitter.setBorder(new UnifiedContentBorder());
        }
        return splitter;
    }

    private JComponent buildPixelPerfectViewer(JSplitPane splitter) {
        this.screenViewer = new ScreenViewer(this, this.currentDevice, splitter.getDividerSize());
        return this.screenViewer;
    }

    private void toggleGraphView() {
        this.showStatusBarComponents();
        this.screenViewer.stop();
        this.mainPanel.remove(this.pixelPerfectPanel);
        this.mainPanel.add((Component)this.mainSplitter, "Center");
        this.validate();
        this.repaint();
    }

    private void showStatusBarComponents() {
        this.viewCountLabel.setVisible(true);
        this.zoomSlider.setVisible(true);
        this.minZoomLabel.setVisible(true);
        this.maxZoomLabel.setVisible(true);
        this.filterLabel.setVisible(true);
        this.filterText.setVisible(true);
    }

    private void togglePixelPerfectView() {
        if (this.pixelPerfectPanel == null) {
            this.pixelPerfectPanel = this.buildPixelPerfectPanel();
            this.showPixelPerfectTree();
        } else {
            this.screenViewer.start();
        }
        this.hideStatusBarComponents();
        this.mainPanel.remove(this.mainSplitter);
        this.mainPanel.add((Component)this.pixelPerfectPanel, "Center");
        this.validate();
        this.repaint();
    }

    private void zoomSliderStateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        if (this.sceneView != null) {
            this.scene.setZoomFactor((double)slider.getValue() / 100.0);
            this.sceneView.repaint();
        }
    }

    private void showProperties(ViewNode node) {
        this.propertiesTable.setModel(new PropertiesTableModel(node));
    }

    private void updateProfiles(double[] profiles) {
        this.profilingTable.setModel(new ProfilesTableModel(profiles));
        Workspace.setVisibleRowCount(this.profilingTable, profiles.length + 1);
    }

    public static void setVisibleRowCount(JTable table, int rows) {
        int height = 0;
        for (int row = 0; row < rows; ++row) {
            height += table.getRowHeight(row);
        }
        Dimension size = new Dimension(table.getPreferredScrollableViewportSize().width, height);
        table.setPreferredScrollableViewportSize(size);
        table.revalidate();
    }

    private void showPixelPerfectTree() {
        if (this.pixelPerfectTree == null) {
            return;
        }
        this.pixelPerfectTree.setModel(new ViewsTreeModel(this.scene.getRoot()));
        this.pixelPerfectTree.setCellRenderer(new ViewsTreeCellRenderer());
        Workspace.expandAll(this.pixelPerfectTree, true);
    }

    private static void expandAll(JTree tree, boolean expand) {
        ViewNode root = (ViewNode)tree.getModel().getRoot();
        Workspace.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        ViewNode node = (ViewNode)parent.getLastPathComponent();
        if (node.children != null) {
            for (ViewNode n : node.children) {
                TreePath path = parent.pathByAddingChild(n);
                Workspace.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void createGraph(ViewHierarchyScene scene) {
        scene.addObjectSceneListener(new SceneFocusListener(), new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_FOCUS_CHANGED});
        if (this.mainSplitter == null) {
            this.mainPanel.remove(this.deviceSelector);
            this.mainPanel.add((Component)this.buildGraphPanel(), "Center");
            this.showDevicesButton.setEnabled(true);
            this.showDevicesMenuItem.setEnabled(true);
            this.graphViewButton.setEnabled(true);
            this.pixelPerfectViewButton.setEnabled(true);
            this.showStatusBarComponents();
        }
        this.sceneView = scene.createView();
        this.sceneView.addMouseListener(new NodeClickListener());
        this.sceneView.addMouseWheelListener(new WheelZoomListener());
        this.sceneScroller.setViewportView(this.sceneView);
        if (this.extrasPanel != null) {
            this.sideSplitter.remove(this.extrasPanel);
        }
        this.sideSplitter.setBottomComponent(this.buildExtrasPanel());
        this.mainSplitter.setDividerLocation(this.getWidth() - this.mainSplitter.getDividerSize() - this.buttonsPanel.getPreferredSize().width);
        this.captureLayersButton.setEnabled(true);
        this.saveMenuItem.setEnabled(true);
        this.showPixelPerfectTree();
        this.updateStatus();
        this.layoutScene();
    }

    private void layoutScene() {
        TreeGraphLayout layout = new TreeGraphLayout((GraphScene)this.scene, 50, 50, 70, 30, true);
        layout.layout((Object)this.scene.getRoot());
    }

    private void updateStatus() {
        this.viewCountLabel.setText("" + this.scene.getNodes().size() + " views");
        this.zoomSlider.setEnabled(this.scene.getNodes().size() > 0);
    }

    private JPanel buildExtrasPanel() {
        this.extrasPanel = new JPanel(new BorderLayout());
        this.layoutView = new LayoutRenderer(this.scene, this.sceneView);
        JScrollPane p = new JScrollPane(this.layoutView);
        JScrollBar b = p.getVerticalScrollBar();
        b.setUnitIncrement(10);
        this.extrasPanel.add(p);
        this.extrasPanel.add((Component)this.scene.createSatelliteView(), "South");
        this.extrasPanel.add((Component)this.buildLayoutViewControlButtons(), "North");
        return this.extrasPanel;
    }

    private JComponent buildLayoutViewControlButtons() {
        this.buttonsPanel = new JToolBar();
        this.buttonsPanel.setFloatable(false);
        ButtonGroup group = new ButtonGroup();
        JToggleButton white = new JToggleButton("On White");
        Workspace.toggleColorOnSelect(white);
        white.putClientProperty("JButton.buttonType", "segmentedTextured");
        white.putClientProperty("JButton.segmentPosition", "first");
        white.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Workspace.this.layoutView.setBackground(Color.WHITE);
                Workspace.this.layoutView.setForeground(Color.BLACK);
            }
        });
        group.add(white);
        this.buttonsPanel.add(white);
        JToggleButton black = new JToggleButton("On Black");
        Workspace.toggleColorOnSelect(black);
        black.putClientProperty("JButton.buttonType", "segmentedTextured");
        black.putClientProperty("JButton.segmentPosition", "last");
        black.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Workspace.this.layoutView.setBackground(Color.BLACK);
                Workspace.this.layoutView.setForeground(Color.WHITE);
            }
        });
        group.add(black);
        this.buttonsPanel.add(black);
        black.setSelected(true);
        JCheckBox showExtras = new JCheckBox("Show Extras");
        showExtras.putClientProperty("JComponent.sizeVariant", "small");
        showExtras.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Workspace.this.layoutView.setShowExtras(((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.buttonsPanel.add(showExtras);
        return this.buttonsPanel;
    }

    private void showCaptureWindow(ViewNode node, String captureParams, Image image) {
        if (image != null) {
            this.layoutView.repaint();
            JFrame frame = new JFrame(captureParams);
            JPanel panel = new JPanel(new BorderLayout());
            final CaptureRenderer label = new CaptureRenderer(new ImageIcon(image), node);
            label.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
            final JPanel solidColor = new JPanel(new BorderLayout());
            solidColor.setBackground(Color.BLACK);
            solidColor.add(label);
            JToolBar toolBar = new JToolBar();
            toolBar.setFloatable(false);
            ButtonGroup group = new ButtonGroup();
            JToggleButton white = new JToggleButton("On White");
            Workspace.toggleColorOnSelect(white);
            white.putClientProperty("JButton.buttonType", "segmentedTextured");
            white.putClientProperty("JButton.segmentPosition", "first");
            white.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    solidColor.setBackground(Color.WHITE);
                }
            });
            group.add(white);
            toolBar.add(white);
            JToggleButton black = new JToggleButton("On Black");
            Workspace.toggleColorOnSelect(black);
            black.putClientProperty("JButton.buttonType", "segmentedTextured");
            black.putClientProperty("JButton.segmentPosition", "last");
            black.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    solidColor.setBackground(Color.BLACK);
                }
            });
            group.add(black);
            toolBar.add(black);
            black.setSelected(true);
            JCheckBox showExtras = new JCheckBox("Show Extras");
            showExtras.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    label.setShowExtras(((JCheckBox)e.getSource()).isSelected());
                }
            });
            toolBar.add(showExtras);
            panel.add((Component)toolBar, "North");
            panel.add(solidColor);
            frame.add(panel);
            frame.pack();
            frame.setResizable(false);
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
        }
    }

    private void reset() {
        this.currentDevice = null;
        this.currentWindow = null;
        this.currentDeviceChanged();
        this.windowsTableModel.setVisible(false);
        this.windowsTableModel.clear();
        this.showDevicesSelector();
    }

    public void showDevicesSelector() {
        if (this.mainSplitter != null) {
            if (this.pixelPerfectPanel != null) {
                this.screenViewer.start();
            }
            this.mainPanel.remove(this.graphViewButton.isSelected() ? this.mainSplitter : this.pixelPerfectPanel);
            this.mainPanel.add((Component)this.deviceSelector, "Center");
            this.mainSplitter = null;
            this.pixelPerfectPanel = null;
            this.graphViewButton.setSelected(true);
            this.hideStatusBarComponents();
            this.saveMenuItem.setEnabled(false);
            this.showDevicesMenuItem.setEnabled(false);
            this.showDevicesButton.setEnabled(false);
            this.displayNodeButton.setEnabled(false);
            this.captureLayersButton.setEnabled(false);
            this.invalidateButton.setEnabled(false);
            this.requestLayoutButton.setEnabled(false);
            this.graphViewButton.setEnabled(false);
            this.pixelPerfectViewButton.setEnabled(false);
            if (this.currentDevice != null) {
                if (!DeviceBridge.isViewServerRunning(this.currentDevice)) {
                    DeviceBridge.startViewServer(this.currentDevice);
                }
                this.loadWindows().execute();
                this.windowsTableModel.setVisible(true);
            }
            this.validate();
            this.repaint();
        }
    }

    private void currentDeviceChanged() {
        if (this.currentDevice == null) {
            this.startButton.setEnabled(false);
            this.startMenuItem.setEnabled(false);
            this.stopButton.setEnabled(false);
            this.stopMenuItem.setEnabled(false);
            this.refreshButton.setEnabled(false);
            this.saveMenuItem.setEnabled(false);
            this.loadButton.setEnabled(false);
            this.displayNodeButton.setEnabled(false);
            this.captureLayersButton.setEnabled(false);
            this.invalidateButton.setEnabled(false);
            this.graphViewButton.setEnabled(false);
            this.pixelPerfectViewButton.setEnabled(false);
            this.requestLayoutButton.setEnabled(false);
            this.loadMenuItem.setEnabled(false);
        } else {
            this.loadMenuItem.setEnabled(true);
            this.checkForServerOnCurrentDevice();
        }
    }

    private void checkForServerOnCurrentDevice() {
        if (DeviceBridge.isViewServerRunning(this.currentDevice)) {
            this.startButton.setEnabled(false);
            this.startMenuItem.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.stopMenuItem.setEnabled(true);
            this.loadButton.setEnabled(true);
            this.refreshButton.setEnabled(true);
        } else {
            this.startButton.setEnabled(true);
            this.startMenuItem.setEnabled(true);
            this.stopButton.setEnabled(false);
            this.stopMenuItem.setEnabled(false);
            this.loadButton.setEnabled(false);
            this.refreshButton.setEnabled(false);
        }
    }

    public void cleanupDevices() {
        for (IDevice device : this.devicesTableModel.getDevices()) {
            DeviceBridge.removeDeviceForward(device);
        }
    }

    private static void toggleColorOnSelect(JToggleButton button) {
        if (!OS.isMacOsX() || !OS.isLeopardOrLater()) {
            return;
        }
        button.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                JToggleButton button = (JToggleButton)event.getSource();
                if (button.isSelected()) {
                    button.setForeground(Color.WHITE);
                } else {
                    button.setForeground(Color.BLACK);
                }
            }
        });
    }

    private void updateFilter(DocumentEvent e) {
        Document document = e.getDocument();
        try {
            this.updateFilteredNodes(document.getText(0, document.getLength()));
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    private void updateFilteredNodes(String filterText) {
        ViewNode root = this.scene.getRoot();
        try {
            Pattern pattern = Pattern.compile(filterText, 2);
            this.filterNodes(pattern, root);
        }
        catch (PatternSyntaxException e) {
            this.filterNodes(null, root);
        }
        this.repaint();
    }

    private void filterNodes(Pattern pattern, ViewNode root) {
        root.filter(pattern);
        for (ViewNode node : root.children) {
            this.filterNodes(pattern, node);
        }
    }

    public void beginTask() {
        this.progress.setVisible(true);
    }

    public void endTask() {
        this.progress.setVisible(false);
    }

    public SwingWorker<?, ?> showNodeCapture() {
        if (this.scene.getFocusedObject() == null) {
            return null;
        }
        return new CaptureNodeTask();
    }

    public SwingWorker<?, ?> captureLayers() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PsdFileFilter());
        int choice = chooser.showSaveDialog(this.sceneView);
        if (choice == 0) {
            return new CaptureLayersTask(chooser.getSelectedFile());
        }
        return null;
    }

    public SwingWorker<?, ?> startServer() {
        return new StartServerTask();
    }

    public SwingWorker<?, ?> stopServer() {
        return new StopServerTask();
    }

    public SwingWorker<?, ?> loadWindows() {
        return new LoadWindowsTask();
    }

    public SwingWorker<?, ?> loadGraph() {
        return new LoadGraphTask();
    }

    public SwingWorker<?, ?> invalidateView() {
        if (this.scene.getFocusedObject() == null) {
            return null;
        }
        return new InvalidateTask();
    }

    public SwingWorker<?, ?> requestLayout() {
        if (this.scene.getFocusedObject() == null) {
            return null;
        }
        return new RequestLayoutTask();
    }

    public SwingWorker<?, ?> saveSceneAsImage() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PngFileFilter());
        int choice = chooser.showSaveDialog(this.sceneView);
        if (choice == 0) {
            return new SaveSceneTask(chooser.getSelectedFile());
        }
        return null;
    }

    private static class ViewsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ViewsTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String name = ((ViewNode)value).name;
            value = name.substring(name.lastIndexOf(46) + 1, name.lastIndexOf(64));
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    private class WindowSelectedListener
    implements ListSelectionListener {
        private WindowSelectedListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int row = Workspace.this.windows.getSelectedRow();
            if (row >= 0) {
                Workspace.this.currentWindow = Workspace.this.windowsTableModel.getWindow(row);
            } else {
                Workspace.this.currentWindow = Window.FOCUSED_WINDOW;
            }
        }
    }

    private class DeviceSelectedListener
    implements ListSelectionListener {
        private DeviceSelectedListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int row = Workspace.this.devices.getSelectedRow();
            if (row >= 0) {
                Workspace.this.currentDevice = Workspace.this.devicesTableModel.getDevice(row);
                Workspace.this.currentDeviceChanged();
                if (Workspace.this.currentDevice != null) {
                    if (!DeviceBridge.isViewServerRunning(Workspace.this.currentDevice)) {
                        DeviceBridge.startViewServer(Workspace.this.currentDevice);
                        Workspace.this.checkForServerOnCurrentDevice();
                    }
                    Workspace.this.loadWindows().execute();
                    Workspace.this.windowsTableModel.setVisible(true);
                }
            } else {
                Workspace.this.currentDevice = null;
                Workspace.this.currentDeviceChanged();
                Workspace.this.windowsTableModel.setVisible(false);
                Workspace.this.windowsTableModel.clear();
            }
        }
    }

    private static class WindowsTableModel
    extends DefaultTableModel {
        private ArrayList<Window> windows = new ArrayList();
        private boolean visible;

        private WindowsTableModel() {
            this.windows.add(Window.FOCUSED_WINDOW);
        }

        public int getColumnCount() {
            return 1;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public String getColumnName(int column) {
            return "Windows";
        }

        public Object getValueAt(int row, int column) {
            return this.windows.get(row);
        }

        public int getRowCount() {
            return !this.visible || this.windows == null ? 0 : this.windows.size();
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
            this.fireTableDataChanged();
        }

        public void addWindow(Window window) {
            this.windows.add(window);
            this.fireTableDataChanged();
        }

        public void addWindows(Window[] windowsList) {
            for (Window window : windowsList) {
                this.windows.add(window);
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            this.windows.clear();
            this.windows.add(Window.FOCUSED_WINDOW);
        }

        public Window getWindow(int index) {
            return this.windows.get(index);
        }
    }

    private class DevicesTableModel
    extends DefaultTableModel
    implements AndroidDebugBridge.IDeviceChangeListener {
        private ArrayList<IDevice> devices = new ArrayList();

        private DevicesTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            return this.devices.get(row);
        }

        public String getColumnName(int column) {
            return "Devices";
        }

        public void deviceConnected(final IDevice device) {
            DeviceBridge.setupDeviceForward(device);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DevicesTableModel.this.addDevice(device);
                }
            });
        }

        public void deviceDisconnected(final IDevice device) {
            DeviceBridge.removeDeviceForward(device);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DevicesTableModel.this.removeDevice(device);
                }
            });
        }

        public void addDevice(IDevice device) {
            if (!this.devices.contains(device)) {
                this.devices.add(device);
                this.fireTableDataChanged();
            }
        }

        public void removeDevice(IDevice device) {
            if (device.equals(Workspace.this.currentDevice)) {
                Workspace.this.reset();
            }
            if (this.devices.contains(device)) {
                this.devices.remove(device);
                this.fireTableDataChanged();
            }
        }

        public void deviceChanged(IDevice device, int changeMask) {
            if ((changeMask & 1) != 0 && device.isOnline()) {
                DeviceBridge.setupDeviceForward(device);
            } else if (device == Workspace.this.currentDevice && (changeMask & 2) != 0) {
                Workspace.this.loadWindows().execute();
                Workspace.this.windowsTableModel.setVisible(true);
            }
        }

        public int getRowCount() {
            return this.devices == null ? 0 : this.devices.size();
        }

        public IDevice getDevice(int index) {
            return index < this.devices.size() ? this.devices.get(index) : null;
        }

        public IDevice[] getDevices() {
            return this.devices.toArray(new IDevice[this.devices.size()]);
        }
    }

    private class WheelZoomListener
    implements MouseWheelListener {
        private WheelZoomListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (Workspace.this.zoomSlider != null) {
                int val = Workspace.this.zoomSlider.getValue();
                Workspace.this.zoomSlider.setValue(val -= e.getWheelRotation() * 10);
            }
        }
    }

    private class NodeClickListener
    extends MouseAdapter {
        private NodeClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Workspace.this.showNodeCapture().execute();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SceneFocusListener
    implements ObjectSceneListener {
        private SceneFocusListener() {
        }

        public void objectAdded(ObjectSceneEvent arg0, Object arg1) {
        }

        public void objectRemoved(ObjectSceneEvent arg0, Object arg1) {
        }

        public void objectStateChanged(ObjectSceneEvent arg0, Object arg1, ObjectState arg2, ObjectState arg3) {
        }

        public void selectionChanged(ObjectSceneEvent e, Set<Object> previousSelection, Set<Object> newSelection) {
        }

        public void highlightingChanged(ObjectSceneEvent arg0, Set<Object> arg1, Set<Object> arg2) {
        }

        public void hoverChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
        }

        public void focusChanged(ObjectSceneEvent e, Object oldFocus, Object newFocus) {
            Workspace.this.displayNodeButton.setEnabled(true);
            Workspace.this.invalidateButton.setEnabled(true);
            Workspace.this.requestLayoutButton.setEnabled(true);
            HashSet<Object> selection = new HashSet<Object>();
            selection.add(newFocus);
            Workspace.this.scene.setSelectedObjects(selection);
            Workspace.this.showProperties((ViewNode)newFocus);
            Workspace.this.layoutView.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SaveSceneTask
    extends SwingWorker<Object, Void> {
        private File file;

        private SaveSceneTask(File file) {
            this.file = file;
            Workspace.this.beginTask();
        }

        protected Object doInBackground() {
            if (Workspace.this.sceneView == null) {
                return null;
            }
            try {
                BufferedImage image = new BufferedImage(Workspace.this.sceneView.getWidth(), Workspace.this.sceneView.getHeight(), 1);
                Graphics2D g2 = image.createGraphics();
                Workspace.this.sceneView.paint(g2);
                g2.dispose();
                ImageIO.write((RenderedImage)image, "PNG", this.file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return null;
        }

        protected void done() {
            Workspace.this.endTask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadGraphTask
    extends SwingWorker<double[], Void> {
        public LoadGraphTask() {
            Workspace.this.beginTask();
        }

        protected double[] doInBackground() {
            Workspace.this.scene = ViewHierarchyLoader.loadScene(Workspace.this.currentDevice, Workspace.this.currentWindow);
            return ProfilesLoader.loadProfiles(Workspace.this.currentDevice, Workspace.this.currentWindow, Workspace.this.scene.getRoot().toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            try {
                Workspace.this.createGraph(Workspace.this.scene);
                Workspace.this.updateProfiles((double[])this.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            finally {
                Workspace.this.endTask();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StopServerTask
    extends SwingWorker<Object, Void> {
        public StopServerTask() {
            Workspace.this.beginTask();
        }

        protected Object doInBackground() {
            DeviceBridge.stopViewServer(Workspace.this.currentDevice);
            return null;
        }

        protected void done() {
            Workspace.this.windowsTableModel.setVisible(false);
            Workspace.this.windowsTableModel.clear();
            Workspace.this.checkForServerOnCurrentDevice();
            Workspace.this.endTask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartServerTask
    extends SwingWorker<Object, Void> {
        public StartServerTask() {
            Workspace.this.beginTask();
        }

        protected Object doInBackground() {
            DeviceBridge.startViewServer(Workspace.this.currentDevice);
            return null;
        }

        protected void done() {
            new LoadWindowsTask().execute();
            Workspace.this.windowsTableModel.setVisible(true);
            Workspace.this.checkForServerOnCurrentDevice();
            Workspace.this.endTask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadWindowsTask
    extends SwingWorker<WindowsResult, Void> {
        private LoadWindowsTask() {
            Workspace.this.beginTask();
        }

        protected WindowsResult doInBackground() throws Exception {
            WindowsResult r = new WindowsResult();
            r.protocolVersion = VersionLoader.loadProtocolVersion(Workspace.this.currentDevice);
            r.serverVersion = VersionLoader.loadServerVersion(Workspace.this.currentDevice);
            r.windows = WindowsLoader.loadWindows(Workspace.this.currentDevice, r.protocolVersion, r.serverVersion);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            try {
                WindowsResult result = (WindowsResult)this.get();
                Workspace.this.protocolVersion = result.protocolVersion;
                Workspace.this.serverVersion = result.serverVersion;
                Workspace.this.windowsTableModel.clear();
                Workspace.this.windowsTableModel.addWindows(result.windows);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                Workspace.this.endTask();
            }
        }
    }

    static class WindowsResult {
        Window[] windows;
        int serverVersion;
        int protocolVersion;

        WindowsResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CaptureNodeTask
    extends SwingWorker<Image, Void> {
        private String captureParams;
        private ViewNode node;

        private CaptureNodeTask() {
            this.node = (ViewNode)Workspace.this.scene.getFocusedObject();
            this.captureParams = this.node.toString();
            Workspace.this.beginTask();
        }

        protected Image doInBackground() throws Exception {
            this.node.image = CaptureLoader.loadCapture(Workspace.this.currentDevice, Workspace.this.currentWindow, this.captureParams);
            return this.node.image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            try {
                Image image = (Image)this.get();
                Workspace.this.showCaptureWindow(this.node, this.captureParams, image);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            finally {
                Workspace.this.endTask();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CaptureLayersTask
    extends SwingWorker<Boolean, Void> {
        private File file;

        private CaptureLayersTask(File file) {
            this.file = file;
            Workspace.this.beginTask();
        }

        protected Boolean doInBackground() throws Exception {
            return CaptureLoader.saveLayers(Workspace.this.currentDevice, Workspace.this.currentWindow, this.file);
        }

        protected void done() {
            Workspace.this.endTask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestLayoutTask
    extends SwingWorker<Object, Void> {
        private String captureParams;

        private RequestLayoutTask() {
            this.captureParams = Workspace.this.scene.getFocusedObject().toString();
            Workspace.this.beginTask();
        }

        protected Object doInBackground() throws Exception {
            ViewManager.requestLayout(Workspace.this.currentDevice, Workspace.this.currentWindow, this.captureParams);
            return null;
        }

        protected void done() {
            Workspace.this.endTask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvalidateTask
    extends SwingWorker<Object, Void> {
        private String captureParams;

        private InvalidateTask() {
            this.captureParams = Workspace.this.scene.getFocusedObject().toString();
            Workspace.this.beginTask();
        }

        protected Object doInBackground() throws Exception {
            ViewManager.invalidate(Workspace.this.currentDevice, Workspace.this.currentWindow, this.captureParams);
            return null;
        }

        protected void done() {
            Workspace.this.endTask();
        }
    }
}

