/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import com.android.hierarchyviewer.scene.ViewHierarchyScene;
import com.android.hierarchyviewer.scene.ViewNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Comparator;
import java.util.Stack;
import org.openide.util.Exceptions;

public class ViewHierarchyLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewHierarchyScene loadScene(IDevice device, Window window) {
        ViewHierarchyScene scene = new ViewHierarchyScene();
        Socket socket = null;
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            String line;
            System.out.println("==> Starting client");
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "utf-8"));
            System.out.println("==> DUMP");
            out.write("DUMP " + window.encode());
            out.newLine();
            out.flush();
            Stack<ViewNode> stack = new Stack<ViewNode>();
            boolean setRoot = true;
            ViewNode lastNode = null;
            int lastWhitespaceCount = Integer.MAX_VALUE;
            while ((line = in.readLine()) != null && !"DONE.".equalsIgnoreCase(line)) {
                int whitespaceCount = ViewHierarchyLoader.countFrontWhitespace(line);
                if (lastWhitespaceCount < whitespaceCount) {
                    stack.push(lastNode);
                } else if (!stack.isEmpty()) {
                    int count = lastWhitespaceCount - whitespaceCount;
                    for (int i = 0; i < count; ++i) {
                        stack.pop();
                    }
                }
                lastWhitespaceCount = whitespaceCount;
                line = line.trim();
                int index = line.indexOf(32);
                lastNode = new ViewNode();
                lastNode.name = line.substring(0, index);
                line = line.substring(index + 1);
                ViewHierarchyLoader.loadProperties(lastNode, line);
                scene.addNode(lastNode);
                if (setRoot) {
                    scene.setRoot(lastNode);
                    setRoot = false;
                }
                if (stack.isEmpty()) continue;
                ViewNode parent = (ViewNode)stack.peek();
                String edge = parent.name + lastNode.name;
                scene.addEdge(edge);
                scene.setEdgeSource(edge, parent);
                scene.setEdgeTarget(edge, lastNode);
                lastNode.parent = parent;
                parent.children.add(lastNode);
            }
            ViewHierarchyLoader.updateIndices(scene.getRoot());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                socket.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        System.out.println("==> DONE");
        return scene;
    }

    private static void updateIndices(ViewNode root) {
        if (root == null) {
            return;
        }
        root.computeIndex();
        for (ViewNode node : root.children) {
            ViewHierarchyLoader.updateIndices(node);
        }
    }

    private static int countFrontWhitespace(String line) {
        int count = 0;
        while (line.charAt(count) == ' ') {
            ++count;
        }
        return count;
    }

    private static void loadProperties(ViewNode node, String data) {
        boolean stop;
        int start = 0;
        do {
            int index = data.indexOf(61, start);
            ViewNode.Property property = new ViewNode.Property();
            property.name = data.substring(start, index);
            int index2 = data.indexOf(44, index + 1);
            int length = Integer.parseInt(data.substring(index + 1, index2));
            start = index2 + 1 + length;
            property.value = data.substring(index2 + 1, index2 + 1 + length);
            node.properties.add(property);
            node.namedProperties.put(property.name, property);
            boolean bl = stop = start >= data.length();
            if (stop) continue;
            ++start;
        } while (!stop);
        Collections.sort(node.properties, new Comparator<ViewNode.Property>(){

            @Override
            public int compare(ViewNode.Property source, ViewNode.Property destination) {
                return source.name.compareTo(destination.name);
            }
        });
        node.decode();
    }
}

